/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.km.ejb.svc.idxsearch.index;

import com.sap.caf.km.ejb.svc.idxsearch.common.IIndex;
import com.sap.caf.km.ejb.svc.idxsearch.common.IIndexSearchIndexSvc;
import com.sap.caf.km.ejb.svc.idxsearch.common.IIndexSearchResourceKeys;
import com.sap.caf.km.ejb.svc.idxsearch.common.IndexException;
import com.sap.caf.km.ejb.svc.idxsearch.common.IndexSearchException;
import com.sap.caf.km.ejb.svc.idxsearch.index.KMIndex;
import com.sap.caf.km.ejb.svc.idxsearch.kmproxy.KMIndexSearchSvcProxy;
import com.sap.caf.km.proxies.svc.idxsearch.types.IKMIndex;

public class KMIndexSearchIndexSvc
extends KMIndexSearchSvcProxy
implements IIndexSearchIndexSvc,
IIndexSearchResourceKeys {
    public boolean existsIndex(String indexId) throws IndexException {
        try {
            return this.m_port.existsIndex(indexId);
        }
        catch (Exception e) {
            throw new IndexException("ERR_IDX_CHECK", new Object[]{indexId}, (Throwable)e);
        }
    }

    public IIndex getIndex(String indexId) throws IndexException {
        try {
            IKMIndex index = this.m_port.getIndex(indexId);
            return new KMIndex(index.getName(), index.getState());
        }
        catch (Exception e) {
            throw new IndexException("ERR_IDX_GET", new Object[]{indexId}, (Throwable)e);
        }
    }

    public void clearIndex(String indexId) throws IndexException {
        try {
            this.m_port.clearIndex(indexId);
        }
        catch (Exception e) {
            throw new IndexException("ERR_IDX_GET", new Object[]{indexId}, (Throwable)e);
        }
    }

    public IIndex[] getAllIndexes() throws IndexException {
        try {
            IKMIndex[] stubs = this.m_port.getAllIndexes();
            IIndex[] locals = new IIndex[stubs.length];
            for (int i = 0; i < stubs.length; ++i) {
                locals[i] = new KMIndex(stubs[i].getName(), stubs[i].getState());
            }
            return locals;
        }
        catch (Exception e) {
            throw new IndexException("ERR_IDX_GET_ALL", (Throwable)e);
        }
    }

    public void createFolderIndex(String indexId, String[] folderRids) throws IndexException {
        try {
            this.m_port.createFolderIndex(indexId, folderRids);
        }
        catch (Exception e) {
            throw new IndexException("ERR_IDX_CREATE", new Object[]{indexId}, (Throwable)e);
        }
    }

    public void deleteIndex(String indexId) throws IndexException {
        try {
            this.m_port.deleteIndex(indexId);
        }
        catch (Exception e) {
            throw new IndexException("ERR_IDX_DELETE", new Object[]{indexId}, (Throwable)e);
        }
    }

    public void indexObjects(String indexId, String[] objectsRids) throws IndexException {
        try {
            this.m_port.indexObjects(indexId, objectsRids);
        }
        catch (Exception e) {
            throw new IndexException("ERR_IDX_OBJ_CREATE", new Object[]{indexId}, (Throwable)e);
        }
    }

    public void deindexObjects(String indexId, String[] objectsRids) throws IndexException {
        try {
            this.m_port.deindexObjects(indexId, objectsRids);
        }
        catch (Exception e) {
            throw new IndexException("ERR_IDX_OBJ_DELETE", new Object[]{indexId}, (Throwable)e);
        }
    }

    public void reindex(String indexId) throws IndexException {
        try {
            this.m_port.reindex(indexId);
        }
        catch (Exception e) {
            throw new IndexException("ERR_IDX_REINDEX", new Object[]{indexId}, (Throwable)e);
        }
    }

    public void reindexRelatedIndex(String indexId, String mofId) throws IndexException {
        try {
            this.m_port.reindexRelatedIndex(indexId, mofId);
        }
        catch (Exception e) {
            throw new IndexException("ERR_IDX_REINDEX", new Object[]{indexId}, (Throwable)e);
        }
    }

    public void createRelatedIndex(String indexId, String mofId) throws IndexException {
        try {
            this.m_port.createRelatedIndex(indexId, mofId);
        }
        catch (Exception e) {
            throw new IndexException("ERR_IDX_CREATE", new Object[]{indexId}, (Throwable)e);
        }
    }

    public void deltaReindex(String indexId) throws IndexException {
        try {
            this.m_port.deltaReindex(indexId);
        }
        catch (Exception e) {
            throw new IndexException("ERR_IDX_REINDEX", new Object[]{indexId}, (Throwable)e);
        }
    }
}

