/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.km.ejb.svc.idxsearch.classify;

import com.sap.caf.km.ejb.svc.idxsearch.bo.BODbHelper;
import com.sap.caf.km.ejb.svc.idxsearch.util.ConnectionManager;
import com.sap.caf.rt.metamodel.MetaModel;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class KMClassifyHelper
extends BODbHelper {
    public KMClassifyHelper(ConnectionManager manager) {
        super(manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assignCategory(Collection catGUIDs, String BOName) throws SQLException {
        Connection conn = this.m_manager.getConnection();
        try {
            BigDecimal boId = this.getBusinessObjectId(conn, BOName);
            Iterator i = catGUIDs.iterator();
            while (i.hasNext()) {
                String catGUID = (String)i.next();
                PreparedStatement pstmt = conn.prepareStatement("insert into CAF_RT_BO_CAT (BO_ID,CAT_GUID) values (?,?)");
                try {
                    pstmt.setBigDecimal(1, boId);
                    pstmt.setString(2, catGUID);
                    pstmt.execute();
                }
                finally {
                    pstmt.close();
                }
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            conn.close();
        }
    }

    public void deassignCategory(Collection catGUIDs, String BOName) throws SQLException {
        Connection conn = this.m_manager.getConnection();
        try {
            Iterator i = catGUIDs.iterator();
            while (i.hasNext()) {
                String catGUID = (String)i.next();
                this.deassignCategory(conn, catGUID, BOName);
                this.deleteCategory(conn, catGUID, BOName);
                this.deleteBusinessObject(conn, BOName);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            conn.close();
        }
    }

    public void deassignCategory(String catGUID) throws SQLException {
        Connection conn = this.m_manager.getConnection();
        try {
            this.deassignCategory(conn, catGUID);
            this.deleteCategory(conn, catGUID);
            this.deleteBusinessObjects(conn);
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deassignCategory(Connection conn, String catGUID) throws SQLException {
        PreparedStatement pstmt = conn.prepareStatement("delete from CAF_RT_BO_CAT where CAT_GUID=?");
        try {
            pstmt.setString(1, catGUID);
            pstmt.execute();
        }
        finally {
            pstmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deassignCategory(Connection conn, String catGUID, String BOName) throws SQLException {
        PreparedStatement pstmt = conn.prepareStatement("delete from CAF_RT_BO_CAT where BO_ID=(select BO_ID from CAF_RT_BO where BO_NAME=? and CAT_GUID=?)");
        try {
            pstmt.setString(1, BOName);
            pstmt.setString(2, catGUID);
            pstmt.execute();
        }
        finally {
            pstmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteCategory(Connection conn, String catGUID, String BOName) throws SQLException {
        try {
            String sBoGuidsFilter = this.getBOGuidsByBONameSQL(BOName);
            if (sBoGuidsFilter == null) {
                return;
            }
            PreparedStatement pstmt = conn.prepareStatement("delete from CAF_RT_BO_CAT where BO_ID=(select BO_ID from CAF_RT_BO where BO_NAME=? and CAT_GUID=?)");
            try {
                pstmt.setString(1, BOName);
                pstmt.setString(2, catGUID);
                pstmt.execute();
            }
            finally {
                pstmt.close();
            }
            String sCatValsDelStmt = new StringBuffer(256).append("delete from CAF_RT_CAT_VAL_BO where CAT_GUID=? and BO_GUID in ").append('(').append(sBoGuidsFilter).append(')').toString();
            pstmt = conn.prepareStatement(sCatValsDelStmt);
            try {
                pstmt.setString(1, catGUID);
                pstmt.execute();
            }
            finally {
                pstmt.close();
            }
        }
        catch (Exception e) {
            throw new SQLException("Could not delete category");
        }
    }

    protected String getBOGuidsByBONameSQL(String BOName) throws Exception {
        MetaModel mmr = new MetaModel();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteCategory(Connection conn, String catGUID) throws SQLException {
        PreparedStatement pstmt = conn.prepareStatement("delete from CAF_RT_BO_CAT where CAT_GUID=?");
        try {
            pstmt.setString(1, catGUID);
            pstmt.execute();
        }
        finally {
            pstmt.close();
        }
        pstmt = conn.prepareStatement("delete from CAF_RT_CAT_VAL_BO where CAT_GUID=?");
        try {
            pstmt.setString(1, catGUID);
            pstmt.execute();
        }
        finally {
            pstmt.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getCategories(String BOName) throws SQLException {
        Connection conn = this.m_manager.getConnection();
        try {
            ArrayList<String> arrayList;
            ResultSet rs;
            PreparedStatement pstmt;
            ArrayList<String> guids;
            block9: {
                guids = new ArrayList<String>();
                pstmt = conn.prepareStatement("select CAT_GUID from CAF_RT_BO B,CAF_RT_BO_CAT C where  B.BO_ID=C.BO_ID and B.BO_NAME=?");
                pstmt.setString(1, BOName);
                rs = pstmt.executeQuery();
                if (rs.next()) break block9;
                ArrayList<String> arrayList2 = guids;
                pstmt.close();
                return arrayList2;
            }
            try {
                int iColCatGUID = rs.findColumn("CAT_GUID");
                do {
                    guids.add(rs.getString(iColCatGUID));
                } while (rs.next());
                arrayList = guids;
            }
            catch (Throwable throwable) {
                pstmt.close();
                throw throwable;
            }
            pstmt.close();
            return arrayList;
        }
        finally {
            conn.close();
        }
    }

    public void addClassification(Collection valueGUIDs, String BOGUID, String categoryGUID) throws SQLException {
        Connection conn = this.m_manager.getConnection();
        try {
            PreparedStatement pstmt = conn.prepareStatement("insert into CAF_RT_CAT_VAL_BO (BO_GUID,CAT_VAL_GUID,CAT_GUID) values (?,?,?)");
            pstmt.setString(1, BOGUID);
            pstmt.setString(3, categoryGUID);
            Iterator i = valueGUIDs.iterator();
            while (i.hasNext()) {
                String valueGUID = (String)i.next();
                pstmt.setString(2, valueGUID);
                pstmt.execute();
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            conn.close();
        }
    }

    public void removeClassification(Collection valueGUIDs, String BOGUID) throws SQLException {
        Connection conn = this.m_manager.getConnection();
        try {
            PreparedStatement pstmt = conn.prepareStatement("delete from CAF_RT_CAT_VAL_BO where BO_GUID=? and CAT_VAL_GUID=?");
            pstmt.setString(1, BOGUID);
            Iterator i = valueGUIDs.iterator();
            while (i.hasNext()) {
                String valueGUID = (String)i.next();
                pstmt.setString(2, valueGUID);
                pstmt.execute();
            }
        }
        catch (SQLException e) {
            throw e;
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getClassification(String BOGUID) throws SQLException {
        Connection conn = this.m_manager.getConnection();
        try {
            PreparedStatement pstmt = conn.prepareStatement("select CAT_VAL_GUID from CAF_RT_CAT_VAL_BO where BO_GUID=?");
            pstmt.setString(1, BOGUID);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) {
                ArrayList arrayList = new ArrayList();
                return arrayList;
            }
            ArrayList<String> guids = new ArrayList<String>();
            do {
                guids.add(rs.getString(1));
            } while (rs.next());
            ArrayList<String> arrayList = guids;
            return arrayList;
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getClassification(String BOGUID, String categoryGUID) throws SQLException {
        Connection conn = this.m_manager.getConnection();
        try {
            PreparedStatement pstmt = conn.prepareStatement("select CAT_VAL_GUID from CAF_RT_CAT_VAL_BO where BO_GUID=? and CAT_GUID=?");
            pstmt.setString(1, BOGUID);
            pstmt.setString(2, categoryGUID);
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) {
                ArrayList arrayList = new ArrayList();
                return arrayList;
            }
            ArrayList<String> guids = new ArrayList<String>();
            do {
                guids.add(rs.getString(1));
            } while (rs.next());
            ArrayList<String> arrayList = guids;
            return arrayList;
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getAssignedClassification(String beMasterTable) throws SQLException {
        Connection conn = this.m_manager.getConnection();
        try {
            PreparedStatement pstmt = beMasterTable == null ? conn.prepareStatement("select BO_GUID, CAT_VAL_GUID, CAT_GUID from CAF_RT_CAT_VAL_BO") : conn.prepareStatement("select BO_GUID, CAT_VAL_GUID, CAT_GUID from CAF_RT_CAT_VAL_BO where BO_GUID in  (select OBJECTKEY  from " + beMasterTable + ")");
            ResultSet rs = pstmt.executeQuery();
            if (!rs.next()) {
                ArrayList arrayList = new ArrayList();
                return arrayList;
            }
            ArrayList<String[]> assignmentGuids = new ArrayList<String[]>();
            int iColBOGUID = rs.findColumn("BO_GUID");
            int iColCatValGUID = rs.findColumn("CAT_VAL_GUID");
            int iColCatGUID = rs.findColumn("CAT_GUID");
            do {
                String[] assignment = new String[]{rs.getString(iColBOGUID), rs.getString(iColCatValGUID), rs.getString(iColCatGUID)};
                assignmentGuids.add(assignment);
            } while (rs.next());
            ArrayList<String[]> arrayList = assignmentGuids;
            return arrayList;
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUsedInClassification(String valueGUID) throws SQLException {
        Connection conn = this.m_manager.getConnection();
        try {
            boolean bl;
            PreparedStatement pstmt = conn.prepareStatement("select count(*) from CAF_RT_CAT_VAL_BO where CAT_VAL_GUID=?");
            try {
                pstmt.setString(1, valueGUID);
                ResultSet rs = pstmt.executeQuery();
                bl = rs.next() ? rs.getInt(1) > 0 : false;
            }
            catch (Throwable throwable) {
                pstmt.close();
                throw throwable;
            }
            pstmt.close();
            return bl;
        }
        finally {
            conn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClassification(Collection valueGUIDs) throws Throwable {
        Connection conn = this.m_manager.getConnection();
        try {
            PreparedStatement pstmt = conn.prepareStatement("delete from CAF_RT_CAT_VAL_BO where CAT_VAL_GUID=?");
            try {
                Iterator i = valueGUIDs.iterator();
                while (i.hasNext()) {
                    String valueGUID = (String)i.next();
                    pstmt.setString(1, valueGUID);
                    pstmt.execute();
                }
            }
            finally {
                pstmt.close();
            }
        }
        catch (Throwable e) {
            throw e;
        }
        finally {
            conn.close();
        }
    }
}

