/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.km.ejb.svc.idxsearch.bean;

import com.sap.caf.km.da.KMDataAccessBean;
import com.sap.caf.km.da.KMDataAccessException;
import com.sap.caf.km.ejb.svc.idxsearch.bo.BOAccessException;
import com.sap.caf.km.ejb.svc.idxsearch.bo.BOAccessor;
import com.sap.caf.km.ejb.svc.idxsearch.classify.IKMIndexSearchClassifySvcFactory;
import com.sap.caf.km.ejb.svc.idxsearch.classify.KMClassifyHelper;
import com.sap.caf.km.ejb.svc.idxsearch.classify.KMIndexSearchClassifySvcFactory;
import com.sap.caf.km.ejb.svc.idxsearch.common.ClassifyException;
import com.sap.caf.km.ejb.svc.idxsearch.common.IIndex;
import com.sap.caf.km.ejb.svc.idxsearch.common.IIndexSearchClassifySvc;
import com.sap.caf.km.ejb.svc.idxsearch.common.IIndexSearchIndexSvc;
import com.sap.caf.km.ejb.svc.idxsearch.common.IIndexSearchResourceKeys;
import com.sap.caf.km.ejb.svc.idxsearch.common.IIndexSearchSearchSvc;
import com.sap.caf.km.ejb.svc.idxsearch.common.ISearchEntry;
import com.sap.caf.km.ejb.svc.idxsearch.common.ISearchResult;
import com.sap.caf.km.ejb.svc.idxsearch.common.IndexException;
import com.sap.caf.km.ejb.svc.idxsearch.common.IndexSearchException;
import com.sap.caf.km.ejb.svc.idxsearch.common.SearchEntry;
import com.sap.caf.km.ejb.svc.idxsearch.common.SearchException;
import com.sap.caf.km.ejb.svc.idxsearch.index.IKMIndexSearchIndexSvcFactory;
import com.sap.caf.km.ejb.svc.idxsearch.index.KMIndexHelper;
import com.sap.caf.km.ejb.svc.idxsearch.index.KMIndexSearchIndexSvcFactory;
import com.sap.caf.km.ejb.svc.idxsearch.index.KMIndexUtil;
import com.sap.caf.km.ejb.svc.idxsearch.search.IKMIndexSearchSearchSvcFactory;
import com.sap.caf.km.ejb.svc.idxsearch.search.KMIndexSearchSearchSvcFactory;
import com.sap.caf.km.ejb.svc.idxsearch.search.KMSearchHelper;
import com.sap.caf.km.ejb.svc.idxsearch.search.KMSearchResultLocal;
import com.sap.caf.km.ejb.svc.idxsearch.util.ConnectionManager;
import com.sap.caf.km.ejb.svc.idxsearch.util.IndexCache;
import com.sap.caf.metamodel.BusinessEntityInterface;
import com.sap.caf.metamodel.DataObject;
import com.sap.caf.metamodel.Table;
import com.sap.caf.rt.bol.context.CAFContext;
import com.sap.caf.rt.bol.util.QueryFilter;
import com.sap.caf.rt.metamodel.MetaModel;
import com.sap.tc.logging.Location;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.ejb.CreateException;
import javax.ejb.SessionContext;

public class IndexSearchBean
extends KMDataAccessBean
implements IIndexSearchResourceKeys {
    private static final String APPLICATION = (class$com$sap$caf$km$ejb$svc$idxsearch$bean$IndexSearchBean == null ? (class$com$sap$caf$km$ejb$svc$idxsearch$bean$IndexSearchBean = IndexSearchBean.class$("com.sap.caf.km.ejb.svc.idxsearch.bean.IndexSearchBean")) : class$com$sap$caf$km$ejb$svc$idxsearch$bean$IndexSearchBean).getName();
    private static final String jARMReqPrefix = "CAF:RT:oal:";
    private static final String JARM_REQUEST = "CAF:RT:oal:" + APPLICATION;
    private static final Location location = Location.getLocation((String)APPLICATION);
    private static final Collection EMPTY_SEARCH_RESULT = Arrays.asList(new ISearchResult[0]);
    private transient SessionContext m_sessionContext;
    private transient IIndexSearchIndexSvc m_indexSvc;
    private transient IIndexSearchClassifySvc m_classifySvc;
    private transient IIndexSearchSearchSvc m_searchSvc;
    private transient KMIndexHelper m_idxHelper;
    private transient KMClassifyHelper m_clsHelper;
    private transient KMSearchHelper m_searchHelper;
    private transient BOAccessor m_accessor;
    private transient IndexCache m_cache;
    private String m_sTaxonomyPrefix;
    private int m_max_search_results;
    static /* synthetic */ Class class$com$sap$caf$km$ejb$svc$idxsearch$bean$IndexSearchBean;

    public void ejbCreate() throws CreateException {
        String method = JARM_REQUEST + ":ejbCreate()";
        this.enter(method, null);
        try {
            IKMIndexSearchIndexSvcFactory svcIdxFactory = KMIndexSearchIndexSvcFactory.getInstance();
            this.m_indexSvc = svcIdxFactory.getIndexService();
            IKMIndexSearchClassifySvcFactory svcClsFactory = KMIndexSearchClassifySvcFactory.getInstance();
            this.m_classifySvc = svcClsFactory.getClassifyService();
            IKMIndexSearchSearchSvcFactory svcSearchFactory = KMIndexSearchSearchSvcFactory.getInstance();
            this.m_searchSvc = svcSearchFactory.getSearchService();
            this.m_max_search_results = svcSearchFactory.getMaxSearchResults();
            this.m_cache = IndexCache.getInstance();
            this.m_idxHelper = new KMIndexHelper(ConnectionManager.getInstance());
            this.m_clsHelper = new KMClassifyHelper(ConnectionManager.getInstance());
            this.m_accessor = BOAccessor.getInstance();
        }
        catch (Exception e) {
            IndexSearchException indexSearchEx = new IndexSearchException("ERR_EJB_CREATE", (Throwable)e);
            this.log((KMDataAccessException)indexSearchEx, method, null);
            throw new CreateException(indexSearchEx.getLocalizedMessage());
        }
        finally {
            this.exit(method, null);
        }
    }

    public IIndex createIndexForCAFBO(String BOName) throws IndexException {
        String method = JARM_REQUEST + ":createIndexForCAFBO(String)";
        this.enter(method, new Object[]{BOName});
        try {
            String sIndexId = KMIndexUtil.getIndexId(BOName);
            this.m_indexSvc.createFolderIndex(sIndexId, new String[]{KMIndexUtil.getFolderRID(BOName)});
            this.m_cache.invalidate();
            this.m_idxHelper.assignIndex(BOName, sIndexId, 1);
            IIndex iIndex = this.m_indexSvc.getIndex(sIndexId);
            return iIndex;
        }
        catch (Exception e) {
            IndexException indexEx = new IndexException("ERR_IDX_PROPER_CREATE", new Object[]{BOName}, (Throwable)e);
            this.log((KMDataAccessException)indexEx, method, null);
            throw indexEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void deleteIndexForCAFBO(String BOName) throws IndexException {
        String method = JARM_REQUEST + ":deleteIndexForCAFBO(String)";
        this.enter(method, new Object[]{BOName});
        try {
            this.m_indexSvc.deleteIndex(KMIndexUtil.getIndexId(BOName));
            this.m_cache.invalidate();
            this.m_idxHelper.unassignIndex(BOName, 1);
        }
        catch (Exception e) {
            IndexException indexEx = new IndexException("ERR_IDX_PROPER_DELETE", new Object[]{BOName}, (Throwable)e);
            this.log((KMDataAccessException)indexEx, method, null);
            throw indexEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public IIndex createRelatedIndexForCAFBO(String BOName) throws IndexException {
        String method = JARM_REQUEST + ":createRelatedIndexForCAFBO(String)";
        this.enter(method, new Object[]{BOName});
        try {
            String sIndexId = KMIndexUtil.getRelatedIndexId(BOName);
            this.m_indexSvc.createRelatedIndex(sIndexId, KMIndexUtil.getFolderRID(BOName));
            this.m_cache.invalidate();
            this.m_idxHelper.assignIndex(BOName, sIndexId, 2);
            IIndex iIndex = this.m_indexSvc.getIndex(sIndexId);
            return iIndex;
        }
        catch (Exception e) {
            IndexException indexEx = new IndexException("ERR_IDX_RELATED_CREATE", new Object[]{BOName}, (Throwable)e);
            this.log((KMDataAccessException)indexEx, method, null);
            throw indexEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void deleteRelatedIndexForCAFBO(String BOName) throws IndexException {
        String method = JARM_REQUEST + ":deleteRelatedIndexForCAFBO(String)";
        this.enter(method, new Object[]{BOName});
        try {
            this.m_indexSvc.deleteIndex(KMIndexUtil.getRelatedIndexId(BOName));
            this.m_idxHelper.unassignIndex(BOName, 2);
            this.m_cache.invalidate();
        }
        catch (Exception e) {
            IndexException indexEx = new IndexException("ERR_IDX_RELATED_DELETE", new Object[]{BOName}, (Throwable)e);
            this.log((KMDataAccessException)indexEx, method, null);
            throw indexEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void invalidateIndexCache() {
        String method = JARM_REQUEST + ":invalidateIndexCache()";
        this.enter(method, null);
        this.m_cache.invalidate();
        this.exit(method, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IIndex[] getAllIndexes() throws IndexException {
        String method = JARM_REQUEST + ":getAllIndexes()";
        this.enter(method, null);
        try {
            IIndex[] iIndexArray = this.m_cache;
            synchronized (this.m_cache) {
                if (!this.m_cache.isValid()) {
                    this.info(method, "Index Cache is not valid, collect indexes", null);
                    IIndex[] remoteIdxs = this.m_indexSvc.getAllIndexes();
                    this.info(method, "Remote indexes count: {0}", new Object[]{new Integer(remoteIdxs.length)});
                    IIndex[] localIdxs = this.m_idxHelper.getAllIndexes();
                    this.info(method, "Local indexes count: {0}", new Object[]{new Integer(localIdxs.length)});
                    this.m_cache.setIndexes(this.m_idxHelper.merge(remoteIdxs, localIdxs));
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                iIndexArray = this.m_cache.getIndexes();
                return iIndexArray;
            }
        }
        catch (Exception e) {
            IndexException indexEx = new IndexException("ERR_IDX_GET_ALL", (Throwable)e);
            this.log((KMDataAccessException)indexEx, method, null);
            throw indexEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public IIndex getIndex(String indexId) throws IndexException {
        String method = JARM_REQUEST + ":getIndex(String)";
        this.enter(method, new Object[]{indexId});
        try {
            IIndex remote = this.m_indexSvc.getIndex(indexId);
            IIndex iIndex = this.m_idxHelper.bless(remote);
            return iIndex;
        }
        catch (Exception e) {
            IndexException indexEx = new IndexException("ERR_IDX_GET", new Object[]{indexId}, (Throwable)e);
            this.log((KMDataAccessException)indexEx, method, null);
            throw indexEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void clearIndex(String indexId) throws IndexException {
        String method = JARM_REQUEST + ":clearIndex(String)";
        this.enter(method, new Object[]{indexId});
        try {
            this.m_indexSvc.clearIndex(indexId);
        }
        catch (Exception e) {
            IndexException indexEx = new IndexException("ERR_IDX_CLEAR", new Object[]{indexId}, (Throwable)e);
            this.log((KMDataAccessException)indexEx, method, null);
            throw indexEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void assignGlobalIndexToKMBO(String indexId, String BOName) throws IndexException {
        String method = JARM_REQUEST + ":assignGlobalIndexToKMBO(String, String)";
        this.enter(method, new Object[]{indexId, BOName});
        try {
            this.m_idxHelper.assignIndex(BOName, indexId, 3);
            this.m_cache.invalidate();
        }
        catch (SQLException e) {
            IndexException indexEx = new IndexException("ERR_IDX_GLOBAL_ASSIGN", new Object[]{indexId, BOName}, (Throwable)e);
            this.log((KMDataAccessException)indexEx, method, null);
            throw indexEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void unassignGlobalIndexFromKMBO(String indexId, String BOName) throws IndexException {
        String method = JARM_REQUEST + ":unassignGlobalIndexFromKMBO(String, String)";
        this.enter(method, new Object[]{indexId, BOName});
        try {
            this.m_idxHelper.unassignIndex(BOName, indexId, 3);
            this.m_cache.invalidate();
        }
        catch (SQLException e) {
            IndexException indexEx = new IndexException("ERR_IDX_GLOBAL_UNASSIGN", new Object[]{indexId, BOName}, (Throwable)e);
            this.log((KMDataAccessException)indexEx, method, null);
            throw indexEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void deleteGlobalIndex(String indexId, String BOName) throws IndexException {
        String method = JARM_REQUEST + ":deleteGlobalIndex(String, String)";
        this.enter(method, new Object[]{indexId, BOName});
        try {
            if (BOName != null) {
                this.unassignGlobalIndexFromKMBO(indexId, BOName);
            }
            this.m_indexSvc.deleteIndex(indexId);
            this.m_cache.invalidate();
        }
        catch (IndexException e) {
            IndexException indexEx = new IndexException("ERR_IDX_GLOBAL_DELETE", new Object[]{indexId, BOName}, (Throwable)e);
            this.log((KMDataAccessException)indexEx, method, null);
            throw indexEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexObject(String BOName, String objectRid) throws IndexException {
        String method = JARM_REQUEST + ":indexObject(String, String )";
        this.enter(method, new Object[]{BOName, objectRid});
        try {
            this.indexObject(BOName, new String[]{objectRid}, 1);
        }
        finally {
            this.exit(method, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexRelatedObject(String BOName, String objectRid) throws IndexException {
        String method = JARM_REQUEST + ":indexRelatedObject(String, String)";
        this.enter(method, new Object[]{BOName, objectRid});
        try {
            this.indexObject(BOName, new String[]{objectRid}, 2);
        }
        finally {
            this.exit(method, null);
        }
    }

    protected void indexObject(String BOName, String[] objectRid, int indexType) throws IndexException {
        String method = JARM_REQUEST + ":indexObject(String, String[], int)";
        this.enter(method, new Object[]{BOName, objectRid, new Integer(indexType)});
        try {
            if (indexType != 1 && indexType != 2) {
                IndexException ex = new IndexException("ERR_IDX_TYPE", new Object[]{new Integer(indexType)});
            }
            if (this.m_idxHelper.checkIndexExist(BOName, indexType)) {
                this.m_indexSvc.indexObjects(indexType == 1 ? KMIndexUtil.getIndexId(BOName) : KMIndexUtil.getRelatedIndexId(BOName), objectRid);
                this.m_cache.invalidate();
            }
        }
        catch (Exception e) {
            IndexException indexEx = new IndexException("ERR_IDX_BO_CREATE", new Object[]{BOName}, (Throwable)e);
            this.log((KMDataAccessException)indexEx, method, null);
            throw indexEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deindexObject(String BOName, String objectRid) throws IndexException {
        String method = JARM_REQUEST + ":deindexObject(String, String)";
        this.enter(method, new Object[]{BOName, objectRid});
        try {
            this.deindexObject(BOName, objectRid, 1);
        }
        finally {
            this.exit(method, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deindexRelatedObject(String BOName, String objectRid) throws IndexException {
        String method = JARM_REQUEST + ":deindexRelatedObject(String, String)";
        this.enter(method, new Object[]{BOName, objectRid});
        try {
            this.deindexObject(BOName, objectRid, 2);
        }
        finally {
            this.exit(method, null);
        }
    }

    protected void deindexObject(String BOName, String objectRid, int indexType) throws IndexException {
        String method = JARM_REQUEST + ":deindexObject(String, String, int)";
        this.enter(method, new Object[]{BOName, objectRid, new Integer(indexType)});
        try {
            if (indexType != 1 && indexType != 2) {
                IndexException ex = new IndexException("ERR_IDX_TYPE", new Object[]{new Integer(indexType)});
            }
            if (this.m_idxHelper.checkIndexExist(BOName, indexType)) {
                this.m_indexSvc.deindexObjects(indexType == 1 ? KMIndexUtil.getIndexId(BOName) : KMIndexUtil.getRelatedIndexId(BOName), new String[]{objectRid});
                this.m_cache.invalidate();
            }
        }
        catch (Exception e) {
            IndexException indexEx = new IndexException("ERR_IDX_BO_DELETE", new Object[]{BOName}, (Throwable)e);
            this.log((KMDataAccessException)indexEx, method, null);
            throw indexEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void reindexProperIndex(String BOName) throws IndexException {
        String method = JARM_REQUEST + ":reindexProperIndex(String)";
        this.enter(method, new Object[]{BOName});
        try {
            String sIndexId = KMIndexUtil.getIndexId(BOName);
            this.m_indexSvc.reindex(sIndexId);
            this.m_idxHelper.assignIndex(BOName, sIndexId, 1);
            this.m_cache.invalidate();
        }
        catch (Exception e) {
            IndexException indexEx = new IndexException("ERR_IDX_PROPER_REINDEX", new Object[]{BOName}, (Throwable)e);
            this.log((KMDataAccessException)indexEx, method, null);
            throw indexEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void reindexRelatedIndex(String BOName) throws IndexException {
        String method = JARM_REQUEST + ":reindexRelatedIndex(String)";
        this.enter(method, new Object[]{BOName});
        try {
            List indices = this.getIndices(BOName, 2);
            if (indices == null || indices.size() != 1) {
                return;
            }
            String sIndexId = (String)indices.get(0);
            this.clearIndex(sIndexId);
            KMSearchHelper helper = this.getSearchHelper();
            String[] relRids = helper.getRelatedKMInstancesRids(BOName);
            if (relRids != null && relRids.length > 0) {
                this.indexObject(BOName, relRids, 2);
            }
            this.m_idxHelper.updateIndexDate(BOName, 2);
            this.m_cache.invalidate();
        }
        catch (Exception e) {
            IndexException indexEx = new IndexException("ERR_IDX_RELATED_REINDEX", new Object[]{BOName}, (Throwable)e);
            this.log((KMDataAccessException)indexEx, method, null);
            throw indexEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void reindexGlobalIndex(String indexId, String BOName) throws IndexException {
        String method = JARM_REQUEST + ":reindexGlobalIndex(String, String)";
        this.enter(method, new Object[]{indexId, BOName});
        try {
            this.m_indexSvc.reindex(indexId);
            this.m_cache.invalidate();
        }
        catch (Exception e) {
            IndexException indexEx = new IndexException("ERR_IDX_GLOBAL_REINDEX", new Object[]{indexId, BOName}, (Throwable)e);
            this.log((KMDataAccessException)indexEx, method, null);
            throw indexEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void deltaReindex(String BOName) throws IndexException {
        String method = JARM_REQUEST + ":deltaReindex(String)";
        this.enter(method, new Object[]{BOName});
        try {
            this.m_indexSvc.deltaReindex(KMIndexUtil.getIndexId(BOName));
            this.m_cache.invalidate();
        }
        catch (Exception e) {
            IndexException indexEx = new IndexException("ERR_IDX_DELTA_REINDEX", new Object[]{BOName}, (Throwable)e);
            this.log((KMDataAccessException)indexEx, method, null);
            throw indexEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public boolean isBOKM(String BOName) throws BOAccessException {
        return this.m_accessor.isBOKM(BOName);
    }

    public boolean isBOCAF(String BOName) throws BOAccessException {
        return this.m_accessor.isBOCAF(BOName);
    }

    public boolean isBOKMDocument(String BOName) throws BOAccessException {
        return this.m_accessor.isBOKMDocument(BOName);
    }

    public boolean isBOKMTask(String BOName) throws BOAccessException {
        return this.m_accessor.isBOKMTask(BOName);
    }

    public String[] getBONames() throws BOAccessException {
        return this.m_accessor.getBONames();
    }

    public Collection getClassifables() throws BOAccessException {
        return this.m_accessor.getClassifables();
    }

    public Collection getSearchAndRetrieval() throws BOAccessException {
        return this.m_accessor.getSearchAndRetrieval();
    }

    public String[] getKMBONames() throws BOAccessException {
        return this.m_accessor.getKMBONames();
    }

    public void assignCategory(String catGUID, String BOName) throws ClassifyException {
        String method = JARM_REQUEST + ":assignCategory(String, String)";
        this.enter(method, new Object[]{catGUID, BOName});
        try {
            ArrayList<String> coll = new ArrayList<String>();
            coll.add(catGUID);
            this.m_clsHelper.assignCategory(coll, BOName);
        }
        catch (Exception e) {
            ClassifyException classifyEx = new ClassifyException("ERR_CAT_ASSIGN", new Object[]{catGUID, BOName}, (Throwable)e);
            this.log((KMDataAccessException)classifyEx, method, null);
            throw classifyEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void assignCategory(Collection catGUIDs, String BOName) throws ClassifyException {
        String method = JARM_REQUEST + ":assignCategory(Collection, String)";
        this.enter(method, new Object[]{catGUIDs, BOName});
        try {
            this.m_clsHelper.assignCategory(catGUIDs, BOName);
        }
        catch (Exception e) {
            ClassifyException classifyEx = new ClassifyException("ERR_CAT_ASSIGN_MANY", new Object[]{BOName}, (Throwable)e);
            this.log((KMDataAccessException)classifyEx, method, null);
            throw classifyEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void deassignCategory(String catGUID, String BOName) throws ClassifyException {
        String method = JARM_REQUEST + ":deassignCategory(String, String)";
        this.enter(method, new Object[]{catGUID, BOName});
        try {
            ArrayList<String> catGUIDs = new ArrayList<String>();
            catGUIDs.add(catGUID);
            this.m_clsHelper.deassignCategory(catGUIDs, BOName);
        }
        catch (Exception e) {
            ClassifyException classifyEx = new ClassifyException("ERR_CAT_UNASSIGN", new Object[]{catGUID, BOName}, (Throwable)e);
            this.log((KMDataAccessException)classifyEx, method, null);
            throw classifyEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void deassignCategory(String catGUID) throws ClassifyException {
        String method = JARM_REQUEST + ":deassignCategory(String)";
        this.enter(method, new Object[]{catGUID});
        try {
            this.m_clsHelper.deassignCategory(catGUID);
        }
        catch (Exception e) {
            ClassifyException classifyEx = new ClassifyException("ERR_CAT_UNASSIGN_ALL", new Object[]{catGUID}, (Throwable)e);
            this.log((KMDataAccessException)classifyEx, method, null);
            throw classifyEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void deassignCategory(Collection catGUIDs, String BOName) throws ClassifyException {
        String method = JARM_REQUEST + ":deassignCategory(Collection, String)";
        this.enter(method, new Object[]{catGUIDs, BOName});
        try {
            this.m_clsHelper.deassignCategory(catGUIDs, BOName);
        }
        catch (Exception e) {
            ClassifyException classifyEx = new ClassifyException("ERR_CAT_UNASSIGN_MANY", new Object[]{BOName}, (Throwable)e);
            this.log((KMDataAccessException)classifyEx, method, null);
            throw classifyEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public Collection getCategories(String BOName) throws ClassifyException {
        String method = JARM_REQUEST + ":getCategories(String)";
        this.enter(method, new Object[]{BOName});
        try {
            Collection collection = this.m_clsHelper.getCategories(BOName);
            return collection;
        }
        catch (Exception e) {
            ClassifyException classifyEx = new ClassifyException("ERR_CAT_GET", new Object[]{BOName}, (Throwable)e);
            this.log((KMDataAccessException)classifyEx, method, null);
            throw classifyEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void addClassification(String valueGUID, String BOGUID, String categoryGUID) throws ClassifyException {
        String method = JARM_REQUEST + ":addClassification(String, String, String)";
        this.enter(method, new Object[]{valueGUID, BOGUID, categoryGUID});
        try {
            ArrayList<String> coll = new ArrayList<String>();
            coll.add(valueGUID);
            this.m_clsHelper.addClassification(coll, BOGUID, categoryGUID);
        }
        catch (Exception e) {
            ClassifyException classifyEx = new ClassifyException("ERR_CAT_VALUE_ASSIGN", (Throwable)e);
            this.log((KMDataAccessException)classifyEx, method, null);
            throw classifyEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void addClassification(Collection valueGUIDs, String BOGUID, String categoryGUID) throws ClassifyException {
        String method = JARM_REQUEST + ":addClassification(Collection, String, String)";
        this.enter(method, new Object[]{valueGUIDs, BOGUID, categoryGUID});
        try {
            this.m_clsHelper.addClassification(valueGUIDs, BOGUID, categoryGUID);
        }
        catch (Exception e) {
            ClassifyException classifyEx = new ClassifyException("ERR_CAT_VALUE_ASSIGN_MANY", (Throwable)e);
            this.log((KMDataAccessException)classifyEx, method, null);
            throw classifyEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void removeClassification(String valueGUID, String BOGUID) throws ClassifyException {
        String method = JARM_REQUEST + ":removeClassification(String, String)";
        this.enter(method, new Object[]{valueGUID, BOGUID});
        try {
            ArrayList<String> valueGUIDs = new ArrayList<String>();
            valueGUIDs.add(valueGUID);
            this.m_clsHelper.removeClassification(valueGUIDs, BOGUID);
        }
        catch (Exception e) {
            ClassifyException classifyEx = new ClassifyException("ERR_CAT_VALUE_UNASSIGN", (Throwable)e);
            this.log((KMDataAccessException)classifyEx, method, null);
            throw classifyEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void removeClassification(Collection valueGUIDs, String BOGUID) throws ClassifyException {
        String method = JARM_REQUEST + ":removeClassification(Collection, String)";
        this.enter(method, new Object[]{valueGUIDs, BOGUID});
        try {
            this.m_clsHelper.removeClassification(valueGUIDs, BOGUID);
        }
        catch (Exception e) {
            ClassifyException classifyEx = new ClassifyException("ERR_CAT_VALUE_UNASSIGN_MANY", (Throwable)e);
            this.log((KMDataAccessException)classifyEx, method, null);
            throw classifyEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public Collection getClassification(String BOGUID) throws ClassifyException {
        String method = JARM_REQUEST + ":getClassification(String)";
        this.enter(method, new Object[]{BOGUID});
        try {
            Collection keys;
            Collection collection = keys = this.m_clsHelper.getClassification(BOGUID);
            return collection;
        }
        catch (Exception e) {
            ClassifyException classifyEx = new ClassifyException("ERR_CAT_GET_VALUES", (Throwable)e);
            this.log((KMDataAccessException)classifyEx, method, null);
            throw classifyEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public Collection getClassification(String BOGUID, String categoryGUID) throws ClassifyException {
        String method = JARM_REQUEST + ":getClassification(String, String)";
        this.enter(method, new Object[]{BOGUID, categoryGUID});
        try {
            Collection keys;
            Collection collection = keys = this.m_clsHelper.getClassification(BOGUID, categoryGUID);
            return collection;
        }
        catch (Exception e) {
            ClassifyException classifyEx = new ClassifyException("ERR_CAT_GET_VALUES", (Throwable)e);
            this.log((KMDataAccessException)classifyEx, method, null);
            throw classifyEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public Collection getAssignedClassification(String BOName) throws ClassifyException {
        String method = JARM_REQUEST + ":getAssignedClassification(String)";
        this.enter(method, new Object[]{BOName});
        try {
            Collection coll;
            if (BOName == null) {
                Collection collection = this.m_clsHelper.getAssignedClassification(null);
                return collection;
            }
            String masterTable = this.getTableByBOName(BOName);
            Collection collection = coll = this.m_clsHelper.getAssignedClassification(masterTable);
            return collection;
        }
        catch (Exception e) {
            ClassifyException classifyEx = new ClassifyException("ERR_CAT_GET_VALUES", (Throwable)e);
            this.log((KMDataAccessException)classifyEx, method, null);
            throw classifyEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public boolean isUsedInClassification(String valueGUID) throws ClassifyException {
        String method = JARM_REQUEST + ":isUsedInClassification(String)";
        this.enter(method, new Object[]{valueGUID});
        try {
            boolean bl = this.m_clsHelper.isUsedInClassification(valueGUID);
            return bl;
        }
        catch (Exception e) {
            ClassifyException classifyEx = new ClassifyException("ERR_CAT_VALUE_CHECK", (Throwable)e);
            this.log((KMDataAccessException)classifyEx, method, null);
            throw classifyEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void removeClassification(String valueGUID) throws ClassifyException {
        String method = JARM_REQUEST + ":removeClassification(String)";
        this.enter(method, new Object[]{valueGUID});
        try {
            ArrayList<String> valueGUIDs = new ArrayList<String>();
            valueGUIDs.add(valueGUID);
            this.m_clsHelper.removeClassification(valueGUIDs);
        }
        catch (Throwable e) {
            ClassifyException classifyEx = new ClassifyException("ERR_CAT_VALUE_DELETE", e);
            this.log((KMDataAccessException)classifyEx, method, null);
            throw classifyEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void removeClassification(Collection valueGUIDs) throws ClassifyException {
        String method = JARM_REQUEST + ":removeClassification(Collection)";
        this.enter(method, new Object[]{valueGUIDs});
        try {
            this.m_clsHelper.removeClassification(valueGUIDs);
        }
        catch (Throwable e) {
            ClassifyException classifyEx = new ClassifyException("ERR_CAT_VALUE_DELETE_MANY", e);
            this.log((KMDataAccessException)classifyEx, method, null);
            throw classifyEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getTaxonomyRepositoryPrefix() throws ClassifyException {
        IndexSearchBean indexSearchBean = this;
        synchronized (indexSearchBean) {
            String string;
            String method = JARM_REQUEST + ":getTaxonomyRepositoryPrefix()";
            this.enter(method, null);
            try {
                if (this.m_sTaxonomyPrefix == null) {
                    this.m_sTaxonomyPrefix = this.m_classifySvc.getTaxonomyRepositoryPrefix();
                }
                string = this.m_sTaxonomyPrefix;
            }
            catch (Throwable throwable) {
                this.exit(method, null);
                throw throwable;
            }
            this.exit(method, null);
            return string;
        }
    }

    public Collection searchForGlobalDoc(Collection queryEntryCollection) throws SearchException {
        String method = JARM_REQUEST + ":searchForGlobalDoc(Collection)";
        this.enter(method, new Object[]{queryEntryCollection});
        try {
            if (queryEntryCollection == null || queryEntryCollection.size() == 0) {
                SearchException searchEx = new SearchException("ERR_SEARCH_PARAMS");
                this.log((KMDataAccessException)searchEx, method, null);
                throw searchEx;
            }
            List globalIndeces = this.getIndices(this.m_accessor.getKMBODocumentName(), 3);
            if (globalIndeces == null || globalIndeces.size() == 0) {
                Collection collection = EMPTY_SEARCH_RESULT;
                return collection;
            }
            ISearchResult[] found = this.m_searchSvc.searchForGlobalResource(queryEntryCollection.toArray(new SearchEntry[0]), globalIndeces.toArray(new String[0]), this.m_max_search_results);
            List<ISearchResult> list = Arrays.asList(found);
            return list;
        }
        catch (Exception e) {
            SearchException searchEx = new SearchException("ERR_SEARCH_GLOBAL_DOCUMENTS", (Throwable)e);
            this.log((KMDataAccessException)searchEx, method, null);
            throw searchEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public Collection searchForGlobalDoc(Collection queryEntryCollection, String startFolderRIDForSearch) throws SearchException {
        String method = JARM_REQUEST + ":searchForGlobalDoc(Collection, String)";
        this.enter(method, new Object[]{queryEntryCollection, startFolderRIDForSearch});
        try {
            if (queryEntryCollection == null || queryEntryCollection.size() == 0) {
                SearchException searchEx = new SearchException("ERR_SEARCH_PARAMS");
                this.log((KMDataAccessException)searchEx, method, null);
                throw searchEx;
            }
            List globalIndeces = this.getIndices(this.m_accessor.getKMBODocumentName(), 3);
            if (globalIndeces == null || globalIndeces.size() == 0) {
                Collection collection = EMPTY_SEARCH_RESULT;
                return collection;
            }
            ISearchResult[] found = this.m_searchSvc.searchForGlobalResource(queryEntryCollection.toArray(new SearchEntry[0]), globalIndeces.toArray(new String[0]), startFolderRIDForSearch, this.m_max_search_results);
            List<ISearchResult> list = Arrays.asList(found);
            return list;
        }
        catch (Exception e) {
            SearchException searchEx = new SearchException("ERR_SEARCH_GLOBAL_DOCUMENTS", (Throwable)e);
            this.log((KMDataAccessException)searchEx, method, null);
            throw searchEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public Collection searchForGlobalTasks(Collection queryEntryCollection) throws SearchException {
        String method = JARM_REQUEST + ":searchForGlobalTasks(Collection)";
        this.enter(method, new Object[]{queryEntryCollection});
        try {
            if (queryEntryCollection == null || queryEntryCollection.size() == 0) {
                SearchException searchEx = new SearchException("ERR_SEARCH_PARAMS");
                this.log((KMDataAccessException)searchEx, method, null);
                throw searchEx;
            }
            List globalIndeces = this.getIndices(this.m_accessor.getKMBOTaskName(), 3);
            if (globalIndeces == null || globalIndeces.size() == 0) {
                Collection collection = EMPTY_SEARCH_RESULT;
                return collection;
            }
            ISearchResult[] found = this.m_searchSvc.searchForGlobalResource(queryEntryCollection.toArray(new SearchEntry[0]), globalIndeces.toArray(new String[0]), this.m_max_search_results);
            List<ISearchResult> list = Arrays.asList(found);
            return list;
        }
        catch (Exception e) {
            SearchException searchEx = new SearchException("ERR_SEARCH_GLOBAL_TASKS", (Throwable)e);
            this.log((KMDataAccessException)searchEx, method, null);
            throw searchEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public Collection searchForGlobalTasks(Collection queryEntryCollection, String startFolderRIDForSearch) throws SearchException {
        String method = JARM_REQUEST + ":searchForGlobalTasks(Collection, String)";
        this.enter(method, new Object[]{queryEntryCollection, startFolderRIDForSearch});
        try {
            if (queryEntryCollection == null || queryEntryCollection.size() == 0) {
                SearchException searchEx = new SearchException("ERR_SEARCH_PARAMS");
                this.log((KMDataAccessException)searchEx, method, null);
                throw searchEx;
            }
            List globalIndeces = this.getIndices(this.m_accessor.getKMBOTaskName(), 3);
            if (globalIndeces == null || globalIndeces.size() == 0) {
                Collection collection = EMPTY_SEARCH_RESULT;
                return collection;
            }
            ISearchResult[] found = this.m_searchSvc.searchForGlobalResource(queryEntryCollection.toArray(new SearchEntry[0]), globalIndeces.toArray(new String[0]), startFolderRIDForSearch, this.m_max_search_results);
            List<ISearchResult> list = Arrays.asList(found);
            return list;
        }
        catch (Exception e) {
            SearchException searchEx = new SearchException("ERR_SEARCH_GLOBAL_TASKS", (Throwable)e);
            this.log((KMDataAccessException)searchEx, method, null);
            throw searchEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public Collection searchForCAFBO(Collection queryEntryCollection, Collection BONames) throws SearchException {
        String method = JARM_REQUEST + ":searchForCAFBO(Collection, Collection)";
        this.enter(method, new Object[]{queryEntryCollection, BONames});
        try {
            if (queryEntryCollection == null || queryEntryCollection.size() == 0 || BONames == null || BONames.size() == 0) {
                SearchException searchEx = new SearchException("ERR_SEARCH_PARAMS");
                this.log((KMDataAccessException)searchEx, method, null);
                throw searchEx;
            }
            List ownIndeces = this.getIndeces(BONames, 1);
            if (ownIndeces == null || ownIndeces.size() == 0) {
                Collection collection = EMPTY_SEARCH_RESULT;
                return collection;
            }
            ISearchResult[] found = this.m_searchSvc.searchForBO(queryEntryCollection.toArray(new SearchEntry[0]), ownIndeces.toArray(new String[0]), this.m_max_search_results);
            List<ISearchResult> list = Arrays.asList(found);
            return list;
        }
        catch (Exception e) {
            SearchException searchEx = new SearchException("ERR_SEARCH_CAF_BO", (Throwable)e);
            this.log((KMDataAccessException)searchEx, method, null);
            throw searchEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public Collection searchForRelatedDocument(Collection queryEntryCollection, Collection BONames) throws SearchException {
        String method = JARM_REQUEST + ":searchForRelatedDocument(Collection, Collection)";
        this.enter(method, new Object[]{queryEntryCollection, BONames});
        try {
            if (queryEntryCollection == null || queryEntryCollection.size() == 0 || BONames == null || BONames.size() == 0) {
                SearchException searchEx = new SearchException("ERR_SEARCH_PARAMS");
                this.log((KMDataAccessException)searchEx, method, null);
                throw searchEx;
            }
            List relatedIndeces = this.getIndeces(BONames, 2);
            if (relatedIndeces == null || relatedIndeces.size() == 0) {
                Collection collection = EMPTY_SEARCH_RESULT;
                return collection;
            }
            ISearchResult[] found = this.m_searchSvc.searchForRelatedResource(queryEntryCollection.toArray(new SearchEntry[0]), relatedIndeces.toArray(new String[0]), 1, this.m_max_search_results);
            List<ISearchResult> list = Arrays.asList(found);
            return list;
        }
        catch (Exception e) {
            SearchException searchEx = new SearchException("ERR_SEARCH_RELATED_DOCUMENTS", (Throwable)e);
            this.log((KMDataAccessException)searchEx, method, null);
            throw searchEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public Collection searchForCAFBOAndRelatedRes(Collection queryEntryCollectionCAF, Collection queryEntryCollectionKM, Collection BONames, int searchKMType) throws SearchException {
        String method = JARM_REQUEST + ":searchForCAFBOAndRelatedRes(Collection, Collection, Collection, int)";
        this.enter(method, new Object[]{queryEntryCollectionCAF, queryEntryCollectionKM, BONames, new Integer(searchKMType)});
        try {
            if (queryEntryCollectionCAF == null || queryEntryCollectionCAF.size() == 0 || queryEntryCollectionKM == null || queryEntryCollectionKM.size() == 0 || BONames == null || BONames.size() == 0) {
                SearchException searchEx = new SearchException("ERR_SEARCH_PARAMS");
                this.log((KMDataAccessException)searchEx, method, null);
                throw searchEx;
            }
            ISearchResult[] foundInOwn = null;
            List ownIndeces = this.getIndeces(BONames, 1);
            if (ownIndeces != null && ownIndeces.size() > 0) {
                foundInOwn = this.m_searchSvc.searchForBO(queryEntryCollectionCAF.toArray(new SearchEntry[0]), ownIndeces.toArray(new String[0]), this.m_max_search_results);
            }
            ISearchResult[] foundInRelated = null;
            List relatedIndeces = this.getIndeces(BONames, 2);
            if (relatedIndeces != null && relatedIndeces.size() > 0) {
                foundInRelated = this.m_searchSvc.searchForRelatedResource(queryEntryCollectionKM.toArray(new SearchEntry[0]), relatedIndeces.toArray(new String[0]), searchKMType, this.m_max_search_results);
            }
            List list = this.mergeToList(foundInOwn, foundInRelated);
            return list;
        }
        catch (Exception e) {
            SearchException searchEx = new SearchException("ERR_SEARCH_CAF_BO_AND_RELATED", (Throwable)e);
            this.log((KMDataAccessException)searchEx, method, null);
            throw searchEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public Collection searchForRelatedTask(Collection queryEntryCollection, Collection BONames) throws SearchException {
        String method = JARM_REQUEST + ":searchForRelatedTask(Collection, Collection)";
        this.enter(method, new Object[]{queryEntryCollection, BONames});
        try {
            if (queryEntryCollection == null || queryEntryCollection.size() == 0 || BONames == null || BONames.size() == 0) {
                SearchException searchEx = new SearchException("ERR_SEARCH_PARAMS");
                this.log((KMDataAccessException)searchEx, method, null);
                throw searchEx;
            }
            List relatedIndeces = this.getIndeces(BONames, 2);
            if (relatedIndeces == null || relatedIndeces.size() == 0) {
                Collection collection = EMPTY_SEARCH_RESULT;
                return collection;
            }
            ISearchResult[] results = this.m_searchSvc.searchForRelatedResource(queryEntryCollection.toArray(new SearchEntry[0]), relatedIndeces.toArray(new String[0]), 0, this.m_max_search_results);
            List<ISearchResult> list = Arrays.asList(results);
            return list;
        }
        catch (Exception e) {
            SearchException searchEx = new SearchException("ERR_SEARCH_RELATED_TASKS", (Throwable)e);
            this.log((KMDataAccessException)searchEx, method, null);
            throw searchEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public Collection searchForAllCAFBO(Collection queryEntryCollection) throws SearchException {
        String method = JARM_REQUEST + ":searchForAllCAFBO(Collection)";
        this.enter(method, new Object[]{queryEntryCollection});
        try {
            if (queryEntryCollection == null || queryEntryCollection.size() == 0) {
                SearchException searchEx = new SearchException("ERR_SEARCH_PARAMS");
                this.log((KMDataAccessException)searchEx, method, null);
                throw searchEx;
            }
            List ownIndeces = this.getIndeces(this.m_accessor.getCAFBONames(), 1);
            if (ownIndeces == null || ownIndeces.size() == 0) {
                Collection collection = EMPTY_SEARCH_RESULT;
                return collection;
            }
            ISearchResult[] results = this.m_searchSvc.searchForBO(queryEntryCollection.toArray(new SearchEntry[0]), ownIndeces.toArray(new String[0]), this.m_max_search_results);
            List<ISearchResult> list = Arrays.asList(results);
            return list;
        }
        catch (Exception e) {
            SearchException searchEx = new SearchException("ERR_SEARCH_CAF_BO", (Throwable)e);
            this.log((KMDataAccessException)searchEx, method, null);
            throw searchEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public Collection searchForAllKMBO(Collection queryEntryCollection) throws SearchException {
        String method = JARM_REQUEST + ":searchForAllKMBO(Collection)";
        this.enter(method, new Object[]{queryEntryCollection});
        try {
            if (queryEntryCollection == null || queryEntryCollection.size() == 0) {
                SearchException searchEx = new SearchException("ERR_SEARCH_PARAMS");
                this.log((KMDataAccessException)searchEx, method, null);
                throw searchEx;
            }
            List globalIndeces = this.getIndeces(Arrays.asList(this.m_accessor.getKMBONames()), 3);
            if (globalIndeces == null || globalIndeces.size() == 0) {
                Collection collection = EMPTY_SEARCH_RESULT;
                return collection;
            }
            ISearchResult[] results = this.m_searchSvc.searchForGlobalResource(queryEntryCollection.toArray(new SearchEntry[0]), globalIndeces.toArray(new String[0]), this.m_max_search_results);
            List<ISearchResult> list = Arrays.asList(results);
            return list;
        }
        catch (Exception e) {
            SearchException searchEx = new SearchException("ERR_SEARCH_KM_BO", (Throwable)e);
            this.log((KMDataAccessException)searchEx, method, null);
            throw searchEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public Collection searchForAllBO(Collection queryEntryCollection) throws SearchException {
        String method = JARM_REQUEST + ":searchForAllBO(queryEntryCollection)";
        this.enter(method, new Object[]{queryEntryCollection});
        try {
            if (queryEntryCollection == null || queryEntryCollection.size() == 0) {
                SearchException searchEx = new SearchException("ERR_SEARCH_PARAMS");
                this.log((KMDataAccessException)searchEx, method, null);
                throw searchEx;
            }
            ISearchEntry[] searchEntries = queryEntryCollection.toArray(new SearchEntry[0]);
            Object[] foundInGlobal = null;
            List globalIndeces = this.getIndeces(Arrays.asList(this.m_accessor.getKMBONames()), 3);
            if (globalIndeces != null && globalIndeces.size() > 0) {
                foundInGlobal = this.m_searchSvc.searchForGlobalResource(searchEntries, globalIndeces.toArray(new String[0]), this.m_max_search_results);
            }
            ISearchResult[] foundInOwn = null;
            List ownIndeces = this.getIndeces(this.m_accessor.getCAFBONames(), 1);
            if (ownIndeces != null && ownIndeces.size() > 0) {
                foundInOwn = this.m_searchSvc.searchForBO(searchEntries, ownIndeces.toArray(new String[0]), this.m_max_search_results);
            }
            List list = this.mergeToList(foundInGlobal, foundInOwn);
            return list;
        }
        catch (Exception e) {
            SearchException searchEx = new SearchException("ERR_SEARCH_ALL_BO", (Throwable)e);
            this.log((KMDataAccessException)searchEx, method, null);
            throw searchEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public Collection searchForSimilarCAF(String resourceRid, int maxResults) throws SearchException {
        String method = JARM_REQUEST + ":searchForSimilarCAF(String, int)";
        this.enter(method, new Object[]{resourceRid, new Integer(maxResults)});
        try {
            if (resourceRid == null) {
                SearchException searchEx = new SearchException("ERR_SEARCH_PARAMS");
                this.log((KMDataAccessException)searchEx, method, null);
                throw searchEx;
            }
            List ownIndeces = this.getIndeces(this.m_accessor.getCAFBONames(), 1);
            if (ownIndeces == null || ownIndeces.size() == 0) {
                Collection collection = EMPTY_SEARCH_RESULT;
                return collection;
            }
            ISearchResult[] results = this.m_searchSvc.searchForSimilar(resourceRid, ownIndeces.toArray(new String[0]), maxResults);
            List<ISearchResult> list = Arrays.asList(results);
            return list;
        }
        catch (Exception e) {
            SearchException searchEx = new SearchException("ERR_SEARCH_CAF_BO_SIMILAR", (Throwable)e);
            this.log((KMDataAccessException)searchEx, method, null);
            throw searchEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public Collection searchForSimilarKM(String resourceRid, boolean useGlobalIndex) throws SearchException {
        String method = JARM_REQUEST + ":searchForSimilarKM(String, boolean)";
        this.enter(method, new Object[]{resourceRid, new Boolean(useGlobalIndex)});
        try {
            if (resourceRid == null) {
                SearchException searchEx = new SearchException("ERR_SEARCH_PARAMS");
                this.log((KMDataAccessException)searchEx, method, null);
                throw searchEx;
            }
            List globalIndeces = this.getIndeces(Arrays.asList(this.m_accessor.getKMBONames()), 3);
            if (globalIndeces == null || globalIndeces.size() == 0) {
                Collection collection = EMPTY_SEARCH_RESULT;
                return collection;
            }
            ISearchResult[] results = this.m_searchSvc.searchForSimilar(resourceRid, globalIndeces.toArray(new String[0]), this.m_max_search_results);
            List<ISearchResult> list = Arrays.asList(results);
            return list;
        }
        catch (Exception e) {
            SearchException searchEx = new SearchException("ERR_SEARCH_KM_BO_SIMILAR", (Throwable)e);
            this.log((KMDataAccessException)searchEx, method, null);
            throw searchEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public Collection searchForBO(String attribute, String freeText, String BOName, boolean isAttribute) throws SearchException {
        String method = JARM_REQUEST + ":searchForBO(String, String, String, boolean)";
        this.enter(method, new Object[]{attribute, freeText, BOName, new Boolean(isAttribute)});
        try {
            if (BOName == null || attribute == null && freeText == null) {
                SearchException searchEx = new SearchException("ERR_SEARCH_PARAMS");
                this.log((KMDataAccessException)searchEx, method, null);
                throw searchEx;
            }
            boolean isBOKM = this.m_accessor.isBOKM(BOName);
            List indeces = this.getIndices(BOName, isBOKM ? 3 : 1);
            if (indeces == null || indeces.size() == 0) {
                Collection collection = EMPTY_SEARCH_RESULT;
                return collection;
            }
            SearchEntry searchEntry = new SearchEntry();
            String[] result = this.convertAttribute(attribute, isAttribute);
            searchEntry.setPropertyNamespace(result[0]);
            searchEntry.setPropertyName(result[1]);
            searchEntry.setValueAsString(freeText);
            searchEntry.setValueType(3);
            searchEntry.setTermAction((byte)1);
            searchEntry.setTermWeight(1.0f);
            searchEntry.setRowType("ATTRIBUTE");
            ISearchEntry[] searchEntries = new ISearchEntry[]{searchEntry};
            ISearchResult[] found = isBOKM ? this.m_searchSvc.searchForGlobalResource(searchEntries, indeces.toArray(new String[0]), this.m_max_search_results) : this.m_searchSvc.searchForBO(searchEntries, indeces.toArray(new String[0]), this.m_max_search_results);
            List<ISearchResult> list = Arrays.asList(found);
            return list;
        }
        catch (Exception e) {
            SearchException searchEx = new SearchException("ERR_SEARCH_BO", (Throwable)e);
            this.log((KMDataAccessException)searchEx, method, null);
            throw searchEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public Collection searchForBO(Collection collAttributesAsString, Collection collCategoriesAsString, String freeText, String BOName) throws SearchException {
        String method = JARM_REQUEST + ":searchForBO(Collection, Collection, String, String)";
        this.enter(method, new Object[]{collAttributesAsString, collAttributesAsString, freeText, BOName});
        try {
            if (BOName == null) {
                SearchException searchEx = new SearchException("ERR_SEARCH_PARAMS");
                this.log((KMDataAccessException)searchEx, method, null);
                throw searchEx;
            }
            if (collAttributesAsString == null) {
                collAttributesAsString = new ArrayList();
            }
            if (collCategoriesAsString == null) {
                collCategoriesAsString = new ArrayList();
            }
            if (collAttributesAsString.size() == 0 && collCategoriesAsString.size() == 0) {
                SearchException searchEx = new SearchException("ERR_SEARCH_PARAMS");
                this.log((KMDataAccessException)searchEx, method, null);
                throw searchEx;
            }
            boolean isBOKM = this.m_accessor.isBOKM(BOName);
            List indeces = this.getIndices(BOName, isBOKM ? 3 : 1);
            if (indeces == null || indeces.size() == 0) {
                Collection collection = EMPTY_SEARCH_RESULT;
                return collection;
            }
            ISearchEntry[] searchEntries = this.createSearchEntries(collAttributesAsString, freeText, true);
            ISearchEntry[] searchEntries2 = this.createSearchEntries(collCategoriesAsString, freeText, false);
            ISearchEntry[] result = new SearchEntry[searchEntries.length + searchEntries2.length];
            System.arraycopy(searchEntries, 0, result, 0, searchEntries.length);
            System.arraycopy(searchEntries2, 0, result, searchEntries.length, searchEntries2.length);
            ISearchResult[] found = isBOKM ? this.m_searchSvc.searchForGlobalResource(searchEntries, indeces.toArray(new String[0]), this.m_max_search_results) : this.m_searchSvc.searchForBO(result, indeces.toArray(new String[0]), this.m_max_search_results);
            List<ISearchResult> list = Arrays.asList(found);
            return list;
        }
        catch (Exception e) {
            SearchException searchEx = new SearchException("ERR_SEARCH_BO", (Throwable)e);
            this.log((KMDataAccessException)searchEx, method, null);
            throw searchEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public Collection searchForBO(Map hashMapofAttributesAsStringAndfreeText, Map hashMapofCategoriesAsStringAndfreeText, String BOName) throws SearchException {
        String method = JARM_REQUEST + ":searchForBO(Map, Map, String)";
        this.enter(method, new Object[]{hashMapofAttributesAsStringAndfreeText, hashMapofCategoriesAsStringAndfreeText, BOName});
        try {
            if (BOName == null) {
                SearchException searchEx = new SearchException("ERR_SEARCH_PARAMS");
                this.log((KMDataAccessException)searchEx, method, null);
                throw searchEx;
            }
            if (hashMapofAttributesAsStringAndfreeText == null) {
                hashMapofAttributesAsStringAndfreeText = new HashMap();
            }
            if (hashMapofCategoriesAsStringAndfreeText == null) {
                hashMapofCategoriesAsStringAndfreeText = new HashMap();
            }
            if (hashMapofAttributesAsStringAndfreeText.size() == 0 && hashMapofCategoriesAsStringAndfreeText.size() == 0) {
                SearchException searchEx = new SearchException("ERR_SEARCH_PARAMS");
                this.log((KMDataAccessException)searchEx, method, null);
                throw searchEx;
            }
            boolean isBOKM = this.m_accessor.isBOKM(BOName);
            List indeces = this.getIndices(BOName, isBOKM ? 3 : 1);
            if (indeces == null || indeces.size() == 0) {
                Collection collection = EMPTY_SEARCH_RESULT;
                return collection;
            }
            ISearchEntry[] searchEntries = this.createSearchEntries(hashMapofAttributesAsStringAndfreeText, true);
            ISearchEntry[] searchEntries2 = this.createSearchEntries(hashMapofCategoriesAsStringAndfreeText, false);
            ISearchEntry[] result = new SearchEntry[searchEntries.length + searchEntries2.length];
            System.arraycopy(searchEntries, 0, result, 0, searchEntries.length);
            System.arraycopy(searchEntries2, 0, result, searchEntries.length, searchEntries2.length);
            ISearchResult[] found = isBOKM ? this.m_searchSvc.searchForGlobalResource(searchEntries, indeces.toArray(new String[0]), this.m_max_search_results) : this.m_searchSvc.searchForBO(result, indeces.toArray(new String[0]), this.m_max_search_results);
            List<ISearchResult> list = Arrays.asList(found);
            return list;
        }
        catch (Exception e) {
            SearchException searchEx = new SearchException("ERR_SEARCH_BO", (Throwable)e);
            this.log((KMDataAccessException)searchEx, method, null);
            throw searchEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public Collection searchForRelatedDoc(Collection collAttributesAsString, String freeText, String BOName) throws SearchException {
        String method = JARM_REQUEST + ":searchForRelatedDoc(Collection, String, String)";
        this.enter(method, new Object[]{collAttributesAsString, freeText, BOName});
        try {
            if (BOName == null || (collAttributesAsString == null || collAttributesAsString.size() == 0) && freeText == null) {
                SearchException searchEx = new SearchException("ERR_SEARCH_PARAMS");
                this.log((KMDataAccessException)searchEx, method, null);
                throw searchEx;
            }
            List relatedIndeces = this.getIndices(BOName, 2);
            if (relatedIndeces == null || relatedIndeces.size() == 0) {
                Collection collection = EMPTY_SEARCH_RESULT;
                return collection;
            }
            ISearchResult[] found = this.m_searchSvc.searchForRelatedResource(this.createSearchEntries(collAttributesAsString, freeText, true), relatedIndeces.toArray(new String[relatedIndeces.size()]), 1, this.m_max_search_results);
            List<ISearchResult> list = Arrays.asList(found);
            return list;
        }
        catch (Exception e) {
            SearchException searchEx = new SearchException("ERR_SEARCH_RELATED_DOCUMENTS", (Throwable)e);
            this.log((KMDataAccessException)searchEx, method, null);
            throw searchEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public Collection searchForBOInRelatedDoc(Collection collAttributesAsString, String freeText, String BOName) throws SearchException {
        String method = JARM_REQUEST + ":searchForBOInRelatedDoc(Collection, String, String)";
        this.enter(method, new Object[]{collAttributesAsString, freeText, BOName});
        try {
            if (BOName == null || (collAttributesAsString == null || collAttributesAsString.size() == 0) && freeText == null) {
                SearchException searchEx = new SearchException("ERR_SEARCH_PARAMS");
                this.log((KMDataAccessException)searchEx, method, null);
                throw searchEx;
            }
            String prefix = CAFContext.KM_REPOSITORY;
            List relatedIndeces = this.getIndices(BOName, 2);
            if (relatedIndeces == null || relatedIndeces.size() == 0) {
                Collection collection = EMPTY_SEARCH_RESULT;
                return collection;
            }
            Collection docs = this.searchForRelatedDoc(collAttributesAsString, freeText, BOName);
            if (docs == null || docs.isEmpty()) {
                Collection collection = EMPTY_SEARCH_RESULT;
                return collection;
            }
            String sBOTypeGuid = this.m_accessor.getGUID(BOName);
            if (sBOTypeGuid == null) {
                throw new NullPointerException("MofId of [" + BOName + "] could not be found in cache!");
            }
            ArrayList<KMSearchResultLocal> results = new ArrayList<KMSearchResultLocal>();
            Iterator it = docs.iterator();
            while (it.hasNext()) {
                ISearchResult searchRes = (ISearchResult)it.next();
                String sRid = searchRes.getRid();
                String sBOGuid = searchRes.getBOGuid();
                String sType = searchRes.getBOName();
                if (!sBOTypeGuid.equals(sType)) continue;
                KMSearchResultLocal result = new KMSearchResultLocal();
                result.setRid(sRid);
                result.setBOGuid(sBOGuid);
                results.add(result);
            }
            ArrayList<KMSearchResultLocal> arrayList = results;
            return arrayList;
        }
        catch (Exception e) {
            SearchException searchEx = new SearchException("ERR_SEARCH_RELATED_BO", (Throwable)e);
            this.log((KMDataAccessException)searchEx, method, null);
            throw searchEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getIndeces(Collection BONames, int indexType) throws IndexException, SQLException {
        String method = JARM_REQUEST + ":getIndeces(Collection, int)";
        this.enter(method, new Object[]{BONames, new Integer(indexType)});
        try {
            if (!this.m_idxHelper.checkAtLeastOneIndexExist(BONames, indexType)) {
                List list = null;
                return list;
            }
            IIndex[] allIndeces = this.getAllIndexes();
            ArrayList<String> boIndeces = new ArrayList<String>();
            Iterator j = BONames.iterator();
            while (j.hasNext()) {
                String BOName = (String)j.next();
                for (int i = 0; i < allIndeces.length; ++i) {
                    IIndex index = allIndeces[i];
                    if (index.getType() != indexType || !BOName.equals(index.getBOName())) continue;
                    String indexName = index.getName();
                    boIndeces.add(indexName);
                    this.info(method, "index name:[{0}]", new Object[]{indexName});
                }
            }
            ArrayList<String> arrayList = boIndeces;
            return arrayList;
        }
        finally {
            this.exit(method, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getIndices(String BOName, int indexType) throws IndexException, SQLException {
        String method = JARM_REQUEST + ":getIndeces(String, int)";
        this.enter(method, new Object[]{BOName, new Integer(indexType)});
        try {
            if (!this.m_idxHelper.checkIndexExist(BOName, indexType)) {
                List list = null;
                return list;
            }
            IIndex[] allIndeces = this.getAllIndexes();
            ArrayList<String> boIndeces = new ArrayList<String>();
            for (int i = 0; i < allIndeces.length; ++i) {
                IIndex index = allIndeces[i];
                if (index.getType() != indexType || !BOName.equals(index.getBOName())) continue;
                boIndeces.add(index.getName());
            }
            ArrayList<String> arrayList = boIndeces;
            return arrayList;
        }
        finally {
            this.exit(method, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISearchEntry[] createSearchEntries(Collection attributes, String text, boolean isAttribute) {
        String method = JARM_REQUEST + ":createSearchEntries(Collection, String)";
        this.enter(method, new Object[]{attributes, text, new Boolean(isAttribute)});
        try {
            ISearchEntry searchEntry;
            StringTokenizer strTokenizer = new StringTokenizer(text);
            int size = strTokenizer.countTokens() * 2 - 1 + attributes.size() * 2;
            ISearchEntry[] searchEntries = new ISearchEntry[size];
            int entryNumber = -1;
            while (strTokenizer.hasMoreTokens()) {
                searchEntry = this.buildStringSearchEntry(strTokenizer.nextToken());
                searchEntries[++entryNumber] = searchEntry;
                if (!strTokenizer.hasMoreTokens()) continue;
                searchEntry = this.buildOperatorSearchEntry("AND");
                searchEntries[++entryNumber] = searchEntry;
            }
            Iterator i = attributes.iterator();
            while (i.hasNext()) {
                searchEntry = this.buildOperatorSearchEntry("AND");
                searchEntries[++entryNumber] = searchEntry;
                searchEntry = this.buildPropertySearchEntry((String)i.next(), text, isAttribute);
                searchEntries[++entryNumber] = searchEntry;
            }
            ISearchEntry[] iSearchEntryArray = searchEntries;
            return iSearchEntryArray;
        }
        finally {
            this.exit(method, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ISearchEntry[] createSearchEntries(Map attributesAndTexts, boolean isAttribute) {
        String method = JARM_REQUEST + ":createSearchEntries(Map, boolean)";
        this.enter(method, new Object[]{attributesAndTexts, new Boolean(isAttribute)});
        try {
            ISearchEntry[] result;
            ArrayList<ISearchEntry> searchEntries = new ArrayList<ISearchEntry>();
            Iterator i = attributesAndTexts.entrySet().iterator();
            while (i.hasNext()) {
                ISearchEntry searchEntry;
                Map.Entry entry = i.next();
                String attribute = (String)entry.getKey();
                String text = (String)entry.getValue();
                StringTokenizer strTokenizer = new StringTokenizer(text);
                while (strTokenizer.hasMoreTokens()) {
                    searchEntry = this.buildPropertySearchEntry(attribute, strTokenizer.nextToken(), isAttribute);
                    searchEntries.add(searchEntry);
                    if (!strTokenizer.hasMoreTokens()) continue;
                    searchEntry = this.buildOperatorSearchEntry("AND");
                    searchEntries.add(searchEntry);
                }
                if (!i.hasNext()) continue;
                searchEntry = this.buildOperatorSearchEntry("AND");
                searchEntries.add(searchEntry);
            }
            ISearchEntry[] iSearchEntryArray = result = (ISearchEntry[])searchEntries.toArray(new SearchEntry[0]);
            return iSearchEntryArray;
        }
        finally {
            this.exit(method, null);
        }
    }

    protected List mergeToList(Object[] a, Object[] b) {
        int lenA = a != null ? a.length : 0;
        int lenB = b != null ? b.length : 0;
        ArrayList<Object> res = new ArrayList<Object>(lenA + lenB);
        if (lenA > 0) {
            res.addAll(Arrays.asList(a));
        }
        if (lenB > 0) {
            res.addAll(Arrays.asList(b));
        }
        return res;
    }

    protected ISearchEntry buildOperatorSearchEntry(String operator) {
        SearchEntry searchEntry = new SearchEntry();
        searchEntry.setRowType("OPERATOR");
        searchEntry.setValueAsString(operator);
        searchEntry.setValueType(3);
        return searchEntry;
    }

    protected ISearchEntry buildStringSearchEntry(String value) {
        SearchEntry searchEntry = new SearchEntry();
        searchEntry.setValueAsString(value);
        searchEntry.setValueType(3);
        searchEntry.setTermAction((byte)1);
        searchEntry.setTermWeight(1.0f);
        searchEntry.setRowType("TERM");
        return searchEntry;
    }

    protected ISearchEntry buildPropertySearchEntry(String propertyName, String value, boolean isAttribute) {
        SearchEntry searchEntry = new SearchEntry();
        String[] result = this.convertAttribute(propertyName, isAttribute);
        searchEntry.setPropertyNamespace(result[0]);
        searchEntry.setPropertyName(result[1]);
        searchEntry.setValueAsString(value);
        searchEntry.setValueType(3);
        searchEntry.setTermAction((byte)1);
        searchEntry.setTermWeight(1.0f);
        searchEntry.setRowType("ATTRIBUTE");
        return searchEntry;
    }

    protected KMSearchHelper getSearchHelper() {
        if (this.m_searchHelper == null) {
            this.m_searchHelper = new KMSearchHelper();
        }
        return this.m_searchHelper;
    }

    private String[] convertAttribute(String propertyName, boolean isAttribute) {
        String[] result = new String[2];
        if (isAttribute) {
            if (propertyName.equals("createdBy")) {
                result[0] = "http://sapportals.com/xmlns/cm";
                result[1] = "createdby";
            } else if (propertyName.equals("createdAt")) {
                result[0] = "http://sapportals.com/xmlns/cm";
                result[1] = "created";
            } else if (propertyName.equals("lastChangedBy")) {
                result[0] = "http://sapportals.com/xmlns/cm";
                result[1] = "modifiedby";
            } else if (propertyName.equals("lastChangedAt")) {
                result[0] = "http://sapportals.com/xmlns/cm";
                result[1] = "modified";
            } else {
                result[0] = "http://sap.com/caf/attributes";
                result[1] = propertyName;
            }
        } else {
            result[0] = "http://sap.com/caf/categories";
            result[1] = propertyName;
        }
        return result;
    }

    private String getTableByBOName(String fullBOName) throws SearchException {
        String method = JARM_REQUEST + ":getTableByBOName(String)";
        this.enter(method, new Object[]{fullBOName});
        try {
            String sMasterTable;
            MetaModel mmr = new MetaModel();
            DataObject dataObject = mmr.getDataObject(fullBOName);
            if (dataObject == null) {
                SearchException searchEx = new SearchException("No corresponding data object for {0} bo name", (Object[])new String[]{fullBOName});
                this.log((KMDataAccessException)searchEx, method, null);
                throw searchEx;
            }
            BusinessEntityInterface be = dataObject.getBusinessEntityInterface();
            Table table = be.getBusinessEntity().getMasterTable();
            if (table == null) {
                SearchException searchEx = new SearchException("No master table for business entity {0}", (Object[])new String[]{fullBOName});
                this.log((KMDataAccessException)searchEx, method, null);
                throw searchEx;
            }
            String string = sMasterTable = table.getTableName();
            return string;
        }
        catch (Exception e) {
            SearchException searchEx = new SearchException(e.getMessage());
            this.log((KMDataAccessException)searchEx, method, null);
            throw searchEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public Collection searchForBO(Collection filter, String BOName) throws SearchException {
        String method = JARM_REQUEST + ":searchForBO(Collection, String)";
        this.enter(method, new Object[]{filter, BOName});
        try {
            boolean isBOKM;
            List indeces;
            if (BOName == null) {
                SearchException searchEx = new SearchException("ERR_SEARCH_PARAMS");
                this.log((KMDataAccessException)searchEx, method, null);
                throw searchEx;
            }
            Object col = null;
            ISearchEntry[] entries = null;
            if (filter == null) {
                filter = new ArrayList();
            }
            if ((indeces = this.getIndices(BOName, (isBOKM = this.m_accessor.isBOKM(BOName)) ? 3 : 1)) == null || indeces.size() == 0) {
                Collection collection = EMPTY_SEARCH_RESULT;
                return collection;
            }
            Vector vec = new Vector();
            Iterator it = filter.iterator();
            while (it.hasNext()) {
                Object obj = it.next();
                if (!(obj instanceof QueryFilter)) {
                    throw new SearchException("Search query contains a wrong type of filter", new Object[0]);
                }
                QueryFilter tmpFilter = (QueryFilter)obj;
                vec.addAll(SearchEntry.createSearchEntry(tmpFilter, BOName));
            }
            entries = vec.toArray(new SearchEntry[0]);
            ISearchResult[] found = isBOKM ? this.m_searchSvc.searchForGlobalResource(entries, indeces.toArray(new String[0]), this.m_max_search_results) : this.m_searchSvc.searchForBO(entries, indeces.toArray(new String[0]), this.m_max_search_results);
            List<ISearchResult> list = Arrays.asList(found);
            return list;
        }
        catch (Exception e) {
            SearchException searchEx = new SearchException("ERR_SEARCH_BO", (Throwable)e);
            this.log((KMDataAccessException)searchEx, method, null);
            throw searchEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public Collection searchForBO(String attribute, String freeText, String BOName) throws SearchException {
        return null;
    }

    public Collection searchForBO(Collection collAttributesAsString, String freeText, String BOName) throws SearchException {
        return null;
    }

    public Collection searchForBO(Map hashMapofAttributesAsStringAndfreeText, String BOName) throws SearchException {
        return null;
    }

    protected Location getLocation() {
        return location;
    }

    protected String getJARMRequest() {
        return JARM_REQUEST;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

