/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.km.ejb.data.task;

import com.sap.caf.km.da.KMDataAccessBean;
import com.sap.caf.km.da.KMDataAccessException;
import com.sap.caf.km.ejb.data.util.IKMTaskExceptionResourceKeys;
import com.sap.caf.km.ejb.data.util.ITaskContent;
import com.sap.caf.km.ejb.data.util.ITaskHeader;
import com.sap.caf.km.ejb.data.util.KMTaskException;
import com.sap.caf.km.ejb.data.util.TaskContent;
import com.sap.caf.km.ejb.data.util.TaskHeader;
import com.sap.caf.km.proxies.data.task.KMTaskService;
import com.sap.caf.km.proxies.data.task.KMTaskServiceService;
import com.sap.caf.km.proxies.data.task.WSProxyException;
import com.sap.caf.km.proxies.data.task.types.IKMTaskAttribute;
import com.sap.caf.km.proxies.data.task.types.IKMTaskContent;
import com.sap.caf.km.proxies.data.task.types.IKMTaskHeader;
import com.sap.caf.km.proxies.data.task.types.IKMTaskList;
import com.sap.caf.km.proxies.data.task.types.IKMUserContextExt;
import com.sap.tc.logging.Location;
import java.util.ArrayList;
import javax.ejb.CreateException;
import javax.naming.InitialContext;

public class TaskServiceBean
extends KMDataAccessBean
implements IKMTaskExceptionResourceKeys {
    private static final String APPLICATION = (class$com$sap$caf$km$ejb$data$task$TaskServiceBean == null ? (class$com$sap$caf$km$ejb$data$task$TaskServiceBean = TaskServiceBean.class$("com.sap.caf.km.ejb.data.task.TaskServiceBean")) : class$com$sap$caf$km$ejb$data$task$TaskServiceBean).getName();
    private static final String jARMReqPrefix = "CAF:RT:oal:";
    private static final String JARM_REQUEST = "CAF:RT:oal:" + APPLICATION;
    private static final Location location = Location.getLocation((String)APPLICATION);
    private transient KMTaskService ws = null;
    static /* synthetic */ Class class$com$sap$caf$km$ejb$data$task$TaskServiceBean;
    static /* synthetic */ Class class$com$sap$caf$km$proxies$data$task$KMTaskService;

    public void ejbCreate() throws CreateException {
        String method = JARM_REQUEST + ":ejbCreate()";
        this.enter(method, null);
        try {
            InitialContext ictxt = new InitialContext();
            Object obj = ictxt.lookup("java:comp/env/KMTaskService");
            if (obj != null) {
                this.ws = (KMTaskService)((KMTaskServiceService)obj).getLogicalPort(class$com$sap$caf$km$proxies$data$task$KMTaskService == null ? (class$com$sap$caf$km$proxies$data$task$KMTaskService = TaskServiceBean.class$("com.sap.caf.km.proxies.data.task.KMTaskService")) : class$com$sap$caf$km$proxies$data$task$KMTaskService);
            }
        }
        catch (Exception ex) {
            KMTaskException taskEx = new KMTaskException("CANTCREATEEJB", (Throwable)ex);
            this.log((KMDataAccessException)taskEx, method, null);
            throw new CreateException(taskEx.getLocalizedMessage());
        }
        finally {
            this.exit(method, null);
        }
    }

    public void createTask(ITaskHeader taskheader, ITaskContent content, IKMUserContextExt kmuserctxt) throws KMTaskException {
        String method = JARM_REQUEST + ":createTask(ITaskHeader, ITaskContent, IKMUserContextExt)";
        this.enter(method, new Object[]{taskheader, content, kmuserctxt});
        try {
            IKMTaskAttribute[] kmattribute = this.getKMTaskAttribute(taskheader);
            IKMTaskContent kmcontent = this.getKMContent(content);
            this.ws.createTask(kmattribute, kmcontent, kmuserctxt);
        }
        catch (Exception ex) {
            KMTaskException taskEx = new KMTaskException((Throwable)ex);
            this.log((KMDataAccessException)taskEx, method, null);
            throw taskEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void createRelResourceTask(String relResourceRid, ITaskHeader taskheader, ITaskContent content, IKMUserContextExt kmuserctxt) throws KMTaskException {
        String method = JARM_REQUEST + ":createRelResourceTask(String, ITaskHeader, ITaskContent, IKMUserContextExt)";
        this.enter(method, new Object[]{relResourceRid, taskheader, content, kmuserctxt});
        try {
            IKMTaskAttribute[] kmattribute = this.getKMTaskAttribute(taskheader);
            IKMTaskContent kmcontent = this.getKMContent(content);
            this.ws.createRelResourceTask(relResourceRid, kmattribute, kmcontent, kmuserctxt);
        }
        catch (Exception ex) {
            KMTaskException taskEx = new KMTaskException((Throwable)ex);
            this.log((KMDataAccessException)taskEx, method, null);
            throw taskEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void createRelAppTask(String relAppId, ITaskHeader taskheader, ITaskContent content, IKMUserContextExt kmuserctxt) throws KMTaskException {
        String method = JARM_REQUEST + ":createRelAppTask(String, ITaskHeader, ITaskContent, IKMUserContextExt)";
        this.enter(method, new Object[]{relAppId, taskheader, content, kmuserctxt});
        try {
            IKMTaskAttribute[] kmattribute = this.getKMTaskAttribute(taskheader);
            IKMTaskContent kmcontent = this.getKMContent(content);
            this.ws.createRelAppTask(relAppId, kmattribute, kmcontent, kmuserctxt);
        }
        catch (Exception ex) {
            KMTaskException taskEx = new KMTaskException((Throwable)ex);
            this.log((KMDataAccessException)taskEx, method, null);
            throw taskEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void deleteTask(String rid, IKMUserContextExt kmuserctxt) throws KMTaskException {
        String method = JARM_REQUEST + ":deleteTask(String, IKMUserContextExt)";
        this.enter(method, new Object[]{rid, kmuserctxt});
        try {
            this.ws.deleteTask(rid, kmuserctxt);
        }
        catch (Exception ex) {
            KMTaskException taskEx = new KMTaskException((Throwable)ex);
            this.log((KMDataAccessException)taskEx, method, null);
            throw taskEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public ArrayList getTasks(IKMUserContextExt foruserctxt, String role, IKMUserContextExt kmuserctxt) throws KMTaskException {
        String method = JARM_REQUEST + ":getTasks(IKMUserContextExt, String, IKMUserContextExt)";
        this.enter(method, new Object[]{foruserctxt, role, kmuserctxt});
        try {
            ArrayList<ITaskHeader> result = new ArrayList<ITaskHeader>();
            IKMTaskList taskList = this.ws.getTasks(foruserctxt, role, kmuserctxt);
            IKMTaskHeader[] headerlist = taskList.getTasks();
            if (headerlist == null) {
                ArrayList arrayList = null;
                return arrayList;
            }
            for (int i = 0; i < headerlist.length; ++i) {
                ITaskHeader taskheader = this.setExplicitAttributes(headerlist[i]);
                result.add(taskheader);
            }
            ArrayList<ITaskHeader> arrayList = result;
            return arrayList;
        }
        catch (Exception ex) {
            KMTaskException taskEx = new KMTaskException((Throwable)ex);
            this.log((KMDataAccessException)taskEx, method, null);
            throw taskEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public ArrayList getRelResourceTasks(String relResourceRid, String role, IKMUserContextExt kmuserctxt) throws KMTaskException {
        String method = JARM_REQUEST + ":getRelResourceTasks(String, String, IKMUserContextExt)";
        this.enter(method, new Object[]{relResourceRid, role, kmuserctxt});
        try {
            ArrayList<ITaskHeader> result = new ArrayList<ITaskHeader>();
            IKMTaskList taskList = this.ws.getRelResourceTasks(relResourceRid, role, kmuserctxt);
            IKMTaskHeader[] headerlist = taskList.getTasks();
            if (headerlist == null) {
                ArrayList arrayList = null;
                return arrayList;
            }
            for (int i = 0; i < headerlist.length; ++i) {
                ITaskHeader taskheader = this.setExplicitAttributes(headerlist[i]);
                result.add(taskheader);
            }
            ArrayList<ITaskHeader> arrayList = result;
            return arrayList;
        }
        catch (Exception ex) {
            KMTaskException taskEx = new KMTaskException((Throwable)ex);
            this.log((KMDataAccessException)taskEx, method, null);
            throw taskEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public ArrayList getRelAppTasks(String relAppId, String role, IKMUserContextExt kmuserctxt) throws KMTaskException {
        String method = JARM_REQUEST + ":getRelAppTasks(String, String, IKMUserContextExt)";
        this.enter(method, new Object[]{relAppId, role, kmuserctxt});
        try {
            ArrayList<ITaskHeader> result = new ArrayList<ITaskHeader>();
            IKMTaskList taskList = this.ws.getRelAppTasks(relAppId, role, kmuserctxt);
            IKMTaskHeader[] headerlist = taskList.getTasks();
            if (headerlist == null) {
                ArrayList arrayList = null;
                return arrayList;
            }
            for (int i = 0; i < headerlist.length; ++i) {
                ITaskHeader taskheader = this.setExplicitAttributes(headerlist[i]);
                result.add(taskheader);
            }
            ArrayList<ITaskHeader> arrayList = result;
            return arrayList;
        }
        catch (Exception ex) {
            KMTaskException taskEx = new KMTaskException((Throwable)ex);
            this.log((KMDataAccessException)taskEx, method, null);
            throw taskEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public ITaskContent getTaskContent(String rid, IKMUserContextExt kmuserctxt, int sizeLimitBytes) throws KMTaskException {
        String method = JARM_REQUEST + ":getTaskContent(String, IKMUserContextExt, int)";
        this.enter(method, new Object[]{rid, kmuserctxt, new Integer(sizeLimitBytes)});
        try {
            ITaskContent result;
            IKMTaskContent kmcontent = this.ws.getTaskContent(rid, kmuserctxt, sizeLimitBytes);
            ITaskContent iTaskContent = result = this.setExplicitContentAttributes(kmcontent);
            return iTaskContent;
        }
        catch (Exception ex) {
            KMTaskException taskEx = new KMTaskException((Throwable)ex);
            this.log((KMDataAccessException)taskEx, method, null);
            throw taskEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void updateTaskContent(String rid, ITaskContent content, IKMUserContextExt kmuserctxt) throws KMTaskException {
        String method = JARM_REQUEST + ":updateTaskContent(String, ITaskContent, IKMUserContextExt)";
        this.enter(method, new Object[]{rid, content, kmuserctxt});
        try {
            IKMTaskContent kmcontent = this.getKMContent(content);
            this.ws.updateTaskContent(rid, kmcontent, kmuserctxt);
        }
        catch (Exception ex) {
            KMTaskException taskEx = new KMTaskException((Throwable)ex);
            this.log((KMDataAccessException)taskEx, method, null);
            throw taskEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public void updateTaskHeader(String rid, ITaskHeader header, IKMUserContextExt kmuserctxt) throws KMTaskException {
        String method = JARM_REQUEST + ":updateTaskContent(String, ITaskHeader, IKMUserContextExt)";
        this.enter(method, new Object[]{rid, header, kmuserctxt});
        try {
            IKMTaskAttribute[] kmattribute = this.getKMTaskAttribute(header);
            this.ws.updateTaskHeader(rid, kmattribute, kmuserctxt);
        }
        catch (Exception ex) {
            KMTaskException taskEx = new KMTaskException((Throwable)ex);
            this.log((KMDataAccessException)taskEx, method, null);
            throw taskEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public ITaskHeader readTaskHeader(String rid, IKMUserContextExt kmuserctxt) throws KMTaskException {
        String method = JARM_REQUEST + ":readTaskHeader(String, IKMUserContextExt)";
        this.enter(method, new Object[]{rid, kmuserctxt});
        try {
            ITaskHeader result;
            IKMTaskHeader taskHeader = null;
            taskHeader = this.ws.readTaskHeader(rid, kmuserctxt);
            ITaskHeader iTaskHeader = result = this.setExplicitAttributes(taskHeader);
            return iTaskHeader;
        }
        catch (Exception ex) {
            KMTaskException taskEx = new KMTaskException((Throwable)ex);
            this.log((KMDataAccessException)taskEx, method, null);
            throw taskEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public String testlocal(String param) throws KMTaskException {
        String method = JARM_REQUEST + ":testlocal(String)";
        this.enter(method, new Object[]{param});
        try {
            String string = "testlocal success";
            return string;
        }
        catch (Exception ex) {
            KMTaskException taskEx = new KMTaskException((Throwable)ex);
            this.log((KMDataAccessException)taskEx, method, null);
            throw taskEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public String testws(String param) throws KMTaskException {
        String method = JARM_REQUEST + ":testws(String)";
        this.enter(method, new Object[]{param});
        try {
            String result = "";
            String string = result = this.ws.test2("hello");
            return string;
        }
        catch (Exception ex) {
            KMTaskException taskEx = new KMTaskException((Throwable)ex);
            this.log((KMDataAccessException)taskEx, method, null);
            throw taskEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    public String readTaskHeader(String param) throws KMTaskException {
        String method = JARM_REQUEST + ":readTaskHeader(String)";
        this.enter(method, new Object[]{param});
        try {
            Object taskHeader = null;
            if (taskHeader != null) {
                String string = taskHeader.getRid();
                return string;
            }
            String string = "failed";
            return string;
        }
        catch (Exception ex) {
            KMTaskException taskEx = new KMTaskException((Throwable)ex);
            this.log((KMDataAccessException)taskEx, method, null);
            throw taskEx;
        }
        finally {
            this.exit(method, null);
        }
    }

    private IKMTaskAttribute getAttribute(String attributeName, IKMTaskAttribute[] attributes) {
        String namespace = "http://sapportals.com/xmlns/cm/collaboration";
        if (attributeName.equalsIgnoreCase("displayname")) {
            namespace = "http://sapportals.com/xmlns/cm";
        }
        for (int i = 0; i < attributes.length; ++i) {
            if (attributes[i].getName() == null || attributes[i].getNamespace() == null || !attributes[i].getName().equalsIgnoreCase(attributeName) || !attributes[i].getNamespace().equalsIgnoreCase(namespace)) continue;
            return attributes[i];
        }
        return null;
    }

    private ITaskHeader setExplicitAttributes(IKMTaskHeader kmtaskheader) throws WSProxyException {
        TaskHeader attributeHeader = new TaskHeader();
        String Rid = kmtaskheader.getRid();
        if (Rid == null) {
            throw new WSProxyException();
        }
        attributeHeader.setRid(Rid);
        IKMTaskAttribute attr = this.getAttribute("displayname", kmtaskheader.getAttributes());
        if (attr != null) {
            attributeHeader.setDisplayName(attr.getStringValue());
        }
        if ((attr = this.getAttribute("applicationid", kmtaskheader.getAttributes())) != null) {
            attributeHeader.setApplicationId(attr.getStringValue());
        }
        if ((attr = this.getAttribute("ASAP", kmtaskheader.getAttributes())) != null) {
            attributeHeader.setAsap(attr.getBooleanValue());
        }
        if ((attr = this.getAttribute("assignee", kmtaskheader.getAttributes())) != null) {
            attributeHeader.setAssignee(attr.getListValue());
        }
        if ((attr = this.getAttribute("duedate", kmtaskheader.getAttributes())) != null) {
            attributeHeader.setDueDate(attr.getDateValue());
        }
        if ((attr = this.getAttribute("escalation", kmtaskheader.getAttributes())) != null) {
            attributeHeader.setEscalated(attr.getBooleanValue());
        }
        if ((attr = this.getAttribute("notify", kmtaskheader.getAttributes())) != null) {
            attributeHeader.setNotify(attr.getBooleanValue());
        }
        if ((attr = this.getAttribute("priority", kmtaskheader.getAttributes())) != null) {
            attributeHeader.setPriority(attr.getIntValue());
        }
        if ((attr = this.getAttribute("progress", kmtaskheader.getAttributes())) != null) {
            attributeHeader.setProgress(attr.getIntValue());
        }
        if ((attr = this.getAttribute("resourcerid", kmtaskheader.getAttributes())) != null) {
            attributeHeader.setResourceRid(attr.getStringValue());
        }
        if ((attr = this.getAttribute("status", kmtaskheader.getAttributes())) != null) {
            attributeHeader.setStatus(attr.getIntValue());
        }
        if ((attr = this.getAttribute("responsible", kmtaskheader.getAttributes())) != null) {
            attributeHeader.setTrackedBy(attr.getListValue());
        }
        return attributeHeader;
    }

    private ITaskContent setExplicitContentAttributes(IKMTaskContent kmtaskcontent) throws WSProxyException {
        TaskContent taskcontent = new TaskContent();
        taskcontent.setContent(kmtaskcontent.getContent());
        taskcontent.setContentEncoding(kmtaskcontent.getContentEncoding());
        taskcontent.setContentLength(kmtaskcontent.getContentLength());
        taskcontent.setContentType(kmtaskcontent.getContentType());
        return taskcontent;
    }

    private IKMTaskContent getKMContent(ITaskContent taskcontent) {
        IKMTaskContent kmtaskcontent = new IKMTaskContent();
        kmtaskcontent.setContent(taskcontent.getContent());
        kmtaskcontent.setContentEncoding(taskcontent.getContentEncoding());
        kmtaskcontent.setContentLength(taskcontent.getContentLength());
        kmtaskcontent.setContentType(taskcontent.getContentType());
        return kmtaskcontent;
    }

    private IKMTaskAttribute[] getKMTaskAttribute(ITaskHeader taskheader) {
        IKMTaskAttribute[] m_attrs = new IKMTaskAttribute[12];
        IKMTaskAttribute attribute = new IKMTaskAttribute();
        attribute.setName("displayname");
        attribute.setNamespace("http://sapportals.com/xmlns/cm");
        attribute.setAttributeType(0);
        attribute.setStringValue(taskheader.getDisplayName());
        m_attrs[0] = attribute;
        attribute = new IKMTaskAttribute();
        attribute.setName("priority");
        attribute.setNamespace("http://sapportals.com/xmlns/cm/collaboration");
        attribute.setAttributeType(1);
        attribute.setIntValue(taskheader.getPriority());
        m_attrs[1] = attribute;
        attribute = new IKMTaskAttribute();
        attribute.setName("duedate");
        attribute.setNamespace("http://sapportals.com/xmlns/cm/collaboration");
        attribute.setAttributeType(3);
        attribute.setDateValue(taskheader.getDueDate());
        m_attrs[2] = attribute;
        attribute = new IKMTaskAttribute();
        attribute.setName("ASAP");
        attribute.setNamespace("http://sapportals.com/xmlns/cm/collaboration");
        attribute.setAttributeType(4);
        attribute.setBooleanValue(taskheader.getAsap());
        m_attrs[3] = attribute;
        attribute = new IKMTaskAttribute();
        attribute.setName("assignee");
        attribute.setNamespace("http://sapportals.com/xmlns/cm/collaboration");
        attribute.setAttributeType(6);
        attribute.setListValue(taskheader.getAssignee());
        m_attrs[4] = attribute;
        attribute = new IKMTaskAttribute();
        attribute.setName("responsible");
        attribute.setNamespace("http://sapportals.com/xmlns/cm/collaboration");
        attribute.setAttributeType(6);
        attribute.setListValue(taskheader.getTrackedBy());
        m_attrs[5] = attribute;
        attribute = new IKMTaskAttribute();
        attribute.setName("notify");
        attribute.setNamespace("http://sapportals.com/xmlns/cm/collaboration");
        attribute.setAttributeType(4);
        attribute.setBooleanValue(taskheader.getNotify());
        m_attrs[6] = attribute;
        attribute = new IKMTaskAttribute();
        attribute.setName("progress");
        attribute.setNamespace("http://sapportals.com/xmlns/cm/collaboration");
        attribute.setAttributeType(1);
        attribute.setIntValue(taskheader.getProgress());
        m_attrs[7] = attribute;
        attribute = new IKMTaskAttribute();
        attribute.setName("status");
        attribute.setNamespace("http://sapportals.com/xmlns/cm/collaboration");
        attribute.setAttributeType(1);
        attribute.setIntValue(taskheader.getStatus());
        m_attrs[8] = attribute;
        attribute = new IKMTaskAttribute();
        attribute.setName("escalation");
        attribute.setNamespace("http://sapportals.com/xmlns/cm/collaboration");
        attribute.setAttributeType(4);
        attribute.setBooleanValue(taskheader.getEscalated());
        m_attrs[9] = attribute;
        attribute = new IKMTaskAttribute();
        attribute.setName("resourcerid");
        attribute.setNamespace("http://sapportals.com/xmlns/cm/collaboration");
        attribute.setAttributeType(0);
        attribute.setStringValue(taskheader.getResourceRid());
        m_attrs[10] = attribute;
        attribute = new IKMTaskAttribute();
        attribute.setName("applicationid");
        attribute.setNamespace("http://sapportals.com/xmlns/cm/collaboration");
        attribute.setAttributeType(0);
        attribute.setStringValue(taskheader.getApplicationId());
        m_attrs[11] = attribute;
        return m_attrs;
    }

    protected Location getLocation() {
        return location;
    }

    protected String getJARMRequest() {
        return JARM_REQUEST;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

