/*
 * Decompiled with CFR 0.152.
 */
package com.sap.caf.km.da;

import com.sap.caf.km.da.KMDataAccessHelper;

public final class RidUtils {
    public static final char PATH_SEPARATOR = '/';

    public static String getName(String rid) {
        int i = rid.lastIndexOf(47);
        return i == -1 ? rid : rid.substring(i + 1);
    }

    public static String getPath(String rid) {
        int i = rid.lastIndexOf(47);
        return i == -1 ? rid : rid.substring(0, i);
    }

    public static boolean isUnderBORootFolder(String rId) {
        return RidUtils.getBORootFolder(KMDataAccessHelper.getDocRepositoryRid(), rId) != null;
    }

    public static boolean isUnderTempFolder(String rId) {
        return rId.startsWith(KMDataAccessHelper.getTempFolderRid());
    }

    public static String getBORootFolder(String docRootRid, String rid) {
        int i = rid.indexOf(docRootRid);
        if (i != 0) {
            return null;
        }
        if ((i = rid.indexOf(47, i + docRootRid.length() + 1)) == -1) {
            return null;
        }
        if ((i = rid.indexOf(47, i + 1)) == -1) {
            return null;
        }
        return rid.substring(0, i);
    }

    public static String mergePathname(String[] pathname, int count) {
        if (pathname == null || pathname.length == 0 || count < 0 || count > pathname.length) {
            return null;
        }
        StringBuffer sb = new StringBuffer((pathname[0].length() + 1) * count);
        for (int i = 0; i < count; ++i) {
            if (pathname[i] == null || pathname[i].length() <= 0) continue;
            sb.append(pathname[i]).append('/');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String[] splitPathname(String rootPath, String pathname) {
        int i = pathname.indexOf(rootPath);
        if (i != 0) {
            return null;
        }
        int j = rootPath.length();
        String[] res = new String[]{pathname.substring(i, j), (j = (pathname = pathname.substring(j + 1)).lastIndexOf(47)) == -1 ? null : pathname.substring(0, j), j == -1 ? pathname : pathname.substring(j + 1)};
        return res;
    }

    public static String[] normalizePathname(String folderPath, String filePathname) {
        if (folderPath == null || filePathname == null) {
            throw new RuntimeException("Method parameters can not be null!");
        }
        int i = filePathname.lastIndexOf(47);
        if (i > 0) {
            folderPath = folderPath + '/' + filePathname.substring(0, i);
            filePathname = filePathname.substring(i + 1);
        }
        return new String[]{folderPath, filePathname};
    }
}

