/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo;

import java.io.PrintStream;
import java.io.PrintWriter;
import javax.jdo.I18NHelper;

public class JDOException
extends RuntimeException {
    Throwable[] nested;
    Object failed;
    private static I18NHelper msg = I18NHelper.getInstance("javax.jdo.Bundle");

    public JDOException() {
    }

    public JDOException(String msg) {
        super(msg);
    }

    public JDOException(String msg, Throwable[] nested) {
        super(msg);
        this.nested = nested;
    }

    public JDOException(String msg, Throwable nested) {
        super(msg);
        this.nested = new Throwable[]{nested};
    }

    public JDOException(String msg, Object failed) {
        super(msg);
        this.failed = failed;
    }

    public JDOException(String msg, Throwable[] nested, Object failed) {
        super(msg);
        this.nested = nested;
        this.failed = failed;
    }

    public JDOException(String msg, Throwable nested, Object failed) {
        super(msg);
        this.nested = new Throwable[]{nested};
        this.failed = failed;
    }

    public Object getFailedObject() {
        return this.failed;
    }

    public Throwable[] getNestedExceptions() {
        return this.nested;
    }

    public String toString() {
        int len = this.nested == null ? 0 : this.nested.length;
        StringBuffer sb = new StringBuffer(10 + 100 * len);
        sb.append(super.toString());
        if (this.failed != null) {
            sb.append("\n");
            sb.append(msg.msg("MSG_FailedObject"));
            sb.append(this.failed.toString());
        }
        if (len > 0) {
            sb.append("\n");
            sb.append(msg.msg("MSG_NestedThrowables"));
            sb.append("\n");
            Throwable exception = this.nested[0];
            sb.append(exception == null ? "null" : exception.toString());
            int i = 1;
            while (i < len) {
                sb.append("\n");
                exception = this.nested[i];
                sb.append(exception == null ? "null" : exception.toString());
                ++i;
            }
        }
        return sb.toString();
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    public void printStackTrace(PrintStream s) {
        int len = this.nested == null ? 0 : this.nested.length;
        PrintStream printStream = s;
        synchronized (printStream) {
            super.printStackTrace(s);
            if (len > 0) {
                s.println(msg.msg("MSG_NestedThrowablesStackTrace"));
                int i = 0;
                while (i < len) {
                    Throwable exception = this.nested[i];
                    if (exception != null) {
                        exception.printStackTrace(s);
                    }
                    ++i;
                }
            }
        }
    }

    public void printStackTrace(PrintWriter s) {
        int len = this.nested == null ? 0 : this.nested.length;
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            super.printStackTrace(s);
            if (len > 0) {
                s.println(msg.msg("MSG_NestedThrowablesStackTrace"));
                int i = 0;
                while (i < len) {
                    Throwable exception = this.nested[i];
                    if (exception != null) {
                        exception.printStackTrace(s);
                    }
                    ++i;
                }
            }
        }
    }
}

