/*
 * Decompiled with CFR 0.152.
 */
package javax.jdo;

import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.ResourceBundle;

public class I18NHelper {
    private static Hashtable bundles = new Hashtable();
    private static Hashtable helpers = new Hashtable();
    private static Locale locale = Locale.getDefault();
    private ResourceBundle bundle = null;

    private I18NHelper() {
    }

    private I18NHelper(String bundleName) {
        this.bundle = I18NHelper.loadBundle(bundleName);
    }

    public static I18NHelper getInstance(String bundleName) {
        I18NHelper helper = (I18NHelper)helpers.get(bundleName);
        if (helper != null) {
            return helper;
        }
        helper = new I18NHelper(bundleName);
        helpers.put(bundleName, helper);
        return (I18NHelper)helpers.get(bundleName);
    }

    public String msg(String messageKey) {
        return I18NHelper.getMessage(this.bundle, messageKey);
    }

    public String msg(String messageKey, Object arg1) {
        return I18NHelper.getMessage(this.bundle, messageKey, arg1);
    }

    public String msg(String messageKey, Object arg1, Object arg2) {
        return I18NHelper.getMessage(this.bundle, messageKey, arg1, arg2);
    }

    public String msg(String messageKey, Object arg1, Object arg2, Object arg3) {
        return I18NHelper.getMessage(this.bundle, messageKey, arg1, arg2, arg3);
    }

    public String msg(String messageKey, Object[] args) {
        return I18NHelper.getMessage(this.bundle, messageKey, args);
    }

    public String msg(String messageKey, int arg) {
        return I18NHelper.getMessage(this.bundle, messageKey, arg);
    }

    public String msg(String messageKey, boolean arg) {
        return I18NHelper.getMessage(this.bundle, messageKey, arg);
    }

    private static final ResourceBundle loadBundle(String bundleName) {
        ResourceBundle messages = (ResourceBundle)bundles.get(bundleName);
        if (messages == null) {
            messages = ResourceBundle.getBundle(bundleName, locale);
            bundles.put(bundleName, messages);
        }
        return messages;
    }

    private static final String getMessage(ResourceBundle messages, String messageKey) {
        return messages.getString(messageKey);
    }

    private static final String getMessage(ResourceBundle messages, String messageKey, Object[] msgArgs) {
        int i = 0;
        while (i < msgArgs.length) {
            if (msgArgs[i] == null) {
                msgArgs[i] = "";
            }
            ++i;
        }
        MessageFormat formatter = new MessageFormat(messages.getString(messageKey));
        return formatter.format(msgArgs);
    }

    private static final String getMessage(ResourceBundle messages, String messageKey, Object arg) {
        Object[] args = new Object[]{arg};
        return I18NHelper.getMessage(messages, messageKey, args);
    }

    private static final String getMessage(ResourceBundle messages, String messageKey, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg1, arg2};
        return I18NHelper.getMessage(messages, messageKey, args);
    }

    private static final String getMessage(ResourceBundle messages, String messageKey, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg1, arg2, arg3};
        return I18NHelper.getMessage(messages, messageKey, args);
    }

    private static final String getMessage(ResourceBundle messages, String messageKey, int arg) {
        Object[] args = new Object[]{new Integer(arg)};
        return I18NHelper.getMessage(messages, messageKey, args);
    }

    private static final String getMessage(ResourceBundle messages, String messageKey, boolean arg) {
        Object[] args = new Object[]{String.valueOf(arg)};
        return I18NHelper.getMessage(messages, messageKey, args);
    }
}

