/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging.tools.lv;

import com.sap.tc.logging.MSGCollection;
import com.sap.tc.logging.Severity;
import com.sap.tc.logging.tools.lv.CmdOption;
import com.sap.tc.logging.tools.lv.LVActionConstants;
import com.sap.tc.logging.tools.lv.LVFormatPattern;
import com.sap.tc.logging.tools.lv.LVFormatter;
import com.sap.tc.logging.tools.lv.LVLogger;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;

public class LVOptions
extends LVActionConstants
implements Cloneable {
    private static String strLoc = "-LVOptions";
    private static String EMPTY_STRING = "";
    public int action = -1;
    public static final String DEFAULT_FORMAT = "%d %t %s %m";
    public static final int DEF_SEVERITY_WIDTH = 8;
    public static final int DEF_GUID_WIDTH = 35;
    public static final int DEF_LOCATION_WIDTH = 35;
    public static final int DEF_CATEGORY_WIDTH = 35;
    public int filSeverity;
    public String filLocation;
    public String filCategory;
    public String filDate;
    public String outFileName = null;
    public String[] readFileName = null;
    public String format = "%d %t %s %m";
    public boolean isTail = false;
    public boolean isBatchMode = true;
    public boolean isIndexed = false;
    public boolean isFileSet = false;
    public PrintWriter outSystem;
    public LVFormatter formatter = new LVFormatter("%d %t %s %m");
    static HashMap optionPrefixes = new HashMap();
    public static final String help;

    public void parseNoNamePrefix(CmdOption option) {
        this.readFileName = new String[option.size()];
        int i = 0;
        while (i < option.size()) {
            this.readFileName[i] = option.getValueAt(i);
            ++i;
        }
        this.action = 2;
    }

    public void parseEventlog(CmdOption option) {
        System.setProperty("eventLog", "all");
        LVLogger.logIntByAPI(300, LVLogger.LVLocation, strLoc, MSGCollection.LOGGING_MSG_ID_EVENT_LOG, MSGCollection.LOGGING_MSG_STR_EVENT_LOG, new Object[]{"enabled"});
    }

    public void parseVersion(CmdOption option) {
        this.action = 0;
    }

    public void parseHelp(CmdOption option) {
        this.action = 1;
    }

    public Object clone() {
        LVOptions cloneMe = new LVOptions();
        return cloneMe;
    }

    public void parseBatch(CmdOption option) {
        this.isBatchMode = option.getValueAt(0).equalsIgnoreCase("true") && !this.isTail;
    }

    public void parseTail(CmdOption option) {
        this.isTail = true;
        this.isBatchMode = false;
    }

    public void parseIndex(CmdOption option) {
        this.isIndexed = true;
    }

    public void parseOut(CmdOption option) {
        if (option.size() == 0) {
            this.outFileName = null;
            this.parseError(option, "Missing the output file name!");
        } else {
            this.outFileName = option.getValueAt(0);
        }
        this.isBatchMode = true;
    }

    public void parseFormat(CmdOption option) {
        if (option.size() == 0) {
            this.format = DEFAULT_FORMAT;
            this.parseError(option, "Missing the Format value! Default format (%d %t %s %m) is used!");
        } else {
            StringBuffer tmpBuffer = new StringBuffer();
            Iterator iter = option.getValues();
            while (iter.hasNext()) {
                tmpBuffer.append((String)iter.next());
            }
            this.format = tmpBuffer.toString();
        }
        this.formatter = new LVFormatter(this.format);
    }

    public void parseLocation(CmdOption option) {
        if (option.size() == 0) {
            this.filLocation = null;
            this.parseError(option, "Missing the filtering Location value!");
        } else {
            this.filLocation = option.getValueAt(0);
        }
    }

    public void parseCategory(CmdOption option) {
        if (option.size() == 0) {
            this.filCategory = null;
            this.parseError(option, "Missing the filtering Category value!");
        } else {
            this.filCategory = option.getValueAt(0);
        }
    }

    public void parseDate(CmdOption option) {
        if (option.size() == 0) {
            this.filDate = null;
            this.parseError(option, "Missing the filtering Date value!");
        } else {
            this.filDate = option.getValueAt(0);
        }
    }

    public void parseSeverity(CmdOption option) {
        if (option.size() == 0) {
            this.filSeverity = 701;
            this.parseError(option, "Missing the filtering Severity value");
        } else {
            try {
                this.filSeverity = Severity.parse(option.getValueAt(0));
            }
            catch (IllegalArgumentException ex) {
                this.filSeverity = 701;
                this.parseError(option, ex.getMessage());
            }
        }
    }

    void parseMessage(String txt, CmdOption option, String msg) {
        System.err.println(txt + ": Option " + option.getName() + ": " + msg);
    }

    void parseWarning(CmdOption option, String msg) {
        this.parseMessage("Warning", option, msg);
    }

    void parseError(CmdOption option, String msg) {
        this.parseMessage("Error", option, msg);
        System.exit(1);
    }

    static {
        optionPrefixes.put("O", "out");
        optionPrefixes.put("B", "batch");
        optionPrefixes.put("T", "tail");
        optionPrefixes.put("F", "format");
        optionPrefixes.put("I", "index");
        optionPrefixes.put("L", "location");
        optionPrefixes.put("C", "category");
        optionPrefixes.put("D", "date");
        optionPrefixes.put("S", "severity");
        optionPrefixes.put("E", "eventlog");
        optionPrefixes.put("H", "help");
        optionPrefixes.put("V", "version");
        help = "NAME: lv print the content of log files\n\nSYNOPSIS: lv.bat source [-o outfile] [-t] [-i] [-e] \n[-l \"location name\"] [-c \"category name\"] \n[-d \"date\"] [-s \"severity\"]\n\nDESCRIPTION: The lv utility may be used to print log and trace files \nwritten by the SAP logging API ListFormatter formatter in a human readable format. \nThe tools supports two main operation modes: \nprinting whole files or printing log records from some source files \nas they are written (this resembles the tail command)\n\nOptions:\n\nGeneral:\n  <dir/s or logfile/s>\n  source - path to the server log directory or file. \n  Multiple values must be separated by space.\n  If a directory is specified as source, the content of all files \n  in that directory are dumped. \n -i[ndex]\n   When this switch is set and a list of files has been given as source \n   each log record is tagged with an index number. This number references \n   the file in the source file list from where the log recorded originated.\n   If only the one file is specified for reading, this flag will be ignored.\n -o[utfile] <outfile>\n   the filename (outfile) where to write the output.\n   Always writes the complete file and terminates automatic.\n  -t[ail]\n   When this switch is set the lv tool will not print the whole content of \n   the source file or files but will print each new log record as they are \n   written to the corresponding file.\n   This option does not work in J2EE cmd console!\n  -e[ventlog]\n   Enable Logging API log.\n   Logging API messages will be written to the loggingAPI.log and loggingAPI.trc file\n  -h[elp]\n   print this help text.\n  -v[ersion]\n   print version info.\n" + LVFormatPattern.help + "Filter:\n" + "  -l[ocation]\n" + "   print all messages with the given location name\n" + "  -c[ategory]\n" + "   print all messages with the given category name\n" + "  -d[ate] using format (dd.MM.yyyy HH:mm:ss)\n" + "   print all messages with this or a later time stamp\n" + "  -s[everity] <value>  MIN|DEBUG|PATH|INFO|WARNING|ERROR|FATAL\n" + "   display only records with severity >= value\n" + "\n";
    }
}

