/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.logging;

import com.sap.tc.logging.GUId;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public final class HelperLib {
    public static final String NULL_STRING = "<null>";
    public static final String EMPTY_STRING = "";
    private static final int OPER_MIN_ID = 0;
    private static final int OPER_EQUAL_ID = 1;
    private static final String OPER_EQUAL = "=";
    private static final int OPER_NOT_EQUAL_ID = 2;
    private static final String OPER_NOT_EQUAL = "!=";
    private static final int OPER_DIFF_EQUAL_ID = 3;
    private static final String OPER_DIFF_EQUAL = "<>";
    private static final int OPER_GREATER_ID = 4;
    private static final String OPER_GREATER = ">";
    private static final int OPER_GREATER_EQUAL_ID = 5;
    private static final String OPER_GREATER_EQUAL = ">=";
    private static final int OPER_LOWER_ID = 6;
    private static final String OPER_LOWER = "<";
    private static final int OPER_LOWER_EQUAL_ID = 7;
    private static final String OPER_LOWER_EQUAL = "<=";
    private static Map operaters = new HashMap();

    public static int parseOperator(String value) {
        if (operaters.containsKey(value)) {
            return (Integer)operaters.get(value);
        }
        return -1;
    }

    public static boolean compareTwoDates(int operator, Date dateA, Date dateB) {
        int result = dateA.compareTo(dateB);
        switch (operator) {
            case 1: {
                return result == 0;
            }
            case 4: {
                return result > 0;
            }
            case 5: {
                return result == 0 || result > 0;
            }
            case 6: {
                return result < 0;
            }
            case 7: {
                return result == 0 || result < 0;
            }
            case 2: 
            case 3: {
                return result != 0;
            }
        }
        return false;
    }

    public static String expandPattern(String filePattern, int fileCount, boolean isRotate, boolean onlyNewFormat) {
        StringBuffer buf = new StringBuffer(filePattern);
        int patternLen = filePattern.length();
        boolean numberInserted = false;
        int i = 0;
        while (i < patternLen) {
            switch (buf.charAt(i)) {
                case '%': {
                    String replacement;
                    switch (buf.charAt(i + 1)) {
                        case 'g': {
                            replacement = Integer.toString(fileCount);
                            buf.replace(i, i + 2, replacement);
                            i += replacement.length() - 1;
                            patternLen += replacement.length() - 2;
                            numberInserted = true;
                            break;
                        }
                        case 'h': {
                            replacement = System.getProperty("user.home");
                            buf.replace(i, i + 2, replacement);
                            i += replacement.length() - 1;
                            patternLen += replacement.length() - 2;
                            break;
                        }
                        case 't': {
                            try {
                                replacement = System.getProperty("java.io.tmpdir");
                            }
                            catch (SecurityException sE) {
                                try {
                                    File file = File.createTempFile("tmp", null);
                                    replacement = file.getPath();
                                    file.delete();
                                    replacement = replacement.substring(0, replacement.lastIndexOf(File.separator));
                                }
                                catch (IOException ioE) {
                                    replacement = EMPTY_STRING;
                                }
                            }
                            buf.replace(i, i + 2, replacement);
                            i += replacement.length() - 1;
                            patternLen += replacement.length() - 2;
                            break;
                        }
                        case 'u': {
                            replacement = new GUId().toString().replace(':', '_');
                            buf.replace(i, i + 2, replacement);
                            i += replacement.length() - 1;
                            patternLen += replacement.length() - 2;
                            break;
                        }
                        case '%': {
                            buf.replace(i, i + 2, "%");
                            --patternLen;
                        }
                    }
                    break;
                }
                case '/': {
                    String replacement = File.separator;
                    buf.replace(i, i + 1, replacement);
                    i += replacement.length() - 1;
                    patternLen += replacement.length() - 1;
                }
            }
            ++i;
        }
        if (!isRotate || numberInserted) {
            return buf.toString();
        }
        return HelperLib.createFileName(buf.toString(), "." + fileCount, onlyNewFormat);
    }

    private static String createFileName(String filePattern, String append, boolean onlyNewFormat) {
        String tmpFileName;
        int pos;
        StringBuffer newPattern = new StringBuffer();
        StringBuffer tmpPattern = new StringBuffer();
        File file = new File(filePattern);
        String fileFolder = file.getParent();
        String fileName = file.getName();
        if (fileFolder != null) {
            newPattern.append(fileFolder);
            newPattern.append(File.separator);
        }
        if ((pos = fileName.indexOf(".")) > 0) {
            tmpPattern.append(fileName.substring(0, pos));
            tmpPattern.append(append);
            tmpPattern.append(fileName.substring(pos));
        } else {
            tmpPattern.append(fileName);
            tmpPattern.append(append);
            tmpPattern.append(".log");
        }
        if (!onlyNewFormat && !new File(tmpFileName = newPattern.toString() + tmpPattern.toString()).exists()) {
            tmpPattern = new StringBuffer();
            if (pos > 0) {
                tmpPattern.append(fileName);
                tmpPattern.append(append);
            } else {
                tmpPattern.append(fileName);
                tmpPattern.append(".log");
                tmpPattern.append(append);
            }
        }
        newPattern.append(tmpPattern.toString());
        return newPattern.toString();
    }

    static {
        operaters.put(OPER_EQUAL, new Integer(1));
        operaters.put(OPER_NOT_EQUAL, new Integer(2));
        operaters.put(OPER_DIFF_EQUAL, new Integer(3));
        operaters.put(OPER_GREATER, new Integer(4));
        operaters.put(OPER_GREATER_EQUAL, new Integer(5));
        operaters.put(OPER_LOWER, new Integer(6));
        operaters.put(OPER_LOWER_EQUAL, new Integer(7));
    }
}

