/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.util.collections;

import java.util.EmptyStackException;

public class BooleanStack {
    private boolean[] booleanArray;
    private int currentPos = -1;
    private int initialCapacity;

    public BooleanStack() {
        this(10);
    }

    public BooleanStack(int initialCapacity) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException("capacity must be at least 1");
        }
        this.initialCapacity = initialCapacity;
        this.booleanArray = new boolean[initialCapacity];
    }

    public boolean peek() {
        if (this.currentPos == -1) {
            throw new EmptyStackException();
        }
        return this.booleanArray[this.currentPos];
    }

    public boolean pop() {
        if (this.currentPos == -1) {
            throw new EmptyStackException();
        }
        return this.booleanArray[this.currentPos--];
    }

    public void push(boolean value) {
        if (this.currentPos == this.booleanArray.length - 1) {
            this.doubleCapacity();
        }
        this.booleanArray[++this.currentPos] = value;
    }

    private void doubleCapacity() {
        boolean[] temp = new boolean[this.booleanArray.length * 2];
        System.arraycopy(this.booleanArray, 0, temp, 0, this.booleanArray.length);
        this.booleanArray = temp;
    }

    public boolean isEmpty() {
        return this.currentPos == -1;
    }

    public void clear() {
        this.booleanArray = new boolean[this.initialCapacity];
        this.currentPos = -1;
    }
}

