/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jtci.cache;

import com.sap.tc.jtools.jtci.cache.RegistryEntry;
import com.sap.tc.jtools.util.cache.CacheDependency;
import com.sap.tc.jtools.util.cache.CacheException;
import com.sap.tc.jtools.util.cache.CacheInterface;
import com.sap.tc.jtools.util.cache.Cacheable;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class Cache
implements CacheInterface {
    private Map key2Object = new HashMap();
    private Map key2RegistryEntry = new HashMap();

    private boolean isUpToDate(String key) {
        RegistryEntry registryEntry = (RegistryEntry)this.key2RegistryEntry.get(key);
        if (registryEntry == null) {
            return false;
        }
        long timestamp = registryEntry.getTimeStamp();
        CacheDependency[] preconditions = registryEntry.getDependencies();
        int j = 0;
        while (j < preconditions.length) {
            long pcTimestamp;
            System.out.println("checking precondition n." + j + ":");
            if (preconditions[j].isFile()) {
                File file = new File(preconditions[j].getKey());
                if (!file.exists()) {
                    return false;
                }
                pcTimestamp = file.lastModified();
            } else {
                pcTimestamp = ((RegistryEntry)this.key2RegistryEntry.get(preconditions[j].getKey())).getTimeStamp();
            }
            if (timestamp <= pcTimestamp) {
                return false;
            }
            if (!preconditions[j].isFile() && !this.isUpToDate(preconditions[j].getKey())) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public void addEntry(Cacheable newEntry) throws CacheException {
        System.out.println("adding entry " + newEntry.getKey());
        RegistryEntry registryEntry = (RegistryEntry)this.key2RegistryEntry.get(newEntry.getKey());
        if (registryEntry == null) {
            System.out.println("creating entry " + newEntry.getKey());
        } else {
            System.out.println("updating entry " + newEntry.getKey());
        }
        registryEntry = new RegistryEntry(newEntry.getKey(), newEntry.getDependencies(), newEntry.getTimeStamp());
        this.key2RegistryEntry.put(newEntry.getKey(), registryEntry);
        this.key2Object.put(newEntry.getKey(), newEntry.getContents());
    }

    public Object getEntryValue(String entryName) {
        System.out.println("getting entry value" + entryName);
        if (!this.isUpToDate(entryName)) {
            System.out.println("entry " + entryName + " is not up to date");
            return null;
        }
        System.out.println("entry " + entryName + " is up to date");
        RegistryEntry entry = (RegistryEntry)this.key2RegistryEntry.get(entryName);
        return this.key2Object.get(entryName);
    }
}

