/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jtci;

import com.sap.tc.jtools.jlint.extension.TestProvider;
import com.sap.tc.jtools.jtci.CodeClassificationConstants;
import com.sap.tc.jtools.jtci.ParameterTool;
import com.sap.tc.jtools.jtci.PerformUnit;
import com.sap.tc.jtools.jtci.Test;
import com.sap.tc.jtools.jtci.TestObject;
import com.sap.tc.jtools.jtci.TestSet;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.jtci.interfaces.ITestMessageDescription;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class PerformRequest {
    private static final String TASK_PERFORM_TEST = "TEST";
    private static final String TASK = "TASK";
    private static final String TASK_NAME = "NAME";
    private static final String TASK_PERFORM = "PERFORM";
    private static final String TASK_PERFORM_UNIT = "PERFORM_UNIT";
    private static final String TASK_PERFORM_SOURCE_SET = "SOURCE_SET";
    private static final String TASK_PERFORM_TEST_SET = "TEST_SET";
    protected String name;
    private String task;
    private PerformUnit[] performUnits = null;
    private ParameterInterface[] requestParameters = new ParameterInterface[0];
    private List tests = new ArrayList();
    private List testObjects = new ArrayList();

    public PerformRequest(String name) {
        this.name = name;
        this.task = TASK_PERFORM;
    }

    public PerformRequest(String name, String tool) {
        this(name);
    }

    public PerformRequest(StructureTree tree) throws BadTreeException {
        if (!tree.getParameter(TASK).equals(TASK_PERFORM)) {
            throw new BadTreeException();
        }
        this.name = tree.getParameter(TASK_NAME);
        this.task = TASK_PERFORM;
        StructureTree[] requestParameterTrees = tree.getChildren("INPUT_PARAMETER");
        this.requestParameters = new ParameterInterface[requestParameterTrees.length];
        int i = 0;
        while (i < this.requestParameters.length) {
            this.requestParameters[i] = ParameterTool.createParameter(requestParameterTrees[i]);
            ++i;
        }
        StructureTree[] performUnitTrees = tree.getChildren(TASK_PERFORM_UNIT);
        this.performUnits = new PerformUnit[performUnitTrees.length];
        int i2 = 0;
        while (i2 < this.performUnits.length) {
            StructureTree[] sourceSetTrees = performUnitTrees[i2].getChildren(TASK_PERFORM_SOURCE_SET);
            TestObject[] sources = new TestObject[]{};
            if (sourceSetTrees.length > 0) {
                StructureTree[] sourceTrees = sourceSetTrees[0].getChildren("TEST_OBJECT");
                sources = new TestObject[sourceTrees.length];
                try {
                    int k = 0;
                    while (k < sources.length) {
                        sources[k] = TestProvider.getTestProvider().getTestObject(sourceTrees[k]);
                        ++k;
                    }
                }
                catch (IllegalStateException ise) {
                    throw ise;
                }
                catch (Exception e) {
                    throw new BadTreeException(e);
                }
            }
            StructureTree testSetTree = performUnitTrees[i2].getOnlyChild(TASK_PERFORM_TEST_SET);
            Test[] tests = new TestSet(testSetTree).getActiveTests();
            this.performUnits[i2] = new PerformUnit(sources, tests);
            ++i2;
        }
    }

    public String getName() {
        return this.name;
    }

    public PerformUnit[] getPerformUnits() {
        if (this.performUnits == null) {
            this.computePerformUnits();
        }
        return this.performUnits;
    }

    private void computePerformUnits() {
        if (this.performUnits != null) {
            return;
        }
        HashMap<Long, ArrayList<Test>> testMap = new HashMap<Long, ArrayList<Test>>();
        Iterator iterator = this.tests.iterator();
        while (iterator.hasNext()) {
            Test currentTest = (Test)iterator.next();
            long code = CodeClassificationConstants.getValue(currentTest.getCodeClassification());
            ArrayList<Test> testList = (ArrayList<Test>)testMap.get(new Long(code));
            if (testList == null) {
                testList = new ArrayList<Test>();
                testMap.put(new Long(code), testList);
            }
            testList.add(currentTest);
        }
        HashMap<Long, ArrayList<TestObject>> testObjectMap = new HashMap<Long, ArrayList<TestObject>>();
        Iterator iterator2 = this.testObjects.iterator();
        while (iterator2.hasNext()) {
            TestObject currentTestObject = (TestObject)iterator2.next();
            long code = CodeClassificationConstants.getValue(currentTestObject.getCodeClassification());
            ArrayList<TestObject> testObjectList = (ArrayList<TestObject>)testObjectMap.get(new Long(code));
            if (testObjectList == null) {
                testObjectList = new ArrayList<TestObject>();
                testObjectMap.put(new Long(code), testObjectList);
            }
            testObjectList.add(currentTestObject);
        }
        ArrayList<PerformUnit> performUnitList = new ArrayList<PerformUnit>();
        Iterator iterator3 = testObjectMap.keySet().iterator();
        while (iterator3.hasNext()) {
            Long currentTestObjectCode = (Long)iterator3.next();
            long testObjectCode = currentTestObjectCode;
            ArrayList allTestList = new ArrayList();
            List testObjectList = (List)testObjectMap.get(currentTestObjectCode);
            TestObject[] testObjectArray = testObjectList.toArray(new TestObject[testObjectList.size()]);
            Iterator iter = testMap.keySet().iterator();
            while (iter.hasNext()) {
                Long currentTestCode = (Long)iter.next();
                long testCode = currentTestCode;
                List testList = (List)testMap.get(currentTestCode);
                if ((testObjectCode & testCode) == 0L) continue;
                allTestList.addAll(testList);
            }
            Test[] testArray = allTestList.toArray(new Test[allTestList.size()]);
            performUnitList.add(new PerformUnit(testObjectArray, testArray));
        }
        this.performUnits = performUnitList.toArray(new PerformUnit[0]);
    }

    public void addParameter(ParameterInterface parameter) {
        ParameterInterface newParameter = parameter;
        ParameterInterface[] tempParameters = new ParameterInterface[this.requestParameters.length + 1];
        int i = 0;
        while (i < this.requestParameters.length) {
            tempParameters[i] = this.requestParameters[i];
            ++i;
        }
        tempParameters[this.requestParameters.length] = newParameter;
        this.requestParameters = tempParameters;
    }

    public ParameterInterface[] getParameters() {
        return this.requestParameters;
    }

    public void addSource(TestObject newSource) {
        if (this.performUnits != null) {
            throw new IllegalStateException("sources cannot be added to this perform request");
        }
        this.testObjects.add(newSource);
    }

    public void addTest(Test newTest) {
        if (this.performUnits != null) {
            throw new IllegalStateException("tests cannot be added to this perform request");
        }
        this.tests.add(newTest);
    }

    public void addTest(String testName, ParameterInterface[] parameters, String[] codeClassification) {
        this.addTest(new Test(testName, parameters, new ITestMessageDescription[0], codeClassification, true));
    }

    public StructureTree toStructureTree() {
        this.computePerformUnits();
        Header topHeader = new Header("REQUEST");
        topHeader.setParameter(TASK_NAME, this.name);
        topHeader.setParameter(TASK, this.task);
        StructureTree rootTree = new StructureTree(topHeader);
        int i = 0;
        while (i < this.requestParameters.length) {
            StructureTree parameterTree = this.requestParameters[i].toStructureTree();
            rootTree.addNewChild(parameterTree);
            ++i;
        }
        int i2 = 0;
        while (i2 < this.performUnits.length) {
            StructureTree unitTree = new StructureTree(new Header(TASK_PERFORM_UNIT));
            TestObject[] sources = this.performUnits[i2].getSources();
            StructureTree testSetTree = new TestSet(TASK_PERFORM_TEST_SET, this.performUnits[i2].getTests()).toStructureTree();
            unitTree.addChild(testSetTree);
            StructureTree sourceSetTree = new StructureTree(new Header(TASK_PERFORM_SOURCE_SET));
            int j = 0;
            while (j < sources.length) {
                StructureTree testObjectTree = sources[j].toStructureTree();
                sourceSetTree.addChild(testObjectTree);
                ++j;
            }
            unitTree.addChild(sourceSetTree);
            rootTree.addNewChild(unitTree);
            ++i2;
        }
        return rootTree;
    }
}

