/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jtci;

import com.sap.tc.jtools.jlint.ProcessorUnitFactory;
import com.sap.tc.jtools.jlint.Result;
import com.sap.tc.jtools.jlint.TestComponentInterface;
import com.sap.tc.jtools.jlint.TestConflictException;
import com.sap.tc.jtools.jlint.TestManager;
import com.sap.tc.jtools.jlint.exceptions.InvalidDataProviderException;
import com.sap.tc.jtools.jlint.extension.TestProviderInterface;
import com.sap.tc.jtools.jlint.i18n.ResultLocalizer;
import com.sap.tc.jtools.jtci.PerformRequest;
import com.sap.tc.jtools.jtci.PerformResponse;
import com.sap.tc.jtools.jtci.PerformUnit;
import com.sap.tc.jtools.jtci.Test;
import com.sap.tc.jtools.jtci.TestObject;
import com.sap.tc.jtools.jtci.TestTree;
import com.sap.tc.jtools.jtci.exceptions.InvalidTestSpecificationException;
import com.sap.tc.jtools.jtci.exceptions.PerformException;
import com.sap.tc.jtools.jtci.interfaces.JtciDataInterface;
import com.sap.tc.jtools.jtci.interfaces.Listener;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;
import com.sap.tc.jtools.jtci.interfaces.TestDescriptionInterface;
import com.sap.tc.jtools.util.cache.CacheInterface;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Dispatcher {
    private static final JtciDataInterface[] EMPTY_EXTERNAL_DATA = new JtciDataInterface[0];
    private static TestManager testManager;
    private static ResultLocalizer localizer;
    private TestProviderInterface testProvider;
    private Listener listener = null;

    public Dispatcher(TestProviderInterface provider, CacheInterface cache) {
        this.testProvider = provider;
        ProcessorUnitFactory.setTestProvider(provider);
        try {
            testManager = new TestManager(provider.getTestDescriptionSet(), cache);
            localizer = new ResultLocalizer(provider);
        }
        catch (TestConflictException e) {
            e.printStackTrace();
        }
    }

    public Dispatcher(TestProviderInterface provider) {
        this(provider, null);
    }

    public TestDescriptionInterface[] getTests() {
        return testManager.getAllTests().getAllLeaves();
    }

    public TestTree getTestTree() {
        return testManager.getAllTests();
    }

    public void setListener(Listener l) {
        this.listener = l;
        testManager.setListener(l);
    }

    public PerformResponse processRequest(PerformRequest request) throws PerformException, InvalidTestSpecificationException {
        return this.processRequest(request, EMPTY_EXTERNAL_DATA);
    }

    public PerformResponse processRequest(PerformRequest request, JtciDataInterface[] externalData) throws PerformException, InvalidTestSpecificationException {
        ArrayList<Result> rawResultList = new ArrayList<Result>();
        try {
            ParameterInterface[] requestParameters = request.getParameters();
            PerformUnit[] performUnits = request.getPerformUnits();
            TestDescriptionInterface[] allTests = testManager.getAllTests().getAllLeaves();
            int j = 0;
            while (j < performUnits.length) {
                TestObject[] sources = performUnits[j].getSources();
                Test[] tests = performUnits[j].getTests();
                int l = 0;
                while (l < sources.length) {
                    testManager.reset();
                    testManager.addExternalData(externalData);
                    int k = 0;
                    while (k < tests.length) {
                        String testName = tests[k].getName();
                        TestDescriptionInterface test = null;
                        boolean found = false;
                        int ll = 0;
                        while (ll < allTests.length) {
                            if (allTests[ll].getName().equals(testName)) {
                                test = allTests[ll];
                                found = true;
                            }
                            ++ll;
                        }
                        if (found) {
                            ParameterInterface[] signatureParameters = test.getInputParameters();
                            ParameterInterface[] parameters = new ParameterInterface[signatureParameters.length];
                            int ll2 = 0;
                            while (ll2 < signatureParameters.length) {
                                parameters[ll2] = signatureParameters[ll2];
                                Serializable value = signatureParameters[ll2].getValue();
                                if (value != null) {
                                    parameters[ll2].setValue(value);
                                }
                                ++ll2;
                            }
                            ParameterInterface[] explicitParameters = tests[k].getParameters();
                            if (null == explicitParameters) {
                                explicitParameters = new ParameterInterface[]{};
                            }
                            int ll3 = 0;
                            while (ll3 < explicitParameters.length) {
                                int m = 0;
                                while (m < parameters.length) {
                                    if (parameters[m].getName().equals(explicitParameters[ll3].getName())) {
                                        parameters[m].setValue(explicitParameters[ll3].getValue());
                                    }
                                    ++m;
                                }
                                ++ll3;
                            }
                            ParameterInterface[] totalParameters = new ParameterInterface[parameters.length + requestParameters.length];
                            int ii = 0;
                            while (ii < parameters.length) {
                                totalParameters[ii] = parameters[ii];
                                ++ii;
                            }
                            int ii2 = 0;
                            while (ii2 < requestParameters.length) {
                                totalParameters[parameters.length + ii2] = requestParameters[ii2];
                                ++ii2;
                            }
                            testManager.addTest(testName, totalParameters, Test.mergeMessages(test, tests[k]), sources[l]);
                        }
                        ++k;
                    }
                    ResultInterface[] results = testManager.performTests();
                    rawResultList.addAll(Arrays.asList(results));
                    if (this.listener != null) {
                        this.listener.processedTestObject(results);
                        if (this.listener.isCanceled()) {
                            return null;
                        }
                    }
                    ++l;
                }
                ++j;
            }
        }
        catch (Exception e) {
            throw new PerformException(e);
        }
        PerformResponse response = new PerformResponse(request.getName());
        response.addResults(this.processResults(rawResultList.toArray(new ResultInterface[0])));
        return response;
    }

    private ResultInterface[] processResults(ResultInterface[] results, String testName) throws InvalidDataProviderException, InvalidTestSpecificationException {
        if (testName == null || testName.length() == 0) {
            throw new IllegalArgumentException("invalid test name: " + testName);
        }
        int i = 0;
        while (i < results.length) {
            if (!testName.equals(results[i].getTestName())) {
                throw new IllegalArgumentException("one or more results are not generated by " + testName);
            }
            ++i;
        }
        TestDescriptionInterface[] tests = this.getTests();
        TestDescriptionInterface testDescr = null;
        boolean found = false;
        int i2 = 0;
        while (i2 < tests.length && !found) {
            if (testName.equals(tests[i2].getName())) {
                testDescr = tests[i2];
                found = true;
            }
            ++i2;
        }
        if (!found) {
            throw new InvalidTestSpecificationException("test " + testName + " not found!");
        }
        TestComponentInterface test = ProcessorUnitFactory.createTestComponent(testDescr);
        return test.processErrors(results);
    }

    public ResultInterface[] processResults(ResultInterface[] results) {
        HashSet<ResultInterface> resultSet;
        HashMap rawResults = new HashMap();
        ArrayList<ResultInterface> processedResults = new ArrayList<ResultInterface>();
        int i = 0;
        while (i < results.length) {
            if (results[i].getPriority() == 0) {
                processedResults.add(results[i]);
            } else {
                String testName = results[i].getTestName();
                Set oldResults = (Set)rawResults.get(testName);
                if (oldResults == null) {
                    resultSet = new HashSet<ResultInterface>();
                    resultSet.add(results[i]);
                    rawResults.put(testName, resultSet);
                } else {
                    oldResults.add(results[i]);
                }
            }
            ++i;
        }
        Iterator it = rawResults.keySet().iterator();
        while (it.hasNext()) {
            ResultInterface[] newResults;
            String testName = (String)it.next();
            resultSet = (HashSet<ResultInterface>)rawResults.get(testName);
            ResultInterface[] oldResults = resultSet.toArray(new ResultInterface[resultSet.size()]);
            try {
                newResults = this.processResults(oldResults, testName);
            }
            catch (Exception e) {
                e.printStackTrace();
                newResults = null;
            }
            if (newResults == null) {
                newResults = oldResults;
            }
            processedResults.addAll(Arrays.asList(newResults));
        }
        return localizer.localize(processedResults.toArray(new ResultInterface[processedResults.size()]));
    }

    public TestProviderInterface getTestProvider() {
        return this.testProvider;
    }
}

