/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jtci;

import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.jtci.interfaces.ParameterInterface;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;
import java.io.Serializable;

public class BooleanParameter
implements ParameterInterface {
    private String name;
    private boolean value;

    public BooleanParameter(String name, boolean value) {
        this.name = name;
        this.value = value;
    }

    static BooleanParameter createFromStructureTree(StructureTree tree) throws BadTreeException {
        Header header = tree.getHeader();
        String type = header.getParameter("TYPE");
        String name = header.getParameter("NAME");
        if (type == null || name == null | !"BOOLEAN".equals(type)) {
            throw new BadTreeException();
        }
        StructureTree[] contents = tree.getChildren("VALUE");
        if (null == contents || contents.length == 0) {
            return new BooleanParameter(name, false);
        }
        if (1 != contents.length) {
            throw new BadTreeException("illegal value content");
        }
        String valueString = contents[0].getText();
        if (valueString == null) {
            throw new BadTreeException();
        }
        boolean value = Boolean.valueOf(valueString);
        return new BooleanParameter(name, value);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return "BOOLEAN";
    }

    public Serializable getValue() {
        return this.value ? Boolean.TRUE : Boolean.FALSE;
    }

    public void setValue(Serializable value) {
        if (!(value instanceof Boolean)) {
            throw new IllegalArgumentException();
        }
        this.value = (Boolean)value;
    }

    public String valueToString() {
        return String.valueOf(this.value);
    }

    public StructureTree toStructureTree() {
        Header paramHeader = new Header("INPUT_PARAMETER");
        paramHeader.setParameter("NAME", this.name);
        paramHeader.setParameter("TYPE", "BOOLEAN");
        StructureTree paramTree = new StructureTree(paramHeader);
        Header contentHeader = new Header("VALUE");
        StructureTree contentTree = new StructureTree(contentHeader);
        paramTree.addNewChild(contentTree);
        contentTree.setText(this.valueToString());
        return paramTree;
    }
}

