/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.report.html;

import com.sap.tc.jtools.jlint.report.dataprovider.ProjectRunInterface;
import com.sap.tc.jtools.jlint.report.dataprovider.RunInterface;
import com.sap.tc.jtools.jlint.report.html.Page;
import com.sap.tc.jtools.jlint.report.html.RunReportPageManager;
import com.sap.tc.jtools.jlint.report.html.StatisticsGenerator;
import com.sap.tc.jtools.jlint.statistics.ResultStatistics;
import com.sap.tc.jtools.jlint.statistics.TestSummary;

public class RunSummaryPage
extends Page {
    private RunInterface data;
    private String contents;

    public RunSummaryPage(RunInterface data, String address, RunReportPageManager pageManager) {
        super(address, pageManager);
        this.data = data;
    }

    public String getContents() {
        if (this.contents == null) {
            RunReportPageManager rrManager = (RunReportPageManager)this.pageManager;
            StringBuffer sb = new StringBuffer("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\"><html> <head> <META http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"><title>");
            sb.append("JLin run " + this.data.getRunID());
            sb.append("</title></head>");
            sb.append("<body style=\"font-family: arial;\"><h2>");
            sb.append("JLin run " + this.data.getRunID());
            sb.append("</h2>");
            sb.append("<hr><p>");
            ResultStatistics statistics = this.data.getGlobalResults(rrManager.getRunReportConfiguration().getProjectFilter());
            sb.append(StatisticsGenerator.getSummary(this.data.getRunID(), statistics, rrManager, this));
            sb.append("<hr><p>");
            ProjectRunInterface[] projectRuns = this.data.getProjectsRuns();
            if (projectRuns.length > 0) {
                sb.append("<p><table border=\"1\" rules=\"groups\">");
                sb.append("<caption>Projects:</caption>");
                sb.append("<thead><tr><th>Project</th>");
                sb.append("<th>");
                sb.append("  <font color=\"maroon\">Prio 1</font> ");
                sb.append("  </th>");
                sb.append(" <th>");
                sb.append("  <font color=\"olive\">Prio 2</font>");
                sb.append("  </th>");
                sb.append(" <th>");
                sb.append("  <font color=\"green\">Prio 3</font>");
                sb.append("  </th>");
                sb.append(" <th>Total</th>");
                sb.append("  </tr></thead>");
                StringBuffer tableBody = new StringBuffer();
                tableBody.append("<tbody>");
                int totalAllCount = 0;
                int totalInfoCount = 0;
                int totalWarningCount = 0;
                int totalErrorCount = 0;
                int i = 0;
                while (i < projectRuns.length) {
                    String projectId = projectRuns[i].getProjectId();
                    if (rrManager.getRunReportConfiguration().getProjectFilter().acceptProject(projectId)) {
                        TestSummary summary = projectRuns[i].getStatistics().getTestSummary();
                        tableBody.append("<tr><td><a href=\"" + rrManager.getLinkForProjectRun(this.data.getRunID(), projectId, this) + "\">" + projectId + "</a></td>");
                        int errorCount = summary.getTotalErrorCount();
                        totalErrorCount += errorCount;
                        int warningCount = summary.getTotalWarningCount();
                        totalWarningCount += warningCount;
                        int infoCount = summary.getTotalInfoCount();
                        totalInfoCount += infoCount;
                        int allCount = errorCount + warningCount + infoCount;
                        totalAllCount += allCount;
                        tableBody.append("<td align=\"right\">" + errorCount + "</td>");
                        tableBody.append("<td align=\"right\">" + warningCount + "</td>");
                        tableBody.append("<td align=\"right\">" + infoCount + "</td>");
                        tableBody.append("<td align=\"right\">" + allCount + "</td></tr>");
                    }
                    ++i;
                }
                tableBody.append("</tbody>");
                sb.append("<tfoot>");
                sb.append("<tr><td><b>Total</b></td>");
                sb.append("<td align=\"right\"><b>" + totalErrorCount + "</b></td>");
                sb.append("<td align=\"right\"><b>" + totalWarningCount + "</b></td>");
                sb.append("<td align=\"right\"><b>" + totalInfoCount + "</b></td>");
                sb.append("<td align=\"right\"><b>" + totalAllCount + "</b></td></tr>");
                sb.append("</tfoot>");
                sb.append(tableBody.toString());
                sb.append("</table>");
            }
            sb.append("</body></html>");
            this.contents = sb.toString();
        }
        return this.contents;
    }
}

