/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.report.html;

import com.sap.tc.jtools.jlint.TestDescriptionSet;
import com.sap.tc.jtools.jlint.report.dataprovider.ProjectRunInterface;
import com.sap.tc.jtools.jlint.report.dataprovider.RunInterface;
import com.sap.tc.jtools.jlint.report.html.Page;
import com.sap.tc.jtools.jlint.report.html.PageManager;
import com.sap.tc.jtools.jlint.report.html.ProjectRunSummaryPage;
import com.sap.tc.jtools.jlint.report.html.RunReportConfiguration;
import com.sap.tc.jtools.jlint.report.html.RunSummaryPage;
import com.sap.tc.jtools.jlint.report.html.TestDescriptionPage;
import com.sap.tc.jtools.jlint.report.html.VariantPage;
import com.sap.tc.jtools.jlint.statistics.ResultStatistics;
import com.sap.tc.jtools.jtci.TestSet;
import com.sap.tc.jtools.jtci.interfaces.TestDescriptionInterface;
import com.sap.tc.jtools.util.xml.XMLTool;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class RunReportPageManager
extends PageManager {
    protected static final String PROJECT_DIRECTORY = "projects";
    protected static final String TEST_DIRECTORY = "tests";
    private static final String VARIANT_DIRECTORY = "variants";
    private Map runSummaryPages = new HashMap();
    private Map testDescriptionPages = new HashMap();
    protected Map testDescriptionMap = new HashMap();
    private Map variantPages = new HashMap();
    private Map projectRunPages = new HashMap();
    private RunReportConfiguration runConfiguration;

    public RunReportPageManager(RunReportConfiguration runReportConfiguration, String rootDirectoryPath, boolean cleanUp) {
        super(rootDirectoryPath, cleanUp);
        this.runConfiguration = runReportConfiguration;
    }

    public RunSummaryPage createRunSummary(RunInterface data) {
        RunSummaryPage page = new RunSummaryPage(data, data.getRunID() + "/summary.html", this);
        this.runSummaryPages.put(data.getRunID(), page);
        this.allPages.add(page);
        return page;
    }

    public TestDescriptionPage createTestDescriptionPage(String runID, TestDescriptionSet tests) {
        TestDescriptionPage page = new TestDescriptionPage(tests, runID + "/" + TEST_DIRECTORY + "/" + tests.getName() + "_description.html", this);
        TestDescriptionInterface[] testDescriptions = tests.getTestTree().getAllLeaves();
        int i = 0;
        while (i < testDescriptions.length) {
            HashMap<String, TestDescriptionPage> test2Page = (HashMap<String, TestDescriptionPage>)this.testDescriptionPages.get(runID);
            if (test2Page == null) {
                test2Page = new HashMap<String, TestDescriptionPage>();
                this.testDescriptionPages.put(runID, test2Page);
            }
            test2Page.put(testDescriptions[i].getName(), page);
            this.testDescriptionMap.put(testDescriptions[i].getName(), testDescriptions[i]);
            ++i;
        }
        this.allPages.add(page);
        return page;
    }

    public VariantPage createVariantPage(ProjectRunInterface run, TestSet variant) {
        VariantPage page = new VariantPage(variant, run.getRunId() + "/" + PROJECT_DIRECTORY + "/" + run.getProjectId() + "/" + VARIANT_DIRECTORY + "/" + variant.getName() + ".html", this);
        this.variantPages.put(run, page);
        this.allPages.add(page);
        return page;
    }

    public ProjectRunSummaryPage createProjectRunPage(ProjectRunInterface run) {
        String address = run.getRunId() + "/" + PROJECT_DIRECTORY + "/" + run.getProjectId() + "/summary.html";
        ProjectRunSummaryPage page = new ProjectRunSummaryPage(run, address, this);
        ResultStatistics statistics = page.getStatistics();
        if (statistics != null) {
            try {
                File statFile = new File(this.rootDirectory, run.getRunId() + "/" + PROJECT_DIRECTORY + "/" + run.getProjectId() + "/statistics.xml");
                statFile.getParentFile().mkdirs();
                XMLTool.writeDocument(statistics.toStructureTree(), new FileWriter(statFile));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.projectRunPages.put(run, page);
        this.allPages.add(page);
        return page;
    }

    public String getLinkForTest(String runId, String testId, Page callingPage) {
        try {
            return this.getRelativeLink(((Page)((Map)this.testDescriptionPages.get(runId)).get(testId)).getAddress() + "#" + testId, callingPage.getAddress());
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getLinkForProjectRun(String runId, String projectId, Page callingPage) {
        Iterator iter = this.projectRunPages.keySet().iterator();
        while (iter.hasNext()) {
            ProjectRunInterface projectRun = (ProjectRunInterface)iter.next();
            if (!projectRun.getProjectId().equals(projectId) || !projectRun.getRunId().equals(runId)) continue;
            return this.getRelativeLink(((Page)this.projectRunPages.get(projectRun)).getAddress(), callingPage.getAddress());
        }
        String runPath = this.rootDirectory.getAbsolutePath() + "/" + runId;
        return this.getRelativeLink(runPath + "/" + PROJECT_DIRECTORY + "/" + projectId + "/summary.html", this.rootDirectory.getAbsolutePath() + "/" + callingPage.getAddress());
    }

    public String getLinkForVariant(ProjectRunInterface run, Page callingPage) {
        return this.getRelativeLink(((Page)this.variantPages.get(run)).getAddress(), callingPage.getAddress());
    }

    public RunReportConfiguration getRunReportConfiguration() {
        return this.runConfiguration;
    }
}

