/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.report.dataprovider.ff.impl;

import com.sap.tc.jtools.jlint.report.dataprovider.ProjectRunSummaryInterface;
import com.sap.tc.jtools.jlint.statistics.ResultStatistics;
import com.sap.tc.jtools.util.xml.XMLTool;
import java.io.File;
import java.io.FileReader;

public class ProjectRunSummary
implements ProjectRunSummaryInterface {
    private static final String PROJECT_NAME = "projectName";
    private String projectName;
    private File projectDir;
    private String runId;
    private ResultStatistics statistics;

    public ProjectRunSummary(String projectName, String runId, File projectDir) {
        this.projectName = projectName;
        this.projectDir = projectDir;
        this.runId = runId;
        this.initializeStatistics(projectDir);
    }

    public String getProjectId() {
        return this.projectName;
    }

    public String getRunId() {
        return this.runId;
    }

    public ResultStatistics getStatistics() {
        return this.statistics;
    }

    private boolean initializeStatistics(File f) {
        if (f.getName().equals("statistics.xml")) {
            try {
                this.statistics = new ResultStatistics(XMLTool.parseReader(new FileReader(f)));
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        if (f.isDirectory()) {
            File[] children = f.listFiles();
            int i = 0;
            while (i < children.length) {
                boolean found = this.initializeStatistics(children[i]);
                if (found) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

