/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.report.dataprovider.ff.impl;

import com.sap.tc.jtools.jlint.report.dataprovider.ProjectRunInterface;
import com.sap.tc.jtools.jlint.statistics.ResultStatistics;
import com.sap.tc.jtools.jtci.PerformRequest;
import com.sap.tc.jtools.jtci.PerformResponse;
import com.sap.tc.jtools.jtci.TestSet;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;
import com.sap.tc.jtools.util.structures.StructureTree;
import com.sap.tc.jtools.util.xml.XMLTool;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ProjectRun
implements ProjectRunInterface {
    private static final String PROJECT_NAME = "projectName";
    private String projectName;
    private Properties properties = new Properties();
    private PerformResponse[] results;
    private File projectDir;
    private String runId;
    private TestSet variant;

    public ProjectRun(String projectName, String runId, TestSet variant, File projectDir) {
        this.properties.setProperty(PROJECT_NAME, projectName);
        this.projectName = projectName;
        this.projectDir = projectDir;
        this.runId = runId;
        this.variant = variant;
    }

    public Properties getInfo() {
        return this.properties;
    }

    public PerformResponse[] getResults() {
        if (this.results == null) {
            if (this.getIndexList(this.projectDir) == null) {
                return new PerformResponse[0];
            }
            this.results = this.getIndexList(this.projectDir).toArray(new PerformResponse[0]);
        }
        return this.results;
    }

    public ResultInterface[] getResults(String test) {
        return null;
    }

    public TestSet getTestVariant() {
        return this.variant;
    }

    public PerformRequest[] getRequests() {
        return null;
    }

    public String getProjectId() {
        return this.projectName;
    }

    private List getIndexList(File dir) {
        if (!dir.isDirectory()) {
            return null;
        }
        File index = new File(dir, "index.xml");
        if (index.exists() && index.isFile()) {
            try {
                StructureTree tree = XMLTool.parseReader(new FileReader(index));
                ArrayList<PerformResponse> out = new ArrayList<PerformResponse>();
                out.add(new PerformResponse(tree));
                return out;
            }
            catch (Exception e1) {
                e1.printStackTrace();
                return null;
            }
        }
        File[] childrenDirectories = dir.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.isDirectory();
            }
        });
        ArrayList out = new ArrayList();
        int i = 0;
        while (i < childrenDirectories.length) {
            List resp = this.getIndexList(childrenDirectories[i]);
            if (resp != null) {
                out.addAll(resp);
            }
            ++i;
        }
        if (out.size() > 0) {
            return out;
        }
        return null;
    }

    public String getRunId() {
        return this.runId;
    }

    public ResultStatistics getStatistics() {
        PerformResponse[] res = this.getResults();
        ResultStatistics[] stats = new ResultStatistics[res.length];
        int i = 0;
        while (i < stats.length) {
            stats[i] = new ResultStatistics(res[i].getResults());
            ++i;
        }
        return ResultStatistics.merge(stats);
    }
}

