/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.java;

import com.sap.tc.jtools.jtci.FilePosition;
import com.sap.tc.jtools.jtci.TestObject;
import com.sap.tc.jtools.jtci.TestObjectPosition;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.jtci.exceptions.InvalidTestObjectSpecification;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;

public class JavaFileArrayTestObject
extends TestObject {
    public static final String JAVA_FILE_LIST = "Java file list";
    private String[] fileNames;
    private String id;
    private String baseDir;
    private String[] codeClassification = ALL;
    protected static final String TAG_ITEM = "ITEM";
    protected static final String PARAMETER_BASEDIR = "BASE_DIR";
    public static final String CODE_CLASSIFICATION_TAG = "CODE_CLASSIFICATION";
    private static final String[] ALL = new String[]{"all"};

    public JavaFileArrayTestObject() {
    }

    public JavaFileArrayTestObject(String baseDir, String[] fileNames, String[] codeClassification) throws InvalidTestObjectSpecification {
        this.baseDir = baseDir;
        this.fileNames = fileNames;
        this.id = Integer.toString(fileNames.hashCode());
        this.codeClassification = codeClassification;
    }

    public JavaFileArrayTestObject(String baseDir, String[] fileNames) throws InvalidTestObjectSpecification {
        this.baseDir = baseDir;
        this.fileNames = fileNames;
        this.id = Integer.toString(fileNames.hashCode());
    }

    public JavaFileArrayTestObject(String baseDir, String[] fileNames, String id, String[] codeClassification) {
        this.baseDir = baseDir;
        this.fileNames = fileNames;
        this.id = id;
        this.codeClassification = codeClassification;
    }

    public JavaFileArrayTestObject(StructureTree tree) throws BadTreeException {
        if (!tree.getTag().equals("TEST_OBJECT")) {
            throw new BadTreeException();
        }
        StructureTree[] children = tree.getChildren(TAG_ITEM);
        this.baseDir = tree.getParameter(PARAMETER_BASEDIR);
        String[] files = new String[children.length];
        int kk = 0;
        while (kk < files.length) {
            files[kk] = children[kk].getText();
            ++kk;
        }
        String testObjectID = tree.getParameter("ID");
        this.fileNames = files;
        this.id = testObjectID == null ? Integer.toString(files.hashCode()) : testObjectID;
        StructureTree[] appliesToTrees = tree.getChildren(CODE_CLASSIFICATION_TAG);
        if (appliesToTrees.length > 0) {
            this.codeClassification = new String[appliesToTrees.length];
            int i = 0;
            while (i < appliesToTrees.length) {
                this.codeClassification[i] = appliesToTrees[i].getText();
                ++i;
            }
        }
    }

    public String getBaseDir() {
        return this.baseDir;
    }

    public String getType() {
        return JAVA_FILE_LIST;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public Object getValue() {
        return this.fileNames;
    }

    public String getID() {
        return this.id;
    }

    public StructureTree toStructureTree() {
        Header sourceHeader = new Header("TEST_OBJECT");
        sourceHeader.setParameter("TYPE", JAVA_FILE_LIST);
        sourceHeader.setParameter("ID", this.getID());
        if (this.baseDir != null) {
            sourceHeader.setParameter(PARAMETER_BASEDIR, this.baseDir);
        }
        StructureTree sourceTree = new StructureTree(sourceHeader);
        String[] files = this.getFileNames();
        int k = 0;
        while (k < files.length) {
            StructureTree fileTree = new StructureTree(new Header(TAG_ITEM));
            fileTree.setText(files[k]);
            sourceTree.addNewChild(fileTree);
            ++k;
        }
        int i = 0;
        while (i < this.codeClassification.length) {
            StructureTree newTree = new StructureTree(new Header(CODE_CLASSIFICATION_TAG));
            newTree.setText(this.codeClassification[i]);
            sourceTree.addNewChild(newTree);
            ++i;
        }
        return sourceTree;
    }

    public static TestObjectPosition getPosition(String file, int line, int column) {
        return new FilePosition(file, line, column);
    }

    public static TestObjectPosition getPosition(String file) {
        return new FilePosition(file);
    }

    public int getComponentCount() {
        return this.fileNames.length;
    }

    public String[] getCodeClassification() {
        return this.codeClassification;
    }

    public void setCodeClassification(String[] strings) {
        this.codeClassification = strings;
    }
}

