/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint.extension;

import com.sap.tc.jtools.jlint.TestConflictException;
import com.sap.tc.jtools.jlint.TestDescriptionSet;
import com.sap.tc.jtools.jlint.extension.JarClassLoader;
import com.sap.tc.jtools.jlint.extension.Module;
import com.sap.tc.jtools.jlint.extension.TestProviderInterface;
import com.sap.tc.jtools.jlint.extension.TestSet;
import com.sap.tc.jtools.jtci.TestObject;
import com.sap.tc.jtools.jtci.TestObjectPosition;
import com.sap.tc.jtools.jtci.TestTree;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.jtci.exceptions.InvalidTestObjectSpecification;
import com.sap.tc.jtools.util.structures.StructureTree;
import com.sap.tc.jtools.util.xml.XMLParseException;
import com.sap.tc.jtools.util.xml.XMLTool;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class TestProvider
implements TestProviderInterface {
    private static TestProvider provider = null;
    private static final String CONFIG_TAG = "configuration";
    private static final String LIB_TAG = "library";
    private static final String MODULE_TAG = "module";
    private static final String PATH_ATTR = "path";
    private static boolean initialized = false;
    private Map modules = new HashMap();

    public static TestProvider initialize(File configFile) throws BadTreeException, FileNotFoundException, IOException, XMLParseException {
        if (provider != null) {
            throw new IllegalStateException("already initialized!");
        }
        StructureTree tree = XMLTool.parseReader(new FileReader(configFile));
        Properties p = new Properties();
        p.setProperty("CURRENT_DIR", configFile.getParentFile().getAbsolutePath());
        tree.resolveMacros(p);
        initialized = true;
        provider = new TestProvider(tree);
        return provider;
    }

    public static TestProvider initialize(Module[] modules) {
        if (provider != null) {
            throw new IllegalStateException("already initialized!");
        }
        provider = new TestProvider(modules);
        initialized = true;
        return provider;
    }

    public static TestProvider getTestProvider() {
        if (provider == null) {
            throw new IllegalStateException("not initialized!");
        }
        return provider;
    }

    private TestProvider(StructureTree testProviderTree) throws BadTreeException, IOException, XMLParseException {
        if (!CONFIG_TAG.equals(testProviderTree.getTag())) {
            throw new BadTreeException();
        }
        StructureTree[] libTrees = testProviderTree.getChildren(LIB_TAG);
        ArrayList<File> libs = new ArrayList<File>();
        int i = 0;
        while (i < libTrees.length) {
            libs.add(new File(libTrees[i].getParameter(PATH_ATTR).trim()));
            ++i;
        }
        JarClassLoader rootClassLoader = new JarClassLoader(this.getClass().getClassLoader(), libs.toArray(new File[0]));
        StructureTree[] moduleTrees = testProviderTree.getChildren(MODULE_TAG);
        HashMap<String, Module> id2ModuleMap = new HashMap<String, Module>();
        int i2 = 0;
        while (i2 < moduleTrees.length) {
            Module mod = new Module(moduleTrees[i2], (ClassLoader)rootClassLoader, id2ModuleMap);
            this.modules.put(mod.getId(), mod);
            id2ModuleMap.put(mod.getId(), mod);
            ++i2;
        }
    }

    private TestProvider(Module[] modules) {
        int i = 0;
        while (i < modules.length) {
            this.modules.put(modules[i].getId(), modules[i]);
            ++i;
        }
    }

    public Class loadTestClass(String className) throws ClassNotFoundException {
        Collection mods = this.modules.values();
        Iterator iter = mods.iterator();
        while (iter.hasNext()) {
            Module mod = (Module)iter.next();
            try {
                Class c = mod.loadTestClass(className);
                return c;
            }
            catch (ClassNotFoundException cnfe) {
                // empty catch block
            }
        }
        throw new ClassNotFoundException(className);
    }

    public TestDescriptionSet getTestDescriptionSet() throws TestConflictException {
        TestTree tt = new TestTree();
        tt.setName("tests");
        TestDescriptionSet out = new TestDescriptionSet("global+local", 0, tt);
        Collection mods = this.modules.values();
        Iterator iter = mods.iterator();
        while (iter.hasNext()) {
            Module mod = (Module)iter.next();
            TestSet[] testSets = mod.getTestSets();
            int i = 0;
            while (i < testSets.length) {
                TestTree currentTree = testSets[i].getTestDescriptionSet().getTestTree();
                if ("".equals(currentTree.getName())) {
                    currentTree.setName(testSets[i].getTestDescriptionSet().getName());
                }
                tt.addTree(currentTree);
                ++i;
            }
        }
        return out;
    }

    public Module[] getModules() {
        return this.modules.values().toArray(new Module[0]);
    }

    public TestObject getTestObject(StructureTree testObjTree) throws InvalidTestObjectSpecification {
        Collection mods = this.modules.values();
        Iterator iter = mods.iterator();
        while (iter.hasNext()) {
            Module mod = (Module)iter.next();
            TestObject testObj = mod.getTestObject(testObjTree);
            if (testObj == null) continue;
            return testObj;
        }
        throw new InvalidTestObjectSpecification("testobject does not exist");
    }

    public TestObjectPosition getTestObjectPosition(String testObjectType, StructureTree positionTree) throws InvalidTestObjectSpecification {
        Collection mods = this.modules.values();
        Iterator iter = mods.iterator();
        while (iter.hasNext()) {
            Module mod = (Module)iter.next();
            TestObjectPosition testObjPosition = mod.getTestObjectPosition(testObjectType, positionTree);
            if (testObjPosition == null) continue;
            return testObjPosition;
        }
        throw new InvalidTestObjectSpecification("test object position does not exist");
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public Module getModule(String id) {
        return (Module)this.modules.get(id);
    }
}

