/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.jtools.jlint;

import com.sap.tc.jtools.jtci.TestObjectPosition;
import com.sap.tc.jtools.jtci.exceptions.BadTreeException;
import com.sap.tc.jtools.jtci.interfaces.ResultInterface;
import com.sap.tc.jtools.util.structures.Header;
import com.sap.tc.jtools.util.structures.StructureTree;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class Result
implements ResultInterface {
    public static final String PARAMETER_TAG_ERROR_MESSAGE = "MESSAGE";
    public static final String ERROR_MESSAGE_COULDNT_PERFORM = "Couldnt_perform";
    public static final String ERROR_MESSAGE_JOB_CANCELED = "job_canceled";
    public static final String ERROR_MESSAGE_MISSING_DATA = "Missing_data";
    public static final String ERROR_MESSAGE_SYNTAX_ERROR = "syntax_error";
    public static final String RESULT_PRIORITY = "PR";
    private String testName;
    private String testObjectType;
    private String testObjectID;
    private TestObjectPosition resultPosition;
    private int priority;
    private StructureTree errorMessageTree;

    public Result(String testName, String testObjectType, String testObjectID, TestObjectPosition position, int priority, String errorMessage, Properties errorMessageParameters) {
        this.testName = testName;
        this.testObjectType = testObjectType;
        this.testObjectID = testObjectID;
        this.priority = priority;
        this.resultPosition = position;
        Header messageHeader = new Header(PARAMETER_TAG_ERROR_MESSAGE);
        messageHeader.setParameter(RESULT_PRIORITY, Integer.toString(priority));
        this.errorMessageTree = new StructureTree(messageHeader);
        if (errorMessageParameters != null) {
            this.setParameters(errorMessageParameters);
        }
        this.errorMessageTree.setText(errorMessage);
    }

    public Result(StructureTree tree) throws BadTreeException {
        try {
            this.testName = tree.getOnlyChild("TEST").getParameter("NAME");
            this.priority = Integer.parseInt(tree.getParameter(RESULT_PRIORITY));
            this.errorMessageTree = tree.getOnlyChild("EM");
        }
        catch (Exception e) {
            throw new BadTreeException(e);
        }
    }

    public String getTestName() {
        return this.testName;
    }

    public String getTestObjectID() {
        return this.testObjectID;
    }

    public String getTestObjectType() {
        return this.testObjectType;
    }

    public TestObjectPosition getResultPosition() {
        return this.resultPosition;
    }

    public String getErrorText() {
        return this.errorMessageTree.getText();
    }

    public void setErrorText(String text) {
        this.errorMessageTree.setText(text);
    }

    public Properties getErrorParameters() {
        return this.errorMessageTree.getParameters();
    }

    public void setParameters(Properties errorMessageParameters) {
        Enumeration keys = ((Hashtable)errorMessageParameters).keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Header messageHeader = this.errorMessageTree.getHeader();
            messageHeader.setParameter(key, errorMessageParameters.getProperty(key));
        }
    }

    public int getPriority() {
        return this.priority;
    }

    public StructureTree toStructureTree() {
        String testObjectType = this.getTestObjectType();
        String thisSourceID = this.getTestObjectID();
        Header sourceHeader = new Header("SOURCE");
        sourceHeader.setParameter("ID", thisSourceID);
        sourceHeader.setParameter("TYPE", testObjectType);
        StructureTree sourceTree = new StructureTree(sourceHeader);
        String testName = this.getTestName();
        Header testHeader = new Header("TEST");
        testHeader.setParameter("NAME", testName);
        StructureTree testTree = new StructureTree(testHeader);
        sourceTree.addNewChild(testTree);
        testTree.addNewChild(this.errorMessageTree);
        TestObjectPosition position = this.getResultPosition();
        if (position != null) {
            this.errorMessageTree.addChild(position.toStructureTree());
        }
        return sourceTree;
    }
}

