/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.upload.api;

import com.sap.aii.upload.api.UploadKey;
import com.sap.aii.util.misc.api.BabelMessage;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UploadResult
implements Serializable {
    private static final long serialVersionUID = 42L;
    private static final String RB = "com.sap.aii.upload.api.rb_all.";
    Set objNew = new HashSet();
    Set objUpdate = new HashSet();
    Set objSkip = new HashSet();
    Set objNotFound = new HashSet();
    Map objFailed = new HashMap();
    public static final int STATUS_UNKNOWN = 0;
    public static final int STATUS_NEW = 1;
    public static final int STATUS_UPDATE = 2;
    public static final int STATUS_SKIP = 3;
    public static final int STATUS_NOT_FOUND = -1;
    public static final int STATUS_FAILED = -2;

    public void addNew(UploadKey key) {
        this.objNew.add(key);
    }

    public void addUpdate(UploadKey key) {
        this.objUpdate.add(key);
    }

    public void addSkip(UploadKey key) {
        this.objSkip.add(key);
    }

    public void addNotFound(UploadKey key) {
        this.objNotFound.add(key);
    }

    public void addFailed(UploadKey key, Throwable t) {
        this.objFailed.put(key, t);
    }

    public Set getObjectkeys() {
        HashSet result = new HashSet();
        result.addAll(this.objNew);
        result.addAll(this.objUpdate);
        result.addAll(this.objSkip);
        result.addAll(this.objNotFound);
        result.addAll(this.objFailed.keySet());
        return result;
    }

    public Set getObjectkeys(int status) {
        switch (status) {
            case 1: {
                return this.objNew;
            }
            case 2: {
                return this.objUpdate;
            }
            case 3: {
                return this.objSkip;
            }
            case -1: {
                return this.objNotFound;
            }
            case -2: {
                return this.objFailed.keySet();
            }
        }
        return new HashSet();
    }

    public int getStatusCode() {
        if (this.objFailed.size() > 0) {
            return -2;
        }
        if (this.objNotFound.size() > 0) {
            return -1;
        }
        if (this.objNew.size() > 0) {
            return 1;
        }
        if (this.objUpdate.size() > 0) {
            return 2;
        }
        if (this.objSkip.size() > 0) {
            return 3;
        }
        return 0;
    }

    public int getStatusCode(UploadKey key) {
        if (this.objNew.contains(key)) {
            return 1;
        }
        if (this.objUpdate.contains(key)) {
            return 2;
        }
        if (this.objSkip.contains(key)) {
            return 3;
        }
        if (this.objNotFound.contains(key)) {
            return -1;
        }
        if (this.objFailed.containsKey(key)) {
            return -2;
        }
        return 0;
    }

    public BabelMessage getStatusMessage(UploadKey key) {
        if (this.objNew.contains(key)) {
            return new BabelMessage("com.sap.aii.upload.api.rb_all.STATUS_NEW");
        }
        if (this.objUpdate.contains(key)) {
            return new BabelMessage("com.sap.aii.upload.api.rb_all.STATUS_UPDATE");
        }
        if (this.objSkip.contains(key)) {
            return new BabelMessage("com.sap.aii.upload.api.rb_all.STATUS_SKIP");
        }
        if (this.objNotFound.contains(key)) {
            return new BabelMessage("com.sap.aii.upload.api.rb_all.STATUS_NOT_FOUND");
        }
        if (this.objFailed.containsKey(key)) {
            Throwable t = (Throwable)this.objFailed.get(key);
            String mess = t.getMessage();
            return new BabelMessage("com.sap.aii.upload.api.rb_all.STATUS_FAILED", (Object)mess);
        }
        return new BabelMessage("com.sap.aii.upload.api.rb_all.STATUS_UNKOWN");
    }
}

