/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.upload.api;

import com.sap.aii.upload.api.ConnectionException;
import com.sap.aii.upload.api.NotFoundException;
import com.sap.aii.upload.api.SingleUploadResult;
import com.sap.aii.upload.api.StorageException;
import com.sap.aii.upload.api.StorageInterface;
import com.sap.aii.upload.api.UploadControl;
import com.sap.aii.upload.api.UploadException;
import com.sap.aii.upload.api.UploadKey;
import com.sap.aii.upload.api.UploadResult;
import com.sap.aii.upload.api.UploadSource;
import com.sap.aii.util.log.api.Logger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;

public class UploadEngine {
    private static final Logger log = Logger.getLogger((String)(class$com$sap$aii$upload$api$UploadEngine == null ? (class$com$sap$aii$upload$api$UploadEngine = UploadEngine.class$("com.sap.aii.upload.api.UploadEngine")) : class$com$sap$aii$upload$api$UploadEngine).getName());
    private StorageInterface cp;
    static /* synthetic */ Class class$com$sap$aii$upload$api$UploadEngine;

    public UploadEngine(StorageInterface cp) {
        this.cp = cp;
    }

    public void uploadObjects(UploadControl uploadControl, UploadSource source, Set keys, UploadResult uploadResult) throws ConnectionException, StorageException {
        Stack<UploadKey> waiting = new Stack<UploadKey>();
        HashSet<UploadKey> loaded = new HashSet<UploadKey>();
        waiting.addAll(keys);
        int n = 0;
        boolean overwrite = false;
        while (!waiting.isEmpty()) {
            Iterator i;
            UploadKey key = (UploadKey)waiting.pop();
            log.debug("processing key " + ++n + " (" + waiting.size() + " waiting) " + key);
            if (loaded.contains(key)) {
                log.fine("object is already loaded.");
                continue;
            }
            overwrite = keys.contains(key) ? uploadControl.getOverwrite() : uploadControl.getOverwriteRefs();
            boolean keyExists = this.cp.exists(key);
            boolean storeIt = true;
            boolean loadIt = true;
            if (keyExists && !overwrite) {
                loaded.add(key);
                log.fine("action: skip key ");
                uploadResult.addSkip(key);
                storeIt = false;
                loadIt = false;
            }
            if (!loadIt) continue;
            SingleUploadResult result = null;
            try {
                result = source.uploadObject(key, uploadControl);
            }
            catch (NotFoundException e) {
                log.warning("object " + key + " not found !");
                uploadResult.addNotFound(key);
                continue;
            }
            catch (UploadException e) {
                log.warning("Exception during Upload of object " + key, (Throwable)((Object)e));
                uploadResult.addFailed(key, (Throwable)((Object)e));
                continue;
            }
            if (storeIt) {
                log.fine("store object ");
                this.cp.write(result);
                if (keyExists) {
                    log.fine("action: update key ");
                    uploadResult.addUpdate(key);
                } else {
                    log.fine("action: new key ");
                    uploadResult.addNew(key);
                }
            }
            loaded.add(key);
            if (!uploadControl.getLoadRefs() || !(i = result.getReferences().iterator()).hasNext()) continue;
            StringBuffer sb = new StringBuffer("references:");
            while (i.hasNext()) {
                UploadKey k = (UploadKey)i.next();
                if (!loaded.contains(k)) {
                    waiting.push(k);
                    sb.append("\n\t" + k);
                    continue;
                }
                sb.append("\n\t[" + k + "]");
            }
            log.fine(sb.toString());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

