/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.upload.api;

import com.sap.aii.upload.api.UploadKey;
import com.sap.aii.upload.api.UploadObject;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class SingleUploadResult
extends UploadObject
implements Serializable {
    private static final long serialVersionUID = 42L;
    public static final int STATUS_OK = 0;
    public static final int STATUS_WARNING = 1;
    public static final int STATUS_ERROR = 2;
    private int status = 0;
    private ArrayList messages = new ArrayList();

    public SingleUploadResult(UploadKey key) {
        super(key, null, new HashSet());
    }

    public void addResult(int status, String mess, Exception e) {
        this.messages.add(new ResultMessage(status, mess, e));
        if (status > this.status) {
            this.status = status;
        }
    }

    public List getResults() {
        return this.messages;
    }

    public int getStatus() {
        return this.status;
    }

    public void print() throws Exception {
        PrintStream out = System.out;
        out.println("\n===== " + this.key + "=====");
        out.println("\n--- Status ---");
        out.println("Status = " + this.status);
        out.println("\n--- Messages ---");
        Iterator i = ((AbstractList)this.messages).iterator();
        while (i.hasNext()) {
            ResultMessage res = (ResultMessage)i.next();
            out.println(res.getMessage());
        }
        out.println("\n--- References ---");
        i = this.references.iterator();
        while (i.hasNext()) {
            UploadKey key = (UploadKey)i.next();
            out.println(key);
        }
    }

    public class ResultMessage {
        private Exception exception = null;
        private String message = null;
        private int status;

        public ResultMessage(int status, String mess, Exception exception) {
            this.status = status;
            this.message = mess;
            this.exception = exception;
        }

        public int getStatus() {
            return this.status;
        }

        public String getMessage() {
            return this.message;
        }

        public Exception getException() {
            return this.exception;
        }
    }
}

