/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.upload.api;

import com.sap.aii.upload.api.NotFoundException;
import com.sap.aii.upload.api.SimpleUploadKey;
import com.sap.aii.upload.api.StorageException;
import com.sap.aii.upload.api.StorageInterface;
import com.sap.aii.upload.api.UploadKey;
import com.sap.aii.upload.api.UploadObject;
import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.xml.api.XML;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;

public class FileStorage
implements StorageInterface {
    private static final Logger log = Logger.getLogger((String)(class$com$sap$aii$upload$api$FileStorage == null ? (class$com$sap$aii$upload$api$FileStorage = FileStorage.class$("com.sap.aii.upload.api.FileStorage")) : class$com$sap$aii$upload$api$FileStorage).getName());
    private static Map rootMap = new Hashtable();
    private File rootDir;
    static /* synthetic */ Class class$com$sap$aii$upload$api$FileStorage;

    private FileStorage(String dirName) {
        this.rootDir = new File(dirName);
        if (!this.rootDir.exists()) {
            this.rootDir.mkdirs();
        }
    }

    public static FileStorage getInstance(String rootDir) {
        if (rootMap.containsKey(rootDir)) {
            return (FileStorage)rootMap.get(rootDir);
        }
        FileStorage storage = new FileStorage(rootDir);
        rootMap.put(rootDir, storage);
        return storage;
    }

    private String makeFileName(String in) {
        if (in.length() == 0) {
            return "_";
        }
        StringBuffer sb = new StringBuffer(in);
        int i = 0;
        while (i < sb.length()) {
            if ("\\\"'/:<>{},?|*;".indexOf(sb.charAt(i)) >= 0) {
                sb.setCharAt(i, '_');
            }
            ++i;
        }
        return sb.toString();
    }

    private File getFile(UploadKey k) {
        String name = k instanceof SimpleUploadKey ? ((SimpleUploadKey)k).getName() + "." + k.getType() : k.toString();
        return new File(this.rootDir, this.makeFileName(name));
    }

    public boolean exists(UploadKey k) {
        File file = this.getFile(k);
        boolean result = file.exists();
        log.debug("exists " + k + " (" + file.getAbsolutePath() + ") = " + result);
        return result;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UploadObject read(UploadKey k) throws NotFoundException, StorageException {
        block13: {
            file = this.getFile(k);
            if (!file.exists()) {
                throw new NotFoundException(k);
            }
            FileStorage.log.debug("reading entry " + k + " (" + file.getAbsolutePath() + ")");
            fis = null;
            in = null;
            try {
                try {
                    fis = new FileInputStream(file);
                    in = new ObjectInputStream(fis);
                    refs = (Set)in.readObject();
                    xml = (XML)in.readObject();
                    var7_9 = new UploadObject(k, xml, refs);
                    var9_10 = null;
                    if (in == null) break block13;
                }
                catch (IOException e) {
                    throw new StorageException(e);
                }
                catch (ClassNotFoundException e) {
                    throw new StorageException(e);
                }
            }
            catch (Throwable var8_14) {
                var9_11 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                if (fis == null) throw var8_14;
                try {
                    fis.close();
                    throw var8_14;
                }
                catch (IOException e) {
                    throw var8_14;
                }
            }
            ** try [egrp 2[TRYBLOCK] [3 : 167->175)] { 
lbl40:
            // 1 sources

            in.close();
            break block13;
lbl42:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
        }
        if (fis == null) return var7_9;
        ** try [egrp 3[TRYBLOCK] [4 : 181->188)] { 
lbl47:
        // 1 sources

        fis.close();
        return var7_9;
lbl49:
        // 1 sources

        catch (IOException e) {
            // empty catch block
        }
        return var7_9;
    }

    /*
     * Loose catch block
     */
    public void write(UploadObject obj) throws StorageException {
        block14: {
            IOException e22;
            ObjectOutputStream out;
            FileOutputStream fos;
            block13: {
                UploadKey key = obj.getKey();
                File file = this.getFile(key);
                log.debug("writing " + key + " (" + file.getAbsolutePath() + ")");
                fos = null;
                out = null;
                fos = new FileOutputStream(file);
                out = new ObjectOutputStream(fos);
                out.writeObject(obj.getReferences());
                out.writeObject(obj.getObject());
                Object var8_6 = null;
                if (out == null) break block13;
                try {
                    out.close();
                }
                catch (IOException e22) {
                    // empty catch block
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e22) {}
            }
            break block14;
            {
                catch (IOException e3) {
                    throw new StorageException(e3);
                }
            }
            catch (Throwable throwable) {
                IOException e22;
                Object var8_7 = null;
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    public void delete(UploadKey k) {
        File file = this.getFile(k);
        log.debug("deleting " + k + " (" + file.getAbsolutePath() + ")");
        file.delete();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

