/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.offlinedeploy.rdb;

import com.sap.engine.tools.offlinedeploy.rdb.MSConnectionUtil;
import java.io.IOException;
import java.net.InetAddress;

public class MSClusterElementImpl {
    public static final int MS_J2EE_CLUSTERNODE_LN = 120;
    private MSConnectionUtil.ComInt clusterId;
    private MSConnectionUtil.ComInt groupId;
    private MSConnectionUtil.ComInt joinPort;
    private MSConnectionUtil.ComString name;
    private MSConnectionUtil.ComString host;
    private MSConnectionUtil.ComByteArray address;
    private MSConnectionUtil.ComByte nodeType;
    private MSConnectionUtil.ComByte state;
    public MSConnectionUtil.ComBitMask serviceMask;
    private InetAddress ipAddress = null;
    private byte[] buf;
    protected boolean isUpdated = true;

    public MSClusterElementImpl() {
        int pos = 0;
        this.buf = new byte[120];
        this.clusterId = new MSConnectionUtil.ComInt(this.buf, pos);
        this.groupId = new MSConnectionUtil.ComInt(this.buf, pos += this.clusterId.getMaxLength());
        this.joinPort = new MSConnectionUtil.ComInt(this.buf, pos += this.groupId.getMaxLength());
        this.name = new MSConnectionUtil.ComString(32, this.buf, pos += this.joinPort.getMaxLength());
        this.host = new MSConnectionUtil.ComString(32, this.buf, pos += this.name.getMaxLength());
        this.address = new MSConnectionUtil.ComByteArray(4, this.buf, pos += this.host.getMaxLength());
        this.nodeType = new MSConnectionUtil.ComByte(this.buf, pos += this.address.getMaxLength());
        this.state = new MSConnectionUtil.ComByte(this.buf, pos += this.nodeType.getMaxLength());
        this.serviceMask = new MSConnectionUtil.ComBitMask(32, this.buf, pos += this.state.getMaxLength());
        int n = pos + this.serviceMask.getMaxLength();
    }

    public MSClusterElementImpl(byte[] buf, int pos) throws IOException {
        this();
        this.deserialize(buf, pos);
    }

    public int Serialize(byte[] buf, int pos) {
        System.arraycopy(this.buf, 0, buf, pos, 120);
        return pos + 120;
    }

    public int deserialize(byte[] buf, int pos) throws IOException {
        System.arraycopy(buf, pos, this.buf, 0, 120);
        this.clusterId.Deserialize();
        this.groupId.Deserialize();
        this.joinPort.Deserialize();
        this.name.Deserialize();
        this.host.Deserialize();
        byte[] addressBuf = this.address.getByteArray();
        byte[] shortBuf = new byte[]{0, addressBuf[0], 0, addressBuf[1], 0, addressBuf[2], 0, addressBuf[3]};
        String addressString = new String(MSConnectionUtil.ComShort.get(shortBuf, 0) + "." + MSConnectionUtil.ComShort.get(shortBuf, 2) + "." + MSConnectionUtil.ComShort.get(shortBuf, 4) + "." + MSConnectionUtil.ComShort.get(shortBuf, 6));
        this.ipAddress = InetAddress.getByName(addressString);
        return 120;
    }

    public int getClusterId() {
        return this.clusterId.getInt();
    }

    public String getName() {
        return this.name.getString();
    }

    public byte getType() {
        return this.nodeType.getByte();
    }

    public synchronized byte getState() {
        return this.state.getByte();
    }

    public InetAddress getAddress() {
        return this.ipAddress;
    }

    public int getJoinPort() {
        return this.joinPort.getInt();
    }

    public int getGroupId() {
        return this.groupId.getInt();
    }

    protected synchronized byte testServiceBit(int bitNum) {
        return this.serviceMask.testBit(bitNum);
    }

    protected synchronized void setServiceBit(int bitNum) {
        this.serviceMask.setBit(bitNum);
    }

    protected synchronized void clearServiceBit(int bitNum) {
        this.serviceMask.clearBit(bitNum);
    }

    protected synchronized void setState(byte state) {
        this.state.setByte(state);
    }

    public String toString() {
        return new String("|" + this.getClusterId() + "|" + this.getGroupId() + "|" + this.getName() + "|" + this.getAddress() + "|" + this.getType() + "|" + this.getState());
    }

    public boolean equals(Object obj) {
        MSClusterElementImpl clusterElementObj = (MSClusterElementImpl)obj;
        return this.clusterId.getInt() == clusterElementObj.clusterId.getInt();
    }

    public int getLength() {
        return 120;
    }
}

