/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.offlinedeploy.rdb;

import com.sap.engine.tools.offlinedeploy.rdb.MSClusterElementImpl;
import com.sap.engine.tools.offlinedeploy.rdb.MSMessageHeader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;

class MSClusterElementCount {
    public static final int MS_J2EE_CLUSTERNODE_LST = 53;
    public static final int MS_HOST_CHARSET = 1;
    public static final int MS_J2EE_CLUSTERNODE_LN = 120;
    private String msHost;
    private int msPort;
    private Socket socket = null;
    private OutputStream outStream = null;
    private InputStream inStream = null;
    private InetAddress msAddress = null;
    private byte[] msgBody;
    private int msgLength = 0;

    public MSClusterElementCount(String msHost, int msPort) throws IOException {
        this.msHost = new String(msHost);
        this.msPort = msPort;
        this.msAddress = InetAddress.getByName(this.msHost);
        this.socket = new Socket(this.msAddress, this.msPort);
        this.outStream = this.socket.getOutputStream();
        this.inStream = this.socket.getInputStream();
    }

    public void close() {
        if (this.outStream != null) {
            try {
                this.outStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.outStream = null;
        }
        if (this.inStream != null) {
            try {
                this.inStream.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.inStream = null;
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.socket = null;
        }
    }

    public int getClusterElementCount() throws IOException {
        byte[] sendBody = new byte[]{53, 0, 0, 1};
        MSMessageHeader sendMsg = new MSMessageHeader();
        MSMessageHeader readMsg = new MSMessageHeader();
        sendMsg.initRequest("MSG_SERVER", 4);
        sendMsg.write(this.outStream, "MSCLIENT", sendBody, 0, 4);
        readMsg.read(this.inStream);
        if (readMsg.totalLength.getInt() == 0) {
            return 0;
        }
        this.readBody(this.inStream, readMsg.totalLength.getInt());
        int offset = 4;
        int count = (this.msgLength - offset) / 120;
        return count;
    }

    public int getRunningNodesCount() throws IOException {
        int count = 0;
        int allNodeCount = this.getClusterElementCount();
        int i = 0;
        int pos = 4;
        while (i < allNodeCount) {
            if (new MSClusterElementImpl(this.msgBody, pos).getState() == 3) {
                ++count;
            }
            ++i;
            pos += 120;
        }
        return count;
    }

    public void readBody(InputStream in, int bodyLength) throws IOException {
        this.msgBody = new byte[bodyLength];
        this.msgLength = bodyLength;
        int length = bodyLength;
        int offset = 0;
        while (length > 0) {
            int received = in.read(this.msgBody, offset, length);
            length -= received;
            offset += received;
        }
    }
}

