/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.tools.offlinedeploy.rdb;

import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.tools.offlinedeploy.rdb.EntityResolverImpl;
import com.sap.engine.tools.offlinedeploy.rdb.ODeploymentException;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;

public class FSExtractor {
    private static final String PROPS_KEY = "install.dir";
    private static final String METAINF = "META-INF";
    private static final String MANIFEST_SDA = "META-INF/SAP_MANIFEST.MF";
    private static StandardDOMParser domParser;
    private static String dtdDir;

    public FSExtractor() {
        try {
            EntityResolverImpl er = new EntityResolverImpl(dtdDir);
            domParser = new StandardDOMParser();
            domParser.setEntityResolver((EntityResolver)er);
            domParser.setValidation(true);
        }
        catch (Exception exc) {
            System.out.println("ERROR: Can't initialize XML parser.");
            exc.printStackTrace();
            System.exit(11);
        }
    }

    public void extract(File sdaFile, String propertiesFileName) throws Exception {
        String dstDirName;
        File dstDir;
        System.out.println("Upload information in " + sdaFile.getName() + " file.");
        System.out.println("Processing...");
        String installDirName = this.getInstallDir(propertiesFileName);
        File installDir = new File(installDirName);
        if (installDir == null) {
            this.throwOD(null, "ERROR: Problem creating directory: " + installDirName);
        }
        if (!installDir.exists() && !installDir.mkdirs()) {
            this.throwOD(null, "ERROR: Can't create directory: " + installDirName);
        }
        if ((dstDir = new File(dstDirName = this.getDstDir(sdaFile, installDirName))) == null) {
            this.throwOD(null, "ERROR: Problem creating directory: " + dstDirName);
        }
        if (!dstDir.exists() && !dstDir.mkdirs()) {
            this.throwOD(null, "ERROR: Can't create directory: " + dstDirName);
        }
        this.extractSDA(sdaFile, dstDirName);
    }

    private void extractSDA(File sdaFile, String dstDirName) throws Exception {
        ZipFile zip = new ZipFile(sdaFile);
        Enumeration<? extends ZipEntry> en = zip.entries();
        while (en.hasMoreElements()) {
            ZipEntry ze = en.nextElement();
            if (ze.getName().startsWith(METAINF) || ze.getName().endsWith("/")) continue;
            FSExtractor.storeEntry(new File(dstDirName, ze.getName()), zip.getInputStream(ze));
        }
    }

    private String getInstallDir(String propertiesFileName) throws Exception {
        Properties props = new Properties();
        try {
            props.load(new FileInputStream(new File(propertiesFileName)));
            String p = props.getProperty(PROPS_KEY);
            if (p == null) {
                this.throwOD(null, "ERROR: Can't find key: install.dir in property file: " + propertiesFileName);
            }
        }
        catch (IOException e) {
            this.throwOD(e, "ERROR: Can't locate DB properties file: " + propertiesFileName + "!");
        }
        return props.getProperty(PROPS_KEY);
    }

    private String getDstDir(File sdaFile, String installDirName) throws Exception {
        String dstDir = FSExtractor.getDstDirXML(sdaFile);
        if (dstDir != null) {
            dstDir = installDirName + dstDir;
        }
        return dstDir;
    }

    private static String getDstDirXML(File componentSDA) throws Exception {
        String res = null;
        String entryName = FSExtractor.getDescrXML(componentSDA);
        if (entryName != null) {
            int i;
            Document document;
            Element root;
            NodeList list;
            ZipFile zip = new ZipFile(componentSDA);
            ZipEntry entry = zip.getEntry("META-INF/" + entryName);
            if (entry != null && (list = (root = (document = domParser.parse(zip.getInputStream(entry))).getDocumentElement()).getElementsByTagName("default-deployment-dir")).getLength() > 0 && (i = (res = FSExtractor.getTextValue((Element)list.item(0))).indexOf("}")) != -1) {
                res = res.substring(i + 1);
            }
            zip.close();
        }
        return res;
    }

    private static String getDescrXML(File componentSDA) throws Exception {
        String line = null;
        String res = null;
        ZipFile zip = new ZipFile(componentSDA);
        ZipEntry entry = zip.getEntry(MANIFEST_SDA);
        if (entry != null) {
            BufferedReader in = new BufferedReader(new InputStreamReader(zip.getInputStream(entry)));
            while ((line = in.readLine()) != null) {
                if (line.indexOf("deployfile:") == -1) continue;
                res = line.substring(line.indexOf(":") + 1).trim();
                break;
            }
            in.close();
        }
        zip.close();
        return res;
    }

    private void throwOD(Exception e, String errMsg) throws ODeploymentException {
        errMsg = errMsg != null ? errMsg + "\n" : "";
        if (e != null) {
            errMsg = errMsg + this.getStackTrace(e);
        }
        if (errMsg.equals("")) {
            errMsg = "No message specified!";
        }
        throw new ODeploymentException(errMsg);
    }

    private String getStackTrace(Exception exc) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        exc.printStackTrace(ps);
        return baos.toString();
    }

    private static String getTextValue(Element element) {
        Node node;
        String result = null;
        if (element != null && (node = element.getFirstChild()) != null && node.getNodeType() == 3) {
            result = node.getNodeValue();
            result.trim();
            if (result.equals("") || result.equals("null")) {
                result = null;
            }
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static void storeEntry(File name, InputStream entry) {
        try {
            name.getParentFile().mkdirs();
            if (!name.isDirectory()) {
                int r;
                FileOutputStream fos = new FileOutputStream(name);
                byte[] buffer = new byte[1024];
                while ((r = entry.read(buffer)) != -1) {
                    void var4_5;
                    fos.write(buffer, 0, (int)var4_5);
                }
                entry.close();
                fos.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        dtdDir = "./dtd";
    }
}

