/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdsr.writer;

import com.sap.jdsr.writer.DsrAdmin;
import com.sap.jdsr.writer.DsrITrace;
import com.sap.jdsr.writer.DsrITraceEx;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.Hashtable;

public class DsrTrace {
    public static final String moduleNameToken = "Module-Name";
    public static final String moduleTypeToken = "Module-Type";
    public static final String pidToken = "PID";
    public static final String tidToken = "TID";
    public static final String javaTidToken = "Java-Tid";
    public static final String messageToken = "Message";
    public static final String levelToken = "Level";
    public static final String typeToken = "Type";
    public static final String lineToken = "Line#";
    public static final String durationToken = "Duration";
    public static final String extAccessToken = "Ext-Access";
    public static final String guidToken = "GUID";
    private static final String zeroString = "0000000000";
    private static final String nineString = "9999999999";
    private static final String nineSixString = "999999";
    private static StringBuffer traceRecord = new StringBuffer(512);
    private static StringBuffer traceFileName = new StringBuffer(512);
    private static RandomAccessFile traceFile = null;
    private static int currentHour = 0;
    private static Hashtable tracepaths = new Hashtable(10);

    private static RandomAccessFile getTraceFile(Calendar c, String component, String path) {
        int h;
        int d = c.get(5);
        int curHour = d * 24 + (h = c.get(11));
        if (currentHour == curHour && null != traceFile) {
            return traceFile;
        }
        currentHour = curHour;
        if (null != traceFile) {
            try {
                traceFile.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            traceFile = null;
        }
        int y = c.get(1);
        int m = c.get(2) + 1;
        if (0 != traceFileName.length()) {
            traceFileName.delete(0, traceFileName.length());
        }
        traceFileName.append(path);
        if (File.separatorChar != path.charAt(path.length() - 1)) {
            traceFileName.append(File.separator);
        }
        traceFileName.append(component);
        traceFileName.append("_java");
        traceFileName.append("_");
        traceFileName.append(9 < d ? Integer.toString(d) : "0" + Integer.toString(d));
        traceFileName.append(9 < m ? Integer.toString(m) : "0" + Integer.toString(m));
        traceFileName.append(y);
        traceFileName.append(9 < h ? Integer.toString(h) : "0" + Integer.toString(h));
        traceFileName.append("T");
        traceFileName.append(".trc");
        try {
            traceFile = new RandomAccessFile(traceFileName.toString(), "rw");
            traceFile.seek(traceFile.length());
        }
        catch (Exception e) {
            // empty catch block
        }
        return traceFile;
    }

    private static void getTimeString(Calendar c) {
        int y = c.get(1);
        int m = c.get(2) + 1;
        int d = c.get(5);
        int h = c.get(11);
        int mi = c.get(12);
        int s = c.get(13);
        int ms = c.get(14);
        traceRecord.append(y);
        traceRecord.append(9 < m ? Integer.toString(m) : "0" + Integer.toString(m));
        traceRecord.append(9 < d ? Integer.toString(d) : "0" + Integer.toString(d));
        traceRecord.append(" ");
        traceRecord.append(9 < h ? Integer.toString(h) : "0" + Integer.toString(h));
        traceRecord.append(":");
        traceRecord.append(9 < mi ? Integer.toString(mi) : "0" + Integer.toString(mi));
        traceRecord.append(":");
        traceRecord.append(9 < s ? Integer.toString(s) : "0" + Integer.toString(s));
        traceRecord.append(":");
        traceRecord.append(9 < ms ? (99 < ms ? Integer.toString(ms) : "0" + Integer.toString(ms)) : "00" + Integer.toString(ms));
    }

    private static Calendar getTimestamp() {
        return Calendar.getInstance(DsrAdmin.timezone);
    }

    public static synchronized void trace(DsrITrace traceInfo, int traceLevelOfCallingMethod) {
        Calendar cal;
        String modulename = traceInfo.getModuleName();
        String moduletype = traceInfo.getModuleType();
        boolean customTidFound = false;
        String javatid = null;
        int linenumber = 0;
        try {
            Class<?> inputClass = traceInfo.getClass();
            Class<?>[] inputInterfaces = inputClass.getInterfaces();
            int i = 0;
            while (i < inputInterfaces.length) {
                String interfaceName = inputInterfaces[i].getName();
                if (0 == interfaceName.compareTo("com.sap.jdsr.writer.DsrITraceEx")) {
                    javatid = ((DsrITraceEx)traceInfo).getThreadId();
                    if (null != javatid) {
                        customTidFound = true;
                    }
                    if (0 > (linenumber = ((DsrITraceEx)traceInfo).getLineNumber())) {
                        linenumber = 0;
                    }
                    break;
                }
                ++i;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (!customTidFound) {
            javatid = Thread.currentThread().getName();
        }
        String message = traceInfo.getMessage();
        String level = Integer.toString(traceLevelOfCallingMethod + 1000000000);
        String duration = Integer.toString(traceInfo.getDuration());
        String extaccess = traceInfo.getExternalAccess();
        String guid = traceInfo.GetTransId();
        String comp = DsrAdmin.convertToValidComponentName(traceInfo.getComponentName());
        if (null == comp) {
            return;
        }
        if (32 != guid.length()) {
            return;
        }
        String dir = (String)tracepaths.get(comp);
        if (null == dir) {
            if (null == dir && null == (dir = DsrAdmin.getComponentDirectory(comp))) {
                return;
            }
            if (!DsrAdmin.createDirectory(dir)) {
                return;
            }
            tracepaths.put(comp, dir);
        }
        if (null == (cal = DsrTrace.getTimestamp())) {
            return;
        }
        RandomAccessFile f = DsrTrace.getTraceFile(cal, comp, dir);
        if (null == f) {
            return;
        }
        try {
            int l;
            if (0 != traceRecord.length()) {
                traceRecord.delete(0, traceRecord.length());
            }
            DsrTrace.getTimeString(cal);
            traceRecord.append(" ");
            traceRecord.append(moduleNameToken);
            traceRecord.append("(");
            traceRecord.append(null == modulename ? "0" : Integer.toString(modulename.length()));
            traceRecord.append("): ");
            traceRecord.append(null == modulename ? "" : modulename);
            traceRecord.append(" ");
            traceRecord.append(moduleTypeToken);
            traceRecord.append("(");
            traceRecord.append(null == moduletype ? "0" : Integer.toString(moduletype.length()));
            traceRecord.append("): ");
            traceRecord.append(null == moduletype ? "" : moduletype);
            traceRecord.append(" ");
            traceRecord.append(pidToken);
            traceRecord.append(": 0000000000 ");
            traceRecord.append(tidToken);
            traceRecord.append(": 0000000000 ");
            traceRecord.append(javaTidToken);
            traceRecord.append("(");
            traceRecord.append(null == javatid ? "0" : Integer.toString(javatid.length()));
            traceRecord.append("): ");
            traceRecord.append(null == javatid ? "" : javatid);
            traceRecord.append(" ");
            traceRecord.append(messageToken);
            traceRecord.append("(");
            traceRecord.append(null == message ? "0" : Integer.toString(message.length()));
            traceRecord.append("): ");
            traceRecord.append(null == message ? "" : message);
            traceRecord.append(" ");
            traceRecord.append(levelToken);
            traceRecord.append(": 0");
            traceRecord.append(level.substring(1));
            traceRecord.append(" ");
            traceRecord.append(typeToken);
            traceRecord.append(": 0000000000 ");
            traceRecord.append(lineToken);
            if (0 == linenumber) {
                traceRecord.append(": 000000 ");
            } else {
                traceRecord.append(": ");
                String linenumberString = Integer.toString(linenumber);
                l = linenumberString.length();
                if (6 < l) {
                    traceRecord.append(nineSixString);
                } else if (6 == l) {
                    traceRecord.append(linenumberString);
                } else {
                    traceRecord.append(zeroString.substring(l + 4));
                    traceRecord.append(linenumberString);
                }
                traceRecord.append(" ");
            }
            traceRecord.append(durationToken);
            traceRecord.append(": ");
            l = duration.length();
            if (10 < l) {
                traceRecord.append(nineString);
            } else if (10 == l) {
                traceRecord.append(duration);
            } else {
                traceRecord.append(zeroString.substring(l));
                traceRecord.append(duration);
            }
            traceRecord.append(" ");
            traceRecord.append(extAccessToken);
            traceRecord.append("(");
            traceRecord.append(null == extaccess ? "0" : Integer.toString(extaccess.length()));
            traceRecord.append("): ");
            traceRecord.append(null == extaccess ? "" : extaccess);
            traceRecord.append(" ");
            traceRecord.append(guidToken);
            traceRecord.append("(");
            traceRecord.append(null == guid ? "0" : Integer.toString(guid.length()));
            traceRecord.append("): ");
            traceRecord.append(null == guid ? "" : guid);
            traceRecord.append("\n");
            f.write(traceRecord.toString().getBytes());
        }
        catch (Exception e) {
            // empty catch block
        }
    }
}

