/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdsr.writer;

import com.sap.jdsr.writer.DsrAdmin;
import com.sap.jdsr.writer.DsrIPassport;
import com.sap.jdsr.writer.DsrISubRecordCert;
import com.sap.jdsr.writer.DsrPassport;
import com.sap.jdsr.writer.DsrRecordAbstract;

public class DsrSubRecordCert
extends DsrRecordAbstract
implements DsrISubRecordCert {
    private int traceFlag = 0;
    private int service = 0;
    private int actionType = 0;
    private String compName = null;
    private String prevCompName = null;
    private String action = null;
    private String userId = null;
    private byte[] compNameByte = null;
    private byte[] prevCompNameByte = null;
    private byte[] actionByte = null;
    private byte[] userIdByte = null;
    private int satTraceBit = 1024;
    private static final int l1 = 6;

    public void clear() {
        this.traceFlag = 0;
        this.service = 0;
        this.actionType = 0;
        this.compName = null;
        this.prevCompName = null;
        this.action = null;
        this.userId = null;
        this.compNameByte = null;
        this.prevCompNameByte = null;
        this.actionByte = null;
        this.userIdByte = null;
    }

    public boolean isValid() {
        return null != this.compName;
    }

    public void setTraceFlag(int traceflag) {
        this.traceFlag = traceflag;
    }

    public void addSATToTraceFlag() {
        this.traceFlag |= this.satTraceBit;
    }

    public void removeSATFromFraceFlag() {
        this.traceFlag &= 65535 - this.satTraceBit;
    }

    public boolean isSATSetInTraceFlag() {
        return (this.traceFlag & this.satTraceBit) == this.satTraceBit;
    }

    public int getTraceFlag() {
        return this.traceFlag;
    }

    public void setService(int srv) {
        this.service = srv;
    }

    public int getService() {
        return this.service;
    }

    public void setActionType(int actiontype) {
        this.actionType = actiontype;
    }

    public int getActionType() {
        return this.actionType;
    }

    public boolean setCompName(String compname) {
        this.compName = DsrAdmin.convertToValidComponentName(compname);
        if (null == this.compName) {
            return false;
        }
        this.compNameByte = this.compName.getBytes();
        return true;
    }

    public String getCompName() {
        return this.compName;
    }

    public boolean setPrevCompName(String prevcompname) {
        this.prevCompName = DsrAdmin.convertToValidComponentName(prevcompname);
        if (null == this.prevCompName) {
            return false;
        }
        this.prevCompNameByte = this.prevCompName.getBytes();
        return true;
    }

    public String getPrevCompName() {
        return this.prevCompName;
    }

    public boolean setAction(String act) {
        if (null == act) {
            return false;
        }
        this.action = act;
        this.actionByte = act.getBytes();
        return true;
    }

    public String getAction() {
        return this.action;
    }

    public boolean setUserId(String userid) {
        if (null == userid) {
            return false;
        }
        this.userId = userid;
        this.userIdByte = userid.getBytes();
        return true;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setByPassport(DsrIPassport passport) {
        if (null == passport) {
            return;
        }
        this.clear();
        this.setBySubRecordCert(passport.getSubRecordCert());
    }

    public boolean setByNetPassport(byte[] netPassport) {
        int len;
        int l;
        int expectedLen;
        int position = 0;
        String componentNameI = null;
        String previousComponentNameI = null;
        String actionI = null;
        String userIdI = null;
        int traceFlagI = 0;
        int serviceI = 0;
        int actionTypeI = 0;
        if (null == netPassport) {
            return false;
        }
        if (185 != netPassport.length && 160 != netPassport.length) {
            return false;
        }
        if (0 != DsrPassport.arrayCmp(netPassport, 0, DsrPassport.eyeCatcher, 0, 4)) {
            return false;
        }
        if (0 != DsrPassport.arrayCmp(netPassport, netPassport.length - 4, DsrPassport.eyeCatcher, 0, 4)) {
            return false;
        }
        if (1 == netPassport[position += 4]) {
            expectedLen = 160;
        } else if (2 == netPassport[position]) {
            expectedLen = 185;
        } else {
            return false;
        }
        int h = netPassport[++position];
        if (0 > h) {
            h += 256;
        }
        if (0 > (l = netPassport[position + 1])) {
            l += 256;
        }
        if (expectedLen != (len = h * 256 + l)) {
            return false;
        }
        h = netPassport[(position += 2) + 1];
        if (0 > h) {
            h += 256;
        }
        if (0 > (l = netPassport[position])) {
            l += 256;
        }
        traceFlagI = h * 256 + l;
        position += 2;
        int t = 31;
        while (t >= 0) {
            if (0 != netPassport[position + t]) break;
            --t;
        }
        componentNameI = new String(netPassport, position, t + 1);
        h = netPassport[position += 32];
        if (0 > h) {
            h += 256;
        }
        if (0 > (l = netPassport[position + 1])) {
            l += 256;
        }
        serviceI = h * 256 + l;
        position += 2;
        t = 31;
        while (t >= 0) {
            if (0 != netPassport[position + t]) break;
            --t;
        }
        userIdI = new String(netPassport, position, t + 1);
        position += 32;
        t = 39;
        while (t >= 0) {
            if (0 != netPassport[position + t]) break;
            --t;
        }
        actionI = new String(netPassport, position, t + 1);
        h = netPassport[position += 40];
        if (0 > h) {
            h += 256;
        }
        if (0 > (l = netPassport[position + 1])) {
            l += 256;
        }
        actionTypeI = h * 256 + l;
        position += 2;
        t = 31;
        while (t >= 0) {
            if (0 != netPassport[position + t]) break;
            --t;
        }
        previousComponentNameI = new String(netPassport, position, t + 1);
        position += 32;
        this.clear();
        if (!this.setAction(actionI)) {
            return false;
        }
        if (!this.setUserId(userIdI)) {
            return false;
        }
        if (!this.setPrevCompName(previousComponentNameI)) {
            return false;
        }
        if (!this.setCompName(componentNameI)) {
            return false;
        }
        this.actionType = actionTypeI;
        this.service = serviceI;
        this.traceFlag = traceFlagI;
        return true;
    }

    public void setBySubRecordCert(DsrISubRecordCert certSubRecord) {
        if (null == certSubRecord) {
            return;
        }
        this.clear();
        this.traceFlag = certSubRecord.getTraceFlag();
        this.actionType = certSubRecord.getActionType();
        this.service = certSubRecord.getService();
        this.setCompName(certSubRecord.getCompName());
        this.setPrevCompName(certSubRecord.getPrevCompName());
        this.setAction(certSubRecord.getAction());
        this.setUserId(certSubRecord.getUserId());
    }

    protected int getData(byte[] buf, int offset) {
        int pos = offset;
        try {
            DsrAdmin.int2FourByte(234565432, buf, pos);
            pos += 6;
            if (0 != this.traceFlag) {
                buf[pos] = 26;
                buf[++pos] = 0;
                DsrAdmin.int2FourByte(this.traceFlag, buf, ++pos);
                pos += 4;
            }
            if (0 != this.service) {
                buf[pos] = 11;
                buf[++pos] = 0;
                DsrAdmin.int2FourByte(this.service, buf, ++pos);
                pos += 4;
            }
            if (0 != this.actionType) {
                buf[pos] = 1;
                buf[++pos] = 0;
                DsrAdmin.int2FourByte(this.actionType, buf, ++pos);
                pos += 4;
            }
            if (null != this.compName) {
                if (null == this.compNameByte) {
                    this.compNameByte = this.compName.getBytes();
                }
                buf[pos] = 17;
                buf[++pos] = 2;
                DsrAdmin.int2TwoByte(this.compNameByte.length, buf, ++pos);
                System.arraycopy(this.compNameByte, 0, buf, pos += 2, this.compNameByte.length);
                pos += this.compNameByte.length;
            }
            if (null != this.prevCompName) {
                if (null == this.prevCompNameByte) {
                    this.prevCompNameByte = this.prevCompName.getBytes();
                }
                buf[pos] = 27;
                buf[++pos] = 2;
                DsrAdmin.int2TwoByte(this.prevCompNameByte.length, buf, ++pos);
                System.arraycopy(this.prevCompNameByte, 0, buf, pos += 2, this.prevCompNameByte.length);
                pos += this.prevCompNameByte.length;
            }
            if (null != this.action) {
                if (null == this.actionByte) {
                    this.actionByte = this.action.getBytes();
                }
                buf[pos] = 0;
                buf[++pos] = 2;
                DsrAdmin.int2TwoByte(this.actionByte.length, buf, ++pos);
                System.arraycopy(this.actionByte, 0, buf, pos += 2, this.actionByte.length);
                pos += this.actionByte.length;
            }
            if (null != this.userId) {
                if (null == this.userIdByte) {
                    this.userIdByte = this.userId.getBytes();
                }
                buf[pos] = 14;
                buf[++pos] = 2;
                DsrAdmin.int2TwoByte(this.userIdByte.length, buf, ++pos);
                System.arraycopy(this.userIdByte, 0, buf, pos += 2, this.userIdByte.length);
                pos += this.userIdByte.length;
            }
            DsrAdmin.int2TwoByte(pos - offset, buf, offset + 4);
        }
        catch (Exception e) {
            return 0;
        }
        return pos - offset;
    }
}

