/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdsr.writer;

import com.sap.jdsr.writer.DsrAdmin;
import com.sap.jdsr.writer.DsrComponentAdmin;
import com.sap.jdsr.writer.DsrIMainRecord;
import com.sap.jdsr.writer.DsrIRecordSet;
import com.sap.jdsr.writer.DsrISubRecordCall1;
import com.sap.jdsr.writer.DsrISubRecordCall2;
import com.sap.jdsr.writer.DsrISubRecordCert;
import com.sap.jdsr.writer.DsrMainRecord;
import com.sap.jdsr.writer.DsrRecordAbstract;
import com.sap.jdsr.writer.DsrSubRecordCall1;
import com.sap.jdsr.writer.DsrSubRecordCall2;
import com.sap.jdsr.writer.DsrSubRecordCert;
import java.util.Vector;

public class DsrRecordSet
extends DsrRecordAbstract
implements DsrIRecordSet {
    private String componentName = null;
    private DsrComponentAdmin ca = null;
    private DsrMainRecord mainRecord = new DsrMainRecord();
    private DsrSubRecordCert certRecord = new DsrSubRecordCert();
    private Vector call1RecordVector = new Vector(5, 5);
    private Vector call2RecordVector = new Vector(5, 5);

    protected DsrRecordSet(String componentname, String convertedname) {
        this.componentName = convertedname;
        this.ca = DsrAdmin.getCreateComponentAdmin(componentname, convertedname);
    }

    public void clear() {
        this.mainRecord.clear();
        this.certRecord.clear();
        int j = this.call1RecordVector.size();
        int i = 0;
        while (i < j) {
            ((DsrSubRecordCall1)this.call1RecordVector.elementAt(i)).clear();
            ++i;
        }
        j = this.call2RecordVector.size();
        i = 0;
        while (i < j) {
            ((DsrSubRecordCall2)this.call2RecordVector.elementAt(i)).clear();
            ++i;
        }
    }

    public boolean isValid() {
        return this.mainRecord.isValid();
    }

    public String getComponentName() {
        return this.componentName;
    }

    public DsrIMainRecord getMainRecord() {
        return this.mainRecord;
    }

    public DsrISubRecordCert getCertRecord() {
        return this.certRecord;
    }

    public DsrISubRecordCall1 getCall1RecordByNumber(int number) {
        int i = 0;
        int s = this.call1RecordVector.size();
        if (0 > number) {
            return null;
        }
        if (number < s) {
            return (DsrSubRecordCall1)this.call1RecordVector.elementAt(number);
        }
        i = s;
        while (i <= number) {
            this.call1RecordVector.add(new DsrSubRecordCall1());
            ++i;
        }
        return (DsrSubRecordCall1)this.call1RecordVector.elementAt(number);
    }

    public int getCurrentCall1RecordCount() {
        int s = this.call1RecordVector.size();
        int c = 0;
        int i = 0;
        while (i < s) {
            if (((DsrSubRecordCall1)this.call1RecordVector.elementAt(i)).isValid()) {
                ++c;
            }
            ++i;
        }
        return c;
    }

    public void clearAllCall1Records() {
        this.call1RecordVector.clear();
    }

    public DsrISubRecordCall2 getCall2RecordByNumber(int number) {
        int i = 0;
        int s = this.call2RecordVector.size();
        if (0 > number) {
            return null;
        }
        if (number < s) {
            return (DsrSubRecordCall2)this.call2RecordVector.elementAt(number);
        }
        i = s;
        while (i <= number) {
            this.call2RecordVector.add(new DsrSubRecordCall2());
            ++i;
        }
        return (DsrSubRecordCall2)this.call2RecordVector.elementAt(number);
    }

    public int getCurrentCall2RecordCount() {
        int s = this.call2RecordVector.size();
        int c = 0;
        int i = 0;
        while (i < s) {
            if (((DsrSubRecordCall2)this.call2RecordVector.elementAt(i)).isValid()) {
                ++c;
            }
            ++i;
        }
        return c;
    }

    public void clearAllCall2Records() {
        this.call2RecordVector.clear();
    }

    public boolean write() {
        if (!this.isValid()) {
            return false;
        }
        if (null == this.ca) {
            return false;
        }
        return this.ca.getBufferAdmin().write(this);
    }

    protected int getData(byte[] buf, int offset) {
        int loff = offset;
        int i = this.mainRecord.getData(buf, loff);
        if (0 >= i) {
            return 0;
        }
        loff += i;
        if (this.certRecord.isValid()) {
            loff += this.certRecord.getData(buf, loff);
        }
        int j = this.call1RecordVector.size();
        i = 0;
        while (i < j) {
            DsrSubRecordCall1 c1 = (DsrSubRecordCall1)this.call1RecordVector.elementAt(i);
            if (c1.isValid()) {
                loff += c1.getData(buf, loff);
            }
            ++i;
        }
        j = this.call2RecordVector.size();
        i = 0;
        while (i < j) {
            DsrSubRecordCall2 c2 = (DsrSubRecordCall2)this.call2RecordVector.elementAt(i);
            if (c2.isValid()) {
                loff += c2.getData(buf, loff);
            }
            ++i;
        }
        return loff - offset;
    }
}

