/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdsr.writer;

import com.sap.jdsr.writer.DsrAdmin;
import com.sap.jdsr.writer.DsrIMainRecord;
import com.sap.jdsr.writer.DsrIPassport;
import com.sap.jdsr.writer.DsrRecordAbstract;
import java.net.InetAddress;

public class DsrMainRecord
extends DsrRecordAbstract
implements DsrIMainRecord {
    private long startTime = 0L;
    private int service = 0;
    private int actionType = 0;
    private int cpuTime = 0;
    private int queueTime = 0;
    private int loadTime = 0;
    private int genTime = 0;
    private int netTime = 0;
    private int waitTime = 0;
    private int respTime = 0;
    private int maxMem = 0;
    private int luwInfo = 0;
    private String transId = null;
    private String action = null;
    private String userId = null;
    private String addInfo = null;
    private StringBuffer transIdStringBuffer = null;
    private byte[] transIdBytes = null;
    private byte[] actionBytes = null;
    private byte[] userIdBytes = null;
    private byte[] addInfoBytes = null;
    private static final int l1 = 16;
    private String guidPrefix;

    DsrMainRecord() {
        InetAddress adr = null;
        byte[] ipAdr = null;
        int ipAddress = 0;
        int hashCode = 0;
        this.transIdStringBuffer = new StringBuffer(32);
        hashCode = this.hashCode();
        hashCode &= 0xFFFFFFFF;
        try {
            adr = InetAddress.getLocalHost();
        }
        catch (Exception e) {
            adr = null;
        }
        if (null == adr) {
            ipAddress = DsrAdmin.randomSeed.nextInt() & 0xFFFFFFFF;
            return;
        }
        ipAdr = adr.getAddress();
        int j = 1;
        int i = 0;
        while (i < ipAdr.length) {
            ipAddress += ipAdr[i] * j;
            j *= 256;
            ++i;
        }
        this.guidPrefix = new String(Integer.toHexString(ipAddress &= 0xFFFFFFFF).toUpperCase() + Integer.toHexString(hashCode).toUpperCase());
    }

    public void clear() {
        this.startTime = 0L;
        this.service = 0;
        this.actionType = 0;
        this.cpuTime = 0;
        this.queueTime = 0;
        this.loadTime = 0;
        this.genTime = 0;
        this.netTime = 0;
        this.waitTime = 0;
        this.respTime = 0;
        this.maxMem = 0;
        this.luwInfo = 0;
        this.transId = null;
        this.action = null;
        this.userId = null;
        this.addInfo = null;
        this.transIdBytes = null;
        this.actionBytes = null;
        this.userIdBytes = null;
        this.addInfoBytes = null;
    }

    public boolean isValid() {
        if (0L == this.startTime) {
            return false;
        }
        return null != this.action;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime() {
        this.startTime = System.currentTimeMillis();
    }

    public void setStartTime(long s) {
        this.startTime = s;
    }

    public int getService() {
        return this.service;
    }

    public void setService(int srv) {
        this.service = srv;
    }

    public int getActionType() {
        return this.actionType;
    }

    public void setActionType(int acttiontype) {
        this.actionType = acttiontype;
    }

    public int getCpuTime() {
        return this.cpuTime;
    }

    public void setCpuTime(int cputime) {
        this.cpuTime = cputime;
    }

    public int getQueueTime() {
        return this.queueTime;
    }

    public void setQueueTime(int queuetime) {
        this.queueTime = queuetime;
    }

    public int getLoadTime() {
        return this.loadTime;
    }

    public void setLoadTime(int loadtime) {
        this.loadTime = loadtime;
    }

    public int getGenTime() {
        return this.genTime;
    }

    public void setGenTime(int gentime) {
        this.genTime = gentime;
    }

    public int getNetTime() {
        return this.netTime;
    }

    public void setNetTime(int nettime) {
        this.netTime = nettime;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int waittime) {
        this.waitTime = waittime;
    }

    public int getRespTime() {
        return this.respTime;
    }

    public void setRespTime(int resptime) {
        this.respTime = resptime;
    }

    public int getMaxMem() {
        return this.maxMem;
    }

    public void setMaxMem(int maxmem) {
        this.maxMem = maxmem;
    }

    public int getLuwInfo() {
        return this.luwInfo;
    }

    public void setLuwInfoStart() {
        this.luwInfo = 1;
    }

    public void setLuwInfoEnd() {
        this.luwInfo = 2;
    }

    public String getTransId() {
        return this.transId;
    }

    public boolean setTransId(String transid) {
        if (null == transid) {
            return false;
        }
        this.transId = transid;
        this.transIdBytes = transid.getBytes();
        return true;
    }

    public boolean setTransId(DsrIPassport passport) {
        if (null == passport) {
            return false;
        }
        this.transId = passport.getTransId();
        if (null == this.transId) {
            return false;
        }
        this.transIdBytes = this.transId.getBytes();
        return true;
    }

    public void setNewTransId() {
        if (0 < this.transIdStringBuffer.length()) {
            this.transIdStringBuffer.delete(0, this.transIdStringBuffer.length());
        }
        this.transIdStringBuffer.append(this.guidPrefix);
        this.transIdStringBuffer.append(Integer.toHexString((int)(System.currentTimeMillis() & 0xFFFFFFFFFFFFFFFFL)).toUpperCase());
        this.transIdStringBuffer.append(Integer.toHexString(DsrAdmin.randomSeed.nextInt()).toUpperCase());
        int l = 32 - this.transIdStringBuffer.length();
        if (0 != l) {
            int i = 0;
            while (i < l) {
                int j = DsrAdmin.randomSeed.nextInt() % 10;
                if (0 > j) {
                    j *= -1;
                }
                this.transIdStringBuffer.append(j);
                ++i;
            }
        }
        this.transId = this.transIdStringBuffer.toString();
        this.transIdBytes = this.transId.getBytes();
    }

    public String getAction() {
        return this.action;
    }

    public boolean setAction(String act) {
        if (null == act) {
            return false;
        }
        this.action = act;
        this.actionBytes = act.getBytes();
        return true;
    }

    public String getUserId() {
        return this.userId;
    }

    public boolean setUserId(String userid) {
        if (null == userid) {
            return false;
        }
        this.userId = userid;
        this.userIdBytes = userid.getBytes();
        return true;
    }

    public String getAddInfo() {
        return this.addInfo;
    }

    public boolean setAddInfo(String addinfo) {
        if (null == addinfo) {
            return false;
        }
        this.addInfo = addinfo;
        this.addInfoBytes = addinfo.getBytes();
        return true;
    }

    protected int getData(byte[] buf, int offset) {
        int pos = offset;
        try {
            DsrAdmin.int2FourByte(123454321, buf, pos);
            pos += 16;
            if (0L != this.startTime) {
                buf[pos] = 12;
                buf[++pos] = 1;
                DsrAdmin.long2EightByte(this.startTime / 1000L, buf, ++pos);
                buf[pos += 8] = 28;
                buf[++pos] = 0;
                DsrAdmin.int2FourByte((int)(this.startTime % 1000L), buf, ++pos);
                pos += 4;
            }
            if (0 != this.service) {
                buf[pos] = 11;
                buf[++pos] = 0;
                DsrAdmin.int2FourByte(this.service, buf, ++pos);
                pos += 4;
            }
            if (0 != this.actionType) {
                buf[pos] = 1;
                buf[++pos] = 0;
                DsrAdmin.int2FourByte(this.actionType, buf, ++pos);
                pos += 4;
            }
            if (0 != this.cpuTime) {
                buf[pos] = 3;
                buf[++pos] = 0;
                DsrAdmin.int2FourByte(this.cpuTime, buf, ++pos);
                pos += 4;
            }
            if (0 != this.queueTime) {
                buf[pos] = 9;
                buf[++pos] = 0;
                DsrAdmin.int2FourByte(this.queueTime, buf, ++pos);
                pos += 4;
            }
            if (0 != this.loadTime) {
                buf[pos] = 5;
                buf[++pos] = 0;
                DsrAdmin.int2FourByte(this.loadTime, buf, ++pos);
                pos += 4;
            }
            if (0 != this.genTime) {
                buf[pos] = 4;
                buf[++pos] = 0;
                DsrAdmin.int2FourByte(this.genTime, buf, ++pos);
                pos += 4;
            }
            if (0 != this.netTime) {
                buf[pos] = 8;
                buf[++pos] = 0;
                DsrAdmin.int2FourByte(this.netTime, buf, ++pos);
                pos += 4;
            }
            if (0 != this.waitTime) {
                buf[pos] = 15;
                buf[++pos] = 0;
                DsrAdmin.int2FourByte(this.waitTime, buf, ++pos);
                pos += 4;
            }
            if (0 != this.respTime) {
                buf[pos] = 10;
                buf[++pos] = 0;
                DsrAdmin.int2FourByte(this.respTime, buf, ++pos);
                pos += 4;
            }
            if (0 != this.maxMem) {
                buf[pos] = 7;
                buf[++pos] = 0;
                DsrAdmin.int2FourByte(this.maxMem, buf, ++pos);
                pos += 4;
            }
            if (0 != this.luwInfo) {
                buf[pos] = 6;
                buf[++pos] = 0;
                DsrAdmin.int2FourByte(this.luwInfo, buf, ++pos);
                pos += 4;
            }
            if (null != this.transId) {
                if (null == this.transIdBytes) {
                    this.transIdBytes = this.transId.getBytes();
                }
                buf[pos] = 13;
                buf[++pos] = 2;
                DsrAdmin.int2TwoByte(this.transIdBytes.length, buf, ++pos);
                System.arraycopy(this.transIdBytes, 0, buf, pos += 2, this.transIdBytes.length);
                pos += this.transIdBytes.length;
            }
            if (null != this.action) {
                if (null == this.actionBytes) {
                    this.actionBytes = this.action.getBytes();
                }
                buf[pos] = 0;
                buf[++pos] = 2;
                DsrAdmin.int2TwoByte(this.actionBytes.length, buf, ++pos);
                System.arraycopy(this.actionBytes, 0, buf, pos += 2, this.actionBytes.length);
                pos += this.actionBytes.length;
            }
            if (null != this.userId) {
                if (null == this.userIdBytes) {
                    this.userIdBytes = this.userId.getBytes();
                }
                buf[pos] = 14;
                buf[++pos] = 2;
                DsrAdmin.int2TwoByte(this.userIdBytes.length, buf, ++pos);
                System.arraycopy(this.userIdBytes, 0, buf, pos += 2, this.userIdBytes.length);
                pos += this.userIdBytes.length;
            }
            if (null != this.addInfo) {
                if (null == this.addInfoBytes) {
                    this.addInfoBytes = this.addInfo.getBytes();
                }
                buf[pos] = 2;
                buf[++pos] = 2;
                DsrAdmin.int2TwoByte(this.addInfoBytes.length, buf, ++pos);
                System.arraycopy(this.addInfoBytes, 0, buf, pos += 2, this.addInfoBytes.length);
                pos += this.addInfoBytes.length;
            }
            DsrAdmin.int2TwoByte(pos - offset, buf, offset + 4);
        }
        catch (Exception e) {
            return 0;
        }
        return pos - offset;
    }
}

