/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdsr.writer;

import com.sap.jdsr.writer.DsrAdmin;
import com.sap.jdsr.writer.DsrBufferAdmin;
import com.sap.jdsr.writer.DsrComponentStaticData;
import com.sap.jdsr.writer.DsrIComponentStaticData;

public class DsrComponentAdmin {
    private DsrIComponentStaticData statData = null;
    private DsrBufferAdmin bufferAdmin = null;
    private String componentName = null;
    private String orgComponentName = null;
    private String visibleOnSetStaticPropertyString = null;
    private boolean isVisible = false;
    public int traceFlag = 0;

    protected DsrComponentAdmin(String componentname, String convertedcomponentname) {
        this.bufferAdmin = new DsrBufferAdmin(convertedcomponentname, this);
        this.componentName = convertedcomponentname;
        this.orgComponentName = componentname;
        this.visibleOnSetStaticPropertyString = new String("dsr." + componentname + ".visibleonsetstatic");
        Integer visibleOnSetStatic = Integer.getInteger(this.visibleOnSetStaticPropertyString);
        if (null == visibleOnSetStatic) {
            this.isVisible = true;
        } else if (0 == visibleOnSetStatic) {
            this.isVisible = true;
        }
    }

    protected boolean isVisible() {
        return this.isVisible;
    }

    protected DsrBufferAdmin getBufferAdmin() {
        return this.bufferAdmin;
    }

    protected synchronized DsrIComponentStaticData getComponentStaticData() {
        return this.statData;
    }

    protected synchronized boolean setComponentStaticData(DsrIComponentStaticData s) {
        if (0 != this.traceFlag) {
            DsrAdmin.trace(this.componentName, "DsrComponentAdmin: setComponentStaticData(): setting data for component " + this.componentName);
            if (null != ((DsrComponentStaticData)s).componentVersion) {
                DsrAdmin.trace(this.componentName, "DsrComponentAdmin: setComponentStaticData(): version is " + ((DsrComponentStaticData)s).componentVersion);
            }
            if (null != ((DsrComponentStaticData)s).componentType) {
                DsrAdmin.trace(this.componentName, "DsrComponentAdmin: setComponentStaticData(): type is " + ((DsrComponentStaticData)s).componentType);
            }
        }
        if (null == ((DsrComponentStaticData)s).componentType) {
            if (0 != this.traceFlag) {
                DsrAdmin.trace(this.componentName, "DsrComponentAdmin: setComponentStaticData(): type is null");
            }
            return false;
        }
        int l = ((DsrComponentStaticData)s).componentType.length();
        boolean isValid = false;
        int i = 0;
        while (i < l) {
            if (((DsrComponentStaticData)s).componentType.charAt(i) != ' ') {
                isValid = true;
                break;
            }
            ++i;
        }
        if (isValid) {
            this.statData = s;
            DsrAdmin.setLastChangeTime();
            this.isVisible = true;
            return true;
        }
        if (0 != this.traceFlag) {
            DsrAdmin.trace(this.componentName, "DsrComponentAdmin: setComponentStaticData(): type <" + ((DsrComponentStaticData)s).componentType + "> not valid.");
        }
        return false;
    }

    protected String getComponentName() {
        return this.componentName;
    }

    protected String getOrgComponentName() {
        return this.orgComponentName;
    }

    public boolean flush() {
        if (null == this.bufferAdmin) {
            if (0 != this.traceFlag) {
                DsrAdmin.trace(this.componentName, "DsrComponentAdmin: flush(): bufferAdmin is null.");
            }
            return false;
        }
        return this.bufferAdmin.flush();
    }
}

