/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdsr.writer;

import com.sap.jdsr.writer.DsrAdmin;
import com.sap.jdsr.writer.DsrBuffer;
import com.sap.jdsr.writer.DsrComponentAdmin;
import com.sap.jdsr.writer.DsrRecordSet;

public class DsrBufferAdmin
implements Runnable {
    private String componentName = null;
    private DsrBuffer[] bufferArray = new DsrBuffer[2];
    private DsrBuffer bufferToFlush = null;
    private Thread flushThread = new Thread(this);
    private int activeBuffer = 0;
    private int passiveBuffer = 1;
    private DsrComponentAdmin ca = null;
    private boolean isWriteLocked = false;
    private int requiredSpace;
    private boolean swapBuffer = false;
    private boolean bufferJustSwaped = false;
    private String bufferSizePropertyString = null;

    protected DsrBufferAdmin(String componentname, DsrComponentAdmin c) {
        try {
            this.flushThread.setName("SAPDSR_flush_" + componentname);
            this.componentName = componentname;
            this.ca = c;
            this.bufferSizePropertyString = new String("dsr." + componentname + ".buffersize");
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.componentName, "DsrBufferAdmin: DsrBufferAdmin(): component: " + componentname);
            }
            this.bufferArray[0] = new DsrBuffer(componentname, c, this.bufferSizePropertyString);
            this.bufferArray[1] = new DsrBuffer(componentname, c, this.bufferSizePropertyString);
            this.activeBuffer = 0;
            this.passiveBuffer = (this.activeBuffer + 1) % 2;
            this.bufferArray[this.activeBuffer].refreshHour(System.currentTimeMillis());
            if (!DsrAdmin.createComponentDirectory(componentname)) {
                if (0 != this.ca.traceFlag) {
                    DsrAdmin.trace(this.componentName, "DsrBufferAdmin: DsrBufferAdmin(): DsrAdmin.createComponentDirectory() failed.");
                }
                this.componentName = null;
            }
            this.flushThread.start();
        }
        catch (Exception e) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.componentName, "DsrBufferAdmin: DsrBufferAdmin(): caught exception: " + e.getMessage());
            }
            this.componentName = null;
        }
    }

    public void run() {
        if (null == this.bufferToFlush) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.componentName, "DsrBufferAdmin: DsrBufferAdmin(): this.bufferToFlush is null");
            }
            return;
        }
        this.bufferToFlush.writeToFile();
        this.bufferToFlush.clear();
        this.isWriteLocked = false;
    }

    private boolean isOk() {
        if (null == this.componentName) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.componentName, "DsrBufferAdmin: isOk(): invalid self.");
            }
            return false;
        }
        return true;
    }

    private boolean switchBuffer(long time) {
        if (this.isWriteLocked) {
            return false;
        }
        this.bufferToFlush = this.bufferArray[this.activeBuffer];
        this.isWriteLocked = true;
        Thread t = new Thread(this);
        t.start();
        if (this.bufferArray[this.passiveBuffer].hasBufferSizeChanged(this.bufferSizePropertyString)) {
            this.bufferArray[this.passiveBuffer] = new DsrBuffer(this.componentName, this.ca, this.bufferSizePropertyString);
        }
        this.activeBuffer = this.passiveBuffer;
        this.passiveBuffer = (this.activeBuffer + 1) % 2;
        this.bufferArray[this.activeBuffer].refreshHour(time);
        return true;
    }

    protected boolean write(DsrRecordSet s) {
        if (0 != this.ca.traceFlag) {
            DsrAdmin.trace(this.componentName, "DsrBufferAdmin: write(): entered.");
        }
        if (null == s) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.componentName, "DsrBufferAdmin: write(): no record set.");
            }
            return false;
        }
        if (!this.isOk()) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.componentName, "DsrBufferAdmin: write(): invalid self.");
            }
            return false;
        }
        return this.writeSync(s, System.currentTimeMillis());
    }

    protected synchronized boolean writeSync(DsrRecordSet s, long time) {
        int recordLen;
        this.bufferJustSwaped = false;
        if (this.bufferArray[this.activeBuffer].hasCurrentHourChanged(time)) {
            if (this.isWriteLocked) {
                return false;
            }
            if (!this.switchBuffer(time)) {
                return false;
            }
            this.bufferJustSwaped = true;
        }
        if (0 >= (recordLen = s.getData(this.bufferArray[this.activeBuffer].getBuffer(), this.bufferArray[this.activeBuffer].getCurrentWritePosition()))) {
            if (this.bufferJustSwaped) {
                return false;
            }
            if (this.isWriteLocked) {
                return false;
            }
            if (!this.switchBuffer(time)) {
                return false;
            }
            recordLen = s.getData(this.bufferArray[this.activeBuffer].getBuffer(), this.bufferArray[this.activeBuffer].getCurrentWritePosition());
            if (0 >= recordLen) {
                return false;
            }
        }
        this.bufferArray[this.activeBuffer].writeTimestamp(time);
        this.bufferArray[this.activeBuffer].updateSecondIndexBuffer(time);
        this.bufferArray[this.activeBuffer].setCurrentWritePositionByIncrement(recordLen);
        this.bufferArray[this.activeBuffer].updateLastRecordTimestamp(time / 1000L);
        return true;
    }

    protected synchronized boolean flush() {
        if (0 != this.ca.traceFlag) {
            DsrAdmin.trace(this.componentName, "DsrBufferAdmin: flush(): entered.");
        }
        if (!this.isOk()) {
            return false;
        }
        if (this.isWriteLocked) {
            if (0 != this.ca.traceFlag) {
                DsrAdmin.trace(this.componentName, "DsrBufferAdmin: flush(): active buffer write locked.");
            }
            return false;
        }
        return this.switchBuffer(System.currentTimeMillis());
    }
}

