/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdsr.writer;

import com.sap.jdsr.writer.DsrComponentAdmin;
import com.sap.jdsr.writer.DsrIComponentStaticData;
import com.sap.jdsr.writer.DsrListener;
import com.sap.jdsr.writer.DsrPortUpdater;
import java.io.File;
import java.io.RandomAccessFile;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Random;
import java.util.TimeZone;

public class DsrAdmin {
    public static TimeZone timezone = TimeZone.getTimeZone("GMT");
    public static final int recordIdMain = 123454321;
    public static final int recordIdCert = 234565432;
    public static final int recordIdCall1 = 345676543;
    public static final int recordIdCall2 = 456787654;
    public static final byte fieldTypeInt32 = 0;
    public static final byte fieldTypeInt64 = 1;
    public static final byte fieldTypeString = 2;
    public static final byte fieldIdAction = 0;
    public static final byte fieldIdActionType = 1;
    public static final byte fieldIdAddInfo = 2;
    public static final byte fieldIdCpuTime = 3;
    public static final byte fieldIdGenTime = 4;
    public static final byte fieldIdLoadTime = 5;
    public static final byte fieldIdLuwInfo = 6;
    public static final byte fieldIdMaxMem = 7;
    public static final byte fieldIdNetTime = 8;
    public static final byte fieldIdQueueTime = 9;
    public static final byte fieldIdRespTime = 10;
    public static final byte fieldIdService = 11;
    public static final byte fieldIdStartTime = 12;
    public static final byte fieldIdTransId = 13;
    public static final byte fieldIdUserId = 14;
    public static final byte fieldIdWaitTime = 15;
    public static final byte fieldIdCallTime = 16;
    public static final byte fieldIdComponentName = 17;
    public static final byte fieldIdComponentType = 18;
    public static final byte fieldIdDestination = 19;
    public static final byte fieldIdNumberOfCalls = 20;
    public static final byte fieldIdReceivedBytes = 21;
    public static final byte fieldIdReceiveTime = 22;
    public static final byte fieldIdSentBytes = 23;
    public static final byte fieldIdFunctionName = 24;
    public static final byte fieldIdModuleName = 25;
    public static final byte fieldIdTraceFlag = 26;
    public static final byte fieldIdPrecComponentName = 27;
    public static final byte fieldIdStartTimeMilliSec = 28;
    public static final int lenOfFieldIdField = 1;
    public static final int lenOfFieldTypeField = 1;
    public static final int lenOfStringLenField = 2;
    public static final int lenOfInt32 = 4;
    public static final int lenOfInt64 = 8;
    public static final int lenOfRecordIdField = 4;
    public static final int lenOfRecordLenField = 2;
    public static final int lenOfEndTimeField = 8;
    public static final int lenOfEndTimeMilliSecField = 2;
    public static final int componentNameLen = 32;
    public static final int transIdLen = 32;
    public static final int actionLen = 128;
    public static final int userIdLen = 32;
    public static final int componentTypeLen = 10;
    public static final int componentVersionLen = 32;
    public static final int addInfoLen = 256;
    public static final int destinationLen = 128;
    public static final int moduleNameLen = 32;
    public static final int functionNameLen = 128;
    public static final int componentStaticDataMaxCount = 10;
    public static final int componentStaticDataLinkedSystemMaxLen = 32;
    public static final int componentStaticDataTracePathMaxLen = 512;
    public static final int componentStaticDataTraceFileMaxLen = 512;
    public static final int componentStaticDataTracePatternsMaxLen = 512;
    public static final int portFileSize = 8192;
    public static final int maxStatFileCountFallback = 48;
    public static final String dsrPathSystemProperty = "dsr.root";
    public static final String dsrMaxStatFileCountSystemProperty = "dsr.statfilelimit";
    public static final String dsrPropertyHeader = "dsr.";
    public static final String dsrVisibleOnSetStaticPropertyString = ".visibleonsetstatic";
    public static final String dsrPortFileName = "dsrports.txt";
    public static final String dsrStatFileExtention = ".txt";
    public static final String dsrJavaFileIndicator = "_java";
    public static final String dsrSecondIndexFileExtention = ".six";
    public static final String dsrTraceFileExtention = ".trc";
    public static final String dsrVersion = "2.1";
    private static long lastChangeTime = 0L;
    private static Hashtable componentList = new Hashtable(10);
    private static DsrListener dsrListener = null;
    private static DsrPortUpdater dsrPortUpdater = null;
    public static String fallbackComponentName = "fallback";
    public static Random randomSeed = new Random();
    public static int traceFlag = 0;
    private static String traceFileName = null;
    private static int traceMessageCount = 0;
    private static StringBuffer traceMessageBuffer = new StringBuffer(10000);
    private static int traceMessageMaxCountInBuffer = 10;
    private static Calendar traceCalendar = Calendar.getInstance(timezone);
    private static Date traceDate = new Date();
    private static StringBuffer getActiveBuffer = new StringBuffer(512);
    private static byte[] portfileBuffer = new byte[8192];
    private static Hashtable convertedComponentNameList = new Hashtable(10);
    private static String fullPortFileName = null;

    public static void int2TwoByte(int n, byte[] b, int offset) {
        b[offset] = (byte)(0xFF & n >> 8);
        b[offset + 1] = (byte)(n & 0xFF);
    }

    public static void int2FourByte(int n, byte[] b, int offset) {
        b[offset] = (byte)(0xFF & n >> 24);
        b[offset + 1] = (byte)(0xFF & n >> 16);
        b[offset + 2] = (byte)(0xFF & n >> 8);
        b[offset + 3] = (byte)(0xFF & n);
    }

    public static void long2EightByte(long n, byte[] b, int offset) {
        b[offset] = (byte)(0xFFL & n >> 56);
        b[offset + 1] = (byte)(0xFFL & n >> 48);
        b[offset + 2] = (byte)(0xFFL & n >> 40);
        b[offset + 3] = (byte)(0xFFL & n >> 32);
        b[offset + 4] = (byte)(0xFFL & n >> 24);
        b[offset + 5] = (byte)(0xFFL & n >> 16);
        b[offset + 6] = (byte)(0xFFL & n >> 8);
        b[offset + 7] = (byte)(n & 0xFFL);
    }

    public static int twoByte2Int(byte[] b, int offset) {
        int r1 = b[offset];
        int r2 = b[offset + 1];
        if (0 > r1) {
            r1 += 256;
        }
        if (0 > r2) {
            r2 += 256;
        }
        return r1 * 256 + r2;
    }

    public static int fourByte2Int(byte[] b, int offset) {
        int r = b[offset];
        if (0 > r) {
            r += 256;
        }
        int i = 1;
        while (i < 4) {
            int s = b[offset + i];
            if (0 > s) {
                s += 256;
            }
            r = r * 256 + s;
            ++i;
        }
        return r;
    }

    public static long eightByte2Long(byte[] b, int offset) {
        long r = b[offset];
        if (0L > r) {
            r += 256L;
        }
        int i = 1;
        while (i < 8) {
            int s = b[offset + i];
            if (0 > s) {
                s += 256;
            }
            r = r * 256L + (long)s;
            ++i;
        }
        return r;
    }

    public static String getPortfileName() {
        String s;
        if (null != fullPortFileName) {
            return fullPortFileName;
        }
        try {
            s = System.getProperty(dsrPathSystemProperty);
        }
        catch (Exception e) {
            if (0 != traceFlag) {
                DsrAdmin.trace(null, "DsrAdmin: getPortfileName(): System.getProperty(dsr.root) failed.");
            }
            return null;
        }
        StringBuffer b = new StringBuffer(512);
        b.append(s);
        if (File.separatorChar != s.charAt(s.length() - 1)) {
            b.append(File.separatorChar);
        }
        b.append(dsrPortFileName);
        fullPortFileName = b.toString();
        return fullPortFileName;
    }

    public static synchronized void writePortfile(int port) {
        block22: {
            int readBytes;
            RandomAccessFile r = null;
            String fileName = DsrAdmin.getPortfileName();
            int byteNumber = port / 8;
            int bitNumber = port % 8;
            int w = 128;
            byte[] b = portfileBuffer;
            if (null == fileName) {
                if (0 != traceFlag) {
                    DsrAdmin.trace(null, "DsrAdmin: writePortfile(): DsrAdmin.getPortfileName() failed.");
                }
                return;
            }
            if (0 != traceFlag) {
                DsrAdmin.trace(null, "DsrAdmin: writePortfile(): port: " + port);
            }
            if (8192 < byteNumber) {
                if (0 != traceFlag) {
                    DsrAdmin.trace(null, "DsrAdmin: writePortfile(): DsrAdmin.portFileSize < byteNumber: 8192 " + byteNumber);
                }
                return;
            }
            try {
                r = new RandomAccessFile(fileName, "rw");
            }
            catch (Exception e) {
                if (0 != traceFlag) {
                    DsrAdmin.trace(null, "DsrAdmin: writePortfile(): caught exception: " + e.getMessage());
                }
                return;
            }
            try {
                readBytes = r.read(b);
            }
            catch (Exception e) {
                block21: {
                    if (0 != traceFlag) {
                        DsrAdmin.trace(null, "DsrAdmin: writePortfile(): caught exception: " + e.getMessage());
                    }
                    try {
                        r.close();
                    }
                    catch (Exception f) {
                        if (0 == traceFlag) break block21;
                        DsrAdmin.trace(null, "DsrAdmin: writePortfile(): caught exception: " + f.getMessage());
                    }
                }
                return;
            }
            if (-1 == readBytes) {
                readBytes = 0;
            }
            int i = readBytes;
            while (i < 8192) {
                DsrAdmin.portfileBuffer[i] = 0;
                ++i;
            }
            i = 0;
            while (i < bitNumber) {
                w /= 2;
                ++i;
            }
            b[byteNumber] = (byte)(b[byteNumber] | w);
            try {
                r.seek(0L);
                r.write(b);
                r.close();
            }
            catch (Exception e) {
                if (0 != traceFlag) {
                    DsrAdmin.trace(null, "DsrAdmin: writePortfile(): caught exception: " + e.getMessage());
                }
                try {
                    r.close();
                }
                catch (Exception f) {
                    if (0 == traceFlag) break block22;
                    DsrAdmin.trace(null, "DsrAdmin: writePortfile(): caught exception: " + f.getMessage());
                }
            }
        }
    }

    public static synchronized void eraseFromPortfile(int port) {
        RandomAccessFile r = null;
        String fileName = DsrAdmin.getPortfileName();
        int i = 0;
        long curPos = 0L;
        long pos = 0L;
        byte[] b = (" " + Integer.toString(dsrListener.getPort()) + " ").getBytes();
        if (null == fileName) {
            if (0 != traceFlag) {
                DsrAdmin.trace(null, "DsrAdmin: eraseFromPortfile(): DsrAdmin.getPortfileName() failed.");
            }
            return;
        }
        if (0 != traceFlag) {
            DsrAdmin.trace(null, "DsrAdmin: eraseFromPortfile(): port: " + port);
        }
        if (0 > port) {
            if (0 != traceFlag) {
                DsrAdmin.trace(null, "DsrAdmin: eraseFromPortfile(): invalid port.");
            }
            return;
        }
        try {
            r = new RandomAccessFile(fileName, "rw");
            r.seek(0L);
        }
        catch (Exception e) {
            if (0 != traceFlag) {
                DsrAdmin.trace(null, "DsrAdmin: eraseFromPortfile(): caught exception: " + e.getMessage());
            }
            return;
        }
        try {
            while (true) {
                if (b[i] == r.readByte()) {
                    if (0 == i) {
                        pos = curPos;
                        ++i;
                    } else if (b.length == i + 1) {
                        r.seek(pos);
                        i = 0;
                        while (i < b.length) {
                            r.writeByte(32);
                            ++i;
                        }
                        i = 0;
                    } else {
                        ++i;
                    }
                } else {
                    i = 0;
                }
                ++curPos;
            }
        }
        catch (Exception e) {
            if (0 != traceFlag) {
                DsrAdmin.trace(null, "DsrAdmin: eraseFromPortfile(): caught exception: " + e.getMessage());
            }
            try {
                r.close();
            }
            catch (Exception e2) {
                if (0 != traceFlag) {
                    DsrAdmin.trace(null, "DsrAdmin: eraseFromPortfile(): caught exception: " + e2.getMessage());
                }
                return;
            }
            return;
        }
    }

    protected static boolean setComponentStaticData(String componentName, String convertedName, DsrIComponentStaticData statData) {
        if (null == statData) {
            if (0 != traceFlag) {
                DsrAdmin.trace(null, "DsrAdmin: setComponentStaticData(): stat data is null");
            }
            return false;
        }
        DsrComponentAdmin ca = DsrAdmin.getCreateComponentAdmin(componentName, convertedName);
        if (null == ca) {
            if (0 != traceFlag) {
                DsrAdmin.trace(null, "DsrAdmin: setComponentStaticData(): DsrAdmin.getCreateComponentAdmin(" + convertedName + ") failed.");
            }
            return false;
        }
        return ca.setComponentStaticData(statData);
    }

    protected static synchronized DsrComponentAdmin getCreateComponentAdmin(String compName, String convName) {
        DsrComponentAdmin ca = null;
        if (null == compName) {
            if (0 != traceFlag) {
                DsrAdmin.trace(null, "DsrAdmin: getCreateComponentAdmin(): component is null.");
            }
            return null;
        }
        if (null == convName) {
            if (0 != traceFlag) {
                DsrAdmin.trace(null, "DsrAdmin: getCreateComponentAdmin(): DsrAdmin.convertToValidComponentName(" + compName + ") failed.");
            }
            return null;
        }
        ca = (DsrComponentAdmin)componentList.get(convName);
        if (null == ca) {
            ca = new DsrComponentAdmin(compName, convName);
            componentList.put(convName, ca);
            DsrAdmin.setLastChangeTime();
        }
        return ca;
    }

    public static synchronized DsrComponentAdmin getComponentAdmin(String compName) {
        Object ca = null;
        if (null == compName) {
            if (0 != traceFlag) {
                DsrAdmin.trace(null, "DsrAdmin: getComponentAdmin(): component is null.");
            }
            return null;
        }
        String validCompName = DsrAdmin.convertToValidComponentName(compName);
        if (null == validCompName) {
            if (0 != traceFlag) {
                DsrAdmin.trace(null, "DsrAdmin: getComponentAdmin(): DsrAdmin.convertToValidComponentName(" + compName + ") failed.");
            }
            return null;
        }
        return (DsrComponentAdmin)componentList.get(validCompName);
    }

    public static synchronized Enumeration getAllComponentAdmin() {
        return componentList.elements();
    }

    public static synchronized String getActive() {
        Enumeration n = null;
        DsrComponentAdmin c = null;
        int i = 0;
        if (0 != getActiveBuffer.length()) {
            getActiveBuffer.delete(0, getActiveBuffer.length());
        }
        n = componentList.elements();
        while (n.hasMoreElements()) {
            c = (DsrComponentAdmin)n.nextElement();
            if (!c.isVisible()) continue;
            getActiveBuffer.append(c.getComponentName());
            getActiveBuffer.append(" ");
            ++i;
        }
        if (0 < i) {
            if (0 != traceFlag) {
                DsrAdmin.trace(null, "DsrAdmin: getActive(): returning: " + getActiveBuffer);
            }
            return getActiveBuffer.toString();
        }
        return null;
    }

    public static synchronized long getLastChangeTime() {
        if (0 != traceFlag) {
            DsrAdmin.trace(null, "DsrAdmin: getLastChangeTime(): returning: " + lastChangeTime);
        }
        return lastChangeTime;
    }

    public static String getComponentDirectory(String componentname) {
        if (null == componentname) {
            if (0 != traceFlag) {
                DsrAdmin.trace(null, "DsrAdmin: getComponentDirectory(): component is null.");
            }
            return null;
        }
        String validCompName = DsrAdmin.convertToValidComponentName(componentname);
        if (null == validCompName) {
            if (0 != traceFlag) {
                DsrAdmin.trace(null, "DsrAdmin: getComponentDirectory(): DsrAdmin.convertToValidComponentName(" + componentname + ") failed.");
            }
            return null;
        }
        try {
            String s = System.getProperty(dsrPathSystemProperty);
            StringBuffer b = new StringBuffer(512);
            b.append(s);
            if (File.separatorChar != s.charAt(s.length() - 1)) {
                b.append(File.separatorChar);
            }
            b.append(validCompName);
            b.append(dsrJavaFileIndicator);
            if (0 != traceFlag) {
                DsrAdmin.trace(null, "DsrAdmin: getComponentDirectory(): returning: " + b);
            }
            return b.toString();
        }
        catch (Exception e) {
            if (0 != traceFlag) {
                DsrAdmin.trace(null, "DsrAdmin: getComponentDirectory(): caught exception: " + e.getMessage());
            }
            return null;
        }
    }

    public static boolean createComponentDirectory(String componentname) {
        if (null == componentname) {
            if (0 != traceFlag) {
                DsrAdmin.trace(null, "DsrAdmin: createComponentDirectory(): component is null");
            }
            return false;
        }
        String validCompName = DsrAdmin.convertToValidComponentName(componentname);
        if (null == validCompName) {
            if (0 != traceFlag) {
                DsrAdmin.trace(null, "DsrAdmin: createComponentDirectory(): DsrAdmin.convertToValidComponentName(" + componentname + ") failed.");
            }
            return false;
        }
        String dirName = DsrAdmin.getComponentDirectory(validCompName);
        File dir = null;
        if (null == dirName) {
            if (0 != traceFlag) {
                DsrAdmin.trace(null, "DsrAdmin: createComponentDirectory(): DsrAdmin.getComponentDirectory(" + validCompName + ") failed.");
            }
            return false;
        }
        dir = new File(dirName);
        if (null == dir) {
            if (0 != traceFlag) {
                DsrAdmin.trace(null, "DsrAdmin: createComponentDirectory(): new File(" + dirName + ") failed.");
            }
            return false;
        }
        if (dir.isDirectory()) {
            return true;
        }
        if (dir.mkdirs()) {
            return true;
        }
        if (0 != traceFlag) {
            DsrAdmin.trace(null, "DsrAdmin: createComponentDirectory(): mkdirs() failed: " + dirName);
        }
        return false;
    }

    public static boolean createDirectory(String directory) {
        File dir = null;
        if (null == directory) {
            if (0 != traceFlag) {
                DsrAdmin.trace(null, "DsrAdmin: createDirectory(): directory is null");
            }
            return false;
        }
        dir = new File(directory);
        if (null == dir) {
            if (0 != traceFlag) {
                DsrAdmin.trace(null, "DsrAdmin: createDirectory(): new File(" + directory + ") failed.");
            }
            return false;
        }
        if (dir.isDirectory()) {
            return true;
        }
        if (dir.mkdirs()) {
            return true;
        }
        if (0 != traceFlag) {
            DsrAdmin.trace(null, "DsrAdmin: createDirectory(): mkdirs() failed: " + directory);
        }
        return false;
    }

    protected static int getStatFileMaxCount(String convertedname) {
        int mi = 48;
        if (null == convertedname) {
            if (0 != traceFlag) {
                DsrAdmin.trace(null, "DsrAdmin: getStatFileMaxCount(): component is null");
            }
            return mi;
        }
        DsrComponentAdmin ca = DsrAdmin.getComponentAdmin(convertedname);
        if (null == ca) {
            DsrAdmin.trace(null, "DsrAdmin: no componentAdmin object jet for component " + convertedname + ". Returning " + mi);
            return mi;
        }
        try {
            String m = System.getProperty("dsr.statfilelimit." + ca.getOrgComponentName());
            mi = Integer.parseInt(m);
            if (0 > mi) {
                if (0 != traceFlag) {
                    DsrAdmin.trace(null, "DsrAdmin: getStatFileMaxCount(): returning: " + mi);
                }
                return mi;
            }
            if (0 == mi) {
                if (0 != traceFlag) {
                    DsrAdmin.trace(null, "DsrAdmin: getStatFileMaxCount(): returning: 1");
                }
                return 1;
            }
        }
        catch (Exception e) {
            if (0 != traceFlag) {
                DsrAdmin.trace(null, "DsrAdmin: getStatFileMaxCount(): catched exception: " + e.getMessage());
            }
            return 48;
        }
        if (0 != traceFlag) {
            DsrAdmin.trace(null, "DsrAdmin: getStatFileMaxCount(): returning: " + mi);
        }
        return mi;
    }

    public static String convertToValidComponentName(String componentName) {
        char c;
        if (null == componentName) {
            if (0 != traceFlag) {
                DsrAdmin.trace(null, "DsrAdmin: convertToValidComponentName(): component is null.");
            }
            return null;
        }
        String trimmedName = componentName.trim();
        int l = trimmedName.length();
        if (0 >= l) {
            DsrAdmin.trace(null, "DsrAdmin: convertToValidComponentName(): component name is empty.");
            return null;
        }
        String hashedConvertedName = (String)convertedComponentNameList.get(trimmedName);
        if (null != hashedConvertedName) {
            return hashedConvertedName;
        }
        int i = 0;
        while (i < l) {
            c = trimmedName.charAt(i);
            if (!(' ' != c && ('_' == c || '.' == c || '0' <= c && '9' >= c || 'a' <= c && 'z' >= c || 'A' <= c && 'Z' >= c))) break;
            ++i;
        }
        if (i >= l) {
            if (32 < l) {
                if (0 != traceFlag) {
                    DsrAdmin.trace(null, "DsrAdmin: convertToValidComponentName(): returning: " + trimmedName.substring(0, 32));
                }
                hashedConvertedName = trimmedName.substring(0, 32);
                convertedComponentNameList.put(trimmedName, hashedConvertedName);
                return hashedConvertedName;
            }
            if (0 != traceFlag) {
                DsrAdmin.trace(null, "DsrAdmin: convertToValidComponentName(): returning: " + trimmedName);
            }
            convertedComponentNameList.put(trimmedName, trimmedName);
            return trimmedName;
        }
        StringBuffer s = new StringBuffer(128);
        i = 0;
        while (i < l) {
            c = trimmedName.charAt(i);
            if (' ' == c) {
                s.append('_');
            } else if ('_' == c) {
                s.append(c);
            } else if ('.' == c) {
                s.append(c);
            } else if (!('0' <= c && '9' >= c || 'a' <= c && 'z' >= c || 'A' <= c && 'Z' >= c)) {
                s.append((int)c);
            } else {
                s.append(c);
            }
            ++i;
        }
        l = s.length();
        if (32 < l) {
            if (0 != traceFlag) {
                DsrAdmin.trace(null, "DsrAdmin: convertToValidComponentName(): returning: " + s.substring(0, 32));
            }
            hashedConvertedName = s.substring(0, 32);
            convertedComponentNameList.put(trimmedName, hashedConvertedName);
            return hashedConvertedName;
        }
        if (0 != traceFlag) {
            DsrAdmin.trace(null, "DsrAdmin: convertToValidComponentName(): returning: " + s);
        }
        hashedConvertedName = s.toString();
        convertedComponentNameList.put(trimmedName, hashedConvertedName);
        return hashedConvertedName;
    }

    public static synchronized void setLastChangeTime() {
        lastChangeTime = System.currentTimeMillis();
    }

    public static void trace(String componentname, String s) {
        if (0 == traceFlag) {
            return;
        }
        if (null == s) {
            return;
        }
        DsrAdmin.traceIntern(componentname, s);
    }

    private static synchronized void traceIntern(String componentname, String s) {
        traceDate.setTime(System.currentTimeMillis());
        traceCalendar.setTime(traceDate);
        traceMessageBuffer.append(Thread.currentThread().getName());
        traceMessageBuffer.append(" : ");
        if (null == componentname) {
            traceMessageBuffer.append("---");
        } else {
            traceMessageBuffer.append(componentname);
        }
        traceMessageBuffer.append(" : ");
        traceMessageBuffer.append(traceCalendar.get(11));
        traceMessageBuffer.append(":");
        traceMessageBuffer.append(traceCalendar.get(12));
        traceMessageBuffer.append(":");
        traceMessageBuffer.append(traceCalendar.get(13));
        traceMessageBuffer.append(":");
        traceMessageBuffer.append(traceCalendar.get(14));
        traceMessageBuffer.append(":");
        traceMessageBuffer.append(s);
        traceMessageBuffer.append("\n");
        if (++traceMessageCount >= traceMessageMaxCountInBuffer) {
            DsrAdmin.flushTraceBuffer();
            traceMessageCount = 0;
        }
    }

    public static synchronized void setTraceFileName(String name) {
        traceFileName = name;
    }

    public static String getTraceFileName() {
        return traceFileName;
    }

    public static synchronized void setTraceMessageMaxCount(int count) {
        if (0 > count) {
            traceMessageMaxCountInBuffer = 1;
            return;
        }
        traceMessageMaxCountInBuffer = count;
    }

    public static int getTraceMessageMaxCount() {
        return traceMessageMaxCountInBuffer;
    }

    private static void flushTraceBuffer() {
        if (null != traceFileName) {
            try {
                RandomAccessFile f = new RandomAccessFile(traceFileName, "rw");
                f.seek(f.length());
                f.write(traceMessageBuffer.toString().getBytes());
                f.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (0 < traceMessageBuffer.length()) {
            traceMessageBuffer.delete(0, traceMessageBuffer.length());
        }
    }

    static {
        randomSeed.nextInt();
        Object r = null;
        String fileName = DsrAdmin.getPortfileName();
        dsrListener = new DsrListener();
        dsrListener.setName("SAPDSR_watcher");
        int p = dsrListener.getPort();
        dsrPortUpdater = new DsrPortUpdater(p);
        dsrPortUpdater.setName("SAPDSR_updater");
        dsrListener.start();
        dsrPortUpdater.start();
        if (null != fileName && 0 != p) {
            DsrAdmin.writePortfile(p);
        }
    }
}

