/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jdsr.shared;

import com.sap.jdsr.shared.DsrIInfoProvider;
import com.sap.jdsr.shared.DsrIPassportProvider;
import com.sap.jdsr.shared.ExternalPassportListener;
import java.util.HashSet;
import java.util.Set;

public class DsrRegistry {
    private static DsrIPassportProvider dsrPassportProvider = null;
    private static DsrIInfoProvider dsrInfoProvider;
    private static Set extPassportListeners;

    public static synchronized void setDsrPassportProvider(DsrIPassportProvider _passportProvider) {
        Object[] listeners = null;
        if (dsrPassportProvider != _passportProvider) {
            int i;
            if (_passportProvider != null && (listeners = extPassportListeners.toArray()) != null) {
                i = 0;
                while (i < listeners.length) {
                    _passportProvider.registerExternalPassportListener((ExternalPassportListener)listeners[i]);
                    ++i;
                }
            }
            if (dsrPassportProvider != null && (listeners = dsrPassportProvider.getExternalPassportListeners()) != null) {
                i = 0;
                while (i < listeners.length) {
                    dsrPassportProvider.deregisterExternalPassportListener((ExternalPassportListener)listeners[i]);
                    ++i;
                }
            }
        }
        dsrPassportProvider = _passportProvider;
    }

    public static DsrIPassportProvider getDsrPassportProvider() {
        return dsrPassportProvider;
    }

    public static synchronized void setDsrInfoProvider(DsrIInfoProvider _infoProvider) {
        dsrInfoProvider = _infoProvider;
    }

    public static DsrIInfoProvider getDsrInfoProvider() {
        return dsrInfoProvider;
    }

    public static void registerExternalPassportListener(ExternalPassportListener listener) {
        if (listener == null) {
            return;
        }
        extPassportListeners.add(listener);
        if (dsrPassportProvider != null) {
            dsrPassportProvider.registerExternalPassportListener(listener);
        }
    }

    public static void deregisterExternalPassportListener(ExternalPassportListener listener) {
        extPassportListeners.remove(listener);
        if (dsrPassportProvider != null) {
            dsrPassportProvider.deregisterExternalPassportListener(listener);
        }
    }

    static {
        extPassportListeners = new HashSet();
    }
}

