/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.design.copypaste;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.internal.dom.copypaste.IDesignClipboardCopy;
import com.tssap.selena.internal.dom.providers.NameUtil;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.providers.internal.design.copypaste.CompositeCommand;
import com.tssap.selena.model.providers.internal.design.copypaste.CompositePasteCommand;
import com.tssap.selena.model.providers.internal.design.copypaste.CutPasteDeltaProvider;
import com.tssap.selena.model.util.Assert;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PasteSequence
extends CompositeCommand
implements IDesignClipboardCopy {
    private boolean myWasCutted;
    private UniqueName myModelUin;
    private UniqueName myOriginalUin;
    private Entity myContainer;
    private Entity myFirstPasted;
    private HashMap myExternalSubstitutionMap = new HashMap();

    public PasteSequence(Model model, DesignElement designElement, boolean wasCutted) {
        this.myWasCutted = wasCutted;
        this.myModelUin = model.getUniqueName();
        this.myOriginalUin = NameUtil.getUniqueName((DesignElement)designElement);
        if (this.myWasCutted) {
            PasteSequence.initDeltaPatcher(this.myModelUin, this.myOriginalUin);
        }
    }

    public ModelDeltaNode asModelDeltaNode() {
        Iterator subCommands = this.subCommands();
        while (subCommands.hasNext()) {
            CompositeCommand next = (CompositeCommand)subCommands.next();
            ModelDeltaNode result = next.asModelDeltaNode();
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public UniqueName getOriginalUin() {
        return this.myOriginalUin;
    }

    public void dispose() {
    }

    public Entity pasteBaseElements(Entity parent, Map substitutionMap) {
        Assert.isLegal((substitutionMap != null ? 1 : 0) != 0);
        this.myContainer = parent;
        this.myFirstPasted = null;
        this.createSubNodes();
        this.fillSubstitutionMap(substitutionMap);
        CutPasteDeltaProvider deltaPatcher = CutPasteDeltaProvider.getInstance(this.myModelUin);
        if (deltaPatcher != null) {
            deltaPatcher.cuttedElementPasted(this);
        }
        return this.myFirstPasted;
    }

    public void pasteDerivedElements(Entity parent, Map substitutionMap) {
        this.createSubLinks(substitutionMap);
        this.restoreIncomingLinks(substitutionMap);
    }

    public void pasteTertiaryElements(Entity parent, Map substitutionMap) {
    }

    public boolean canPaste(Entity parent) {
        Iterator subCommands = this.subCommands();
        while (subCommands.hasNext()) {
            CompositePasteCommand next = (CompositePasteCommand)subCommands.next();
            if (next.canPaste(parent)) continue;
            return false;
        }
        return true;
    }

    public Entity paste(final Entity container) {
        ModelAccess.runCommand((Runnable)new Runnable(){

            public void run() {
                HashMap substitution = new HashMap(PasteSequence.this.myExternalSubstitutionMap);
                PasteSequence.this.pasteBaseElements(container, substitution);
                PasteSequence.this.pasteDerivedElements(container, substitution);
                PasteSequence.this.pasteTertiaryElements(container, substitution);
            }
        }, (String)"Pasting...");
        return this.myFirstPasted;
    }

    private void fillSubstitutionMap(Map result) {
        Iterator subCommands = this.subCommands();
        while (subCommands.hasNext()) {
            CompositePasteCommand next = (CompositePasteCommand)subCommands.next();
            next.fillSubstitutionMap(result);
        }
    }

    private void createSubNodes() {
        Iterator subCommands = this.subCommands();
        while (subCommands.hasNext()) {
            CompositePasteCommand next = (CompositePasteCommand)subCommands.next();
            next.pasteChildNodes(this.myContainer);
            if (this.myFirstPasted != null) continue;
            this.myFirstPasted = next.getResult();
        }
    }

    private void createSubLinks(Map substitutionMap) {
        Iterator subCommands = this.subCommands();
        while (subCommands.hasNext()) {
            CompositePasteCommand next = (CompositePasteCommand)subCommands.next();
            next.pasteChildLinks(this.myContainer, substitutionMap);
            if (this.myFirstPasted != null) continue;
            this.myFirstPasted = next.getResult();
        }
    }

    private void restoreIncomingLinks(Map substitutionMap) {
        Iterator subCommands = this.subCommands();
        while (subCommands.hasNext()) {
            CompositePasteCommand next = (CompositePasteCommand)subCommands.next();
            next.restoreIncomingLinks(substitutionMap);
        }
    }

    private static void initDeltaPatcher(UniqueName modelUin, UniqueName designElementUin) {
        CutPasteDeltaProvider deltaPatcher = CutPasteDeltaProvider.getInstance(modelUin);
        if (deltaPatcher != null) {
            deltaPatcher.elementAboutToBeCutted(designElementUin);
        }
    }
}

