/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.design.copypaste;

import com.tssap.selena.impl.model.enum.CompositeEnumeration;
import com.tssap.selena.internal.dom.providers.AbstractDesignProvider;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.DeltaTreeProvider;
import com.tssap.selena.model.providers.internal.design.copypaste.PasteSequence;
import com.tssap.selena.model.util.delta.DefaultModelDeltaNode;
import com.tssap.selena.model.util.delta.ModelDeltaNodeKind;
import com.tssap.selena.model.util.delta.RootModelDeltaNode;
import com.tssap.selena.model.util.delta.TreeModelDeltaNode;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;

public class CutPasteDeltaProvider
extends AbstractDesignProvider
implements DeltaTreeProvider {
    private RootDeltaNode myRootDelta;
    private HashMap myConnectionDeltas;
    private static HashMap ourInstances = new HashMap();

    public static CutPasteDeltaProvider getInstance(UniqueName modelUin) {
        return (CutPasteDeltaProvider)((Object)ourInstances.get(modelUin));
    }

    public void registered(Model model) {
        super.registered(model);
        ourInstances.put(model.getUniqueName(), this);
    }

    public void unregistered(Model model) {
        ourInstances.remove(model.getUniqueName());
        super.unregistered(model);
    }

    public void elementAboutToBeCutted(UniqueName designElementUin) {
        this.initRootDelta();
        Entity entityToCut = this.getModel().findEntity(designElementUin);
        if (entityToCut == null || entityToCut.isDeleted()) {
            return;
        }
        Entity notChangedParent = entityToCut.getParent();
        if (notChangedParent == null || notChangedParent.isDeleted()) {
            System.err.println("Element without parent: " + designElementUin);
            return;
        }
        ICutParentDelta parentDelta = this.createConnectToParentDelta(notChangedParent);
        this.myConnectionDeltas.put(designElementUin, parentDelta);
    }

    private ICutParentDelta createConnectToParentDelta(Entity notChangedParent) {
        if (notChangedParent instanceof Model) {
            return this.myRootDelta;
        }
        return (ICutParentDelta)this.myRootDelta.addDeltaNode((TreeModelDeltaNode)new ConnectToParentDeltaNode(this.getModel(), notChangedParent.getUniqueName()));
    }

    private static ConnectToParentDeltaNode findDelta(UniqueName uin) {
        return null;
    }

    public void cuttedElementPasted(PasteSequence pasteSequence) {
        if (this.myRootDelta == null) {
            return;
        }
        ICutParentDelta parentDelta = (ICutParentDelta)this.myConnectionDeltas.get(pasteSequence.getOriginalUin());
        if (parentDelta != null) {
            parentDelta.elementCutted(pasteSequence);
            this.getModel().getExtensionManager().modelContentsChanged();
        }
    }

    public ModelDeltaNode getModelChanges() {
        if (this.myRootDelta == null) {
            return null;
        }
        RootDeltaNode result = this.myRootDelta;
        this.myConnectionDeltas = null;
        this.myRootDelta = null;
        return result;
    }

    private RootDeltaNode initRootDelta() {
        if (this.myRootDelta == null) {
            this.myRootDelta = new RootDeltaNode(this.getModel());
            this.myConnectionDeltas = new HashMap();
        }
        return this.myRootDelta;
    }

    private Model getModel() {
        return ModelAccess.getModel((UniqueName)this.getModelUin());
    }

    private static class RootDeltaNode
    extends RootModelDeltaNode
    implements ICutParentDelta {
        private LinkedList myMovedDeltas;

        public RootDeltaNode(Model model) {
            super(model);
        }

        public void elementCutted(PasteSequence sequence) {
            ModelDeltaNode subDelta = sequence.asModelDeltaNode();
            if (subDelta == null) {
                return;
            }
            if (this.myMovedDeltas == null) {
                this.myMovedDeltas = new LinkedList();
            }
            this.myMovedDeltas.add(subDelta);
        }

        public Enumeration changedChildren() {
            Enumeration common = super.changedChildren();
            if (this.myMovedDeltas == null) {
                return common;
            }
            CompositeEnumeration result = new CompositeEnumeration();
            result.add(common);
            result.add(Collections.enumeration(this.myMovedDeltas));
            return result;
        }
    }

    private static class ConnectToParentDeltaNode
    extends DefaultModelDeltaNode
    implements ICutParentDelta {
        private LinkedList myMovedDeltas;

        public ConnectToParentDeltaNode(Model model, UniqueName parentUin) {
            super(model, parentUin, ModelDeltaNodeKind.UNKNOWN);
        }

        public void elementCutted(PasteSequence sequence) {
            ModelDeltaNode subDelta = sequence.asModelDeltaNode();
            if (subDelta == null) {
                return;
            }
            if (this.myMovedDeltas == null) {
                this.myMovedDeltas = new LinkedList();
            }
            this.myMovedDeltas.add(subDelta);
        }

        public Enumeration changedChildren() {
            Enumeration common = super.changedChildren();
            if (this.myMovedDeltas == null) {
                return common;
            }
            CompositeEnumeration result = new CompositeEnumeration();
            result.add(common);
            result.add(Collections.enumeration(this.myMovedDeltas));
            return result;
        }
    }

    private static interface ICutParentDelta
    extends ModelDeltaNode {
        public void elementCutted(PasteSequence var1);
    }
}

