/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.design.copypaste;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignLink;
import com.tssap.selena.internal.dom.providers.NameUtil;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.providers.internal.design.copypaste.CompositePasteCommand;
import com.tssap.selena.model.providers.internal.design.copypaste.RestoreIncomingLinkCommand;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class CreateChildNodeCommand
extends CompositePasteCommand {
    private Entity myPastedResult = null;
    private RestoreIncomingLinkCommand[] myRestoreIncomingLinkCommands;
    private static final RestoreIncomingLinkCommand[] NO_RESTORE = new RestoreIncomingLinkCommand[0];

    public CreateChildNodeCommand(UniqueName originalUin, String metaclass, Entity template, DesignLink[] incomingLinks) {
        super(originalUin, metaclass, template);
        this.initLinksToRestore(template.getModel(), incomingLinks);
    }

    public void fillSubstitutionMap(Map result) {
        if (this.myPastedResult != null) {
            result.put(this.getOriginalUin(), this.myPastedResult);
        }
        Iterator subCommands = this.subCommands();
        while (subCommands.hasNext()) {
            CompositePasteCommand next = (CompositePasteCommand)subCommands.next();
            next.fillSubstitutionMap(result);
        }
    }

    public void pasteChildLinks(Entity parent, Map substitutionMap) {
        if (this.myPastedResult == null) {
            return;
        }
        Iterator subCommands = this.subCommands();
        while (subCommands.hasNext()) {
            CompositePasteCommand next = (CompositePasteCommand)subCommands.next();
            next.pasteChildLinks(this.myPastedResult, substitutionMap);
        }
    }

    public void pasteChildNodes(Entity curParent) {
        this.myPastedResult = curParent.createChildEntity(this.getMetaclass(), this.getTemplate());
        if (this.myPastedResult != null) {
            Iterator subCommands = this.subCommands();
            while (subCommands.hasNext()) {
                CompositePasteCommand next = (CompositePasteCommand)subCommands.next();
                next.pasteChildNodes(this.myPastedResult);
            }
        }
    }

    public void restoreIncomingLinks(Map substitutionMap) {
        this.primRestoreIncomingLinks(substitutionMap);
        if (this.myPastedResult != null) {
            Iterator subCommands = this.subCommands();
            while (subCommands.hasNext()) {
                CompositePasteCommand next = (CompositePasteCommand)subCommands.next();
                next.restoreIncomingLinks(substitutionMap);
            }
        }
    }

    private void primRestoreIncomingLinks(Map substitutionMap) {
        if (this.myRestoreIncomingLinkCommands.length == 0 || this.myPastedResult == null) {
            return;
        }
        Model model = this.myPastedResult.getModel();
        int i = 0;
        while (i < this.myRestoreIncomingLinkCommands.length) {
            RestoreIncomingLinkCommand curRestoreCommand = this.myRestoreIncomingLinkCommands[i];
            if (!substitutionMap.containsKey(curRestoreCommand.getLinkUin())) {
                Entity oldLink;
                UniqueName parentUin = curRestoreCommand.getParentUin();
                if (substitutionMap.containsKey(parentUin)) {
                    parentUin = ((Entity)substitutionMap.get(parentUin)).getUniqueName();
                }
                if ((oldLink = model.findEntity(curRestoreCommand.getLinkUin())) == null || oldLink.isDeleted()) {
                    Entity oldLinkSource = model.findEntity(parentUin);
                    curRestoreCommand.substituteTargets(curRestoreCommand.getTemplate(), Collections.singletonMap(this.getOriginalUin(), this.myPastedResult));
                    if (oldLinkSource != null && curRestoreCommand.canPaste(oldLinkSource)) {
                        curRestoreCommand.pasteChildLinks(oldLinkSource, Collections.singletonMap(this.getOriginalUin(), this.myPastedResult));
                    }
                }
            }
            ++i;
        }
        this.myRestoreIncomingLinkCommands = NO_RESTORE;
    }

    private void initLinksToRestore(Model model, DesignLink[] links) {
        this.myRestoreIncomingLinkCommands = links.length == 0 ? NO_RESTORE : new RestoreIncomingLinkCommand[links.length];
        int i = 0;
        while (i < links.length) {
            DesignLink curLink = links[i];
            UniqueName parentUin = NameUtil.getUniqueName((DesignElement)((DesignElement)curLink.getParent()));
            this.myRestoreIncomingLinkCommands[i] = new RestoreIncomingLinkCommand(model, curLink);
            ++i;
        }
    }

    public Entity getResult() {
        return this.myPastedResult;
    }
}

