/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.design.copypaste;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignProperty;
import com.tssap.selena.model.providers.design.DesignPlugin;
import com.tssap.selena.model.providers.design.copy.CompositeCopyExtender;
import com.tssap.selena.model.providers.design.copy.DefaultCopyExtenderFactory;
import com.tssap.selena.model.providers.design.copy.IDesignCopyExtender;
import com.tssap.selena.model.providers.design.copy.IDesignCopyExtenderFactory;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;

public class CopyCutExtenderRegistry {
    public static final String EXT_POINT_COPY_EXTENDER_FACTORIES = "copyExtenderFactories";
    public static final String ATTR_METACLASS = "metaclass";
    public static final String ATTR_CLASS = "class";
    private static CopyCutExtenderRegistry ourInstance;
    private HashMap myExtenderFactoriesMap = new HashMap();

    private CopyCutExtenderRegistry() {
        this.initUserFactories();
    }

    public static CopyCutExtenderRegistry getInstance() {
        if (ourInstance == null) {
            ourInstance = new CopyCutExtenderRegistry();
        }
        return ourInstance;
    }

    public IDesignCopyExtender createExtension(DesignElement element) {
        String metaclass = CopyCutExtenderRegistry.getMetaclass(element);
        LinkedList allFactories = (LinkedList)this.myExtenderFactoriesMap.get(metaclass);
        if (allFactories == null || allFactories.isEmpty()) {
            return null;
        }
        if (allFactories.size() == 1) {
            IDesignCopyExtenderFactory factory = (IDesignCopyExtenderFactory)allFactories.getFirst();
            return factory.createExtender(element);
        }
        CompositeCopyExtender result = new CompositeCopyExtender();
        Iterator factories = allFactories.iterator();
        while (factories.hasNext()) {
            IDesignCopyExtenderFactory nextFactory = (IDesignCopyExtenderFactory)factories.next();
            result.addExtender(nextFactory.createExtender(element));
        }
        return result;
    }

    private void initUserFactories() {
        IExtensionPoint point = DesignPlugin.getDefault().getDescriptor().getExtensionPoint(EXT_POINT_COPY_EXTENDER_FACTORIES);
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                block9: {
                    IConfigurationElement element = elements[j];
                    String metaclass = element.getAttribute(ATTR_METACLASS);
                    if (metaclass != null) {
                        IDesignCopyExtenderFactory factory = null;
                        try {
                            if (element.getAttribute(ATTR_CLASS) == null) {
                                DefaultCopyExtenderFactory defaultFactory = new DefaultCopyExtenderFactory();
                                defaultFactory.setInitializationData(element, null, null);
                                factory = defaultFactory;
                            } else {
                                factory = (IDesignCopyExtenderFactory)element.createExecutableExtension(ATTR_CLASS);
                            }
                        }
                        catch (Exception e) {
                            System.err.println("Can not instantiate design extender factory for metaclass: " + metaclass + " :" + element.getAttribute(ATTR_CLASS) + " \n exception occured: " + e);
                            break block9;
                        }
                        catch (NoClassDefFoundError e) {
                            System.err.println("Can not instantiate design extender factory for metaclass: " + metaclass + " :" + element.getAttribute(ATTR_CLASS) + " \n exception occured: " + e);
                            break block9;
                        }
                        if (factory != null) {
                            this.addFactory(metaclass, factory);
                        }
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    private void addFactory(String metaclass, IDesignCopyExtenderFactory newFactory) {
        LinkedList<IDesignCopyExtenderFactory> registeredFactories = (LinkedList<IDesignCopyExtenderFactory>)this.myExtenderFactoriesMap.get(metaclass);
        if (registeredFactories == null) {
            registeredFactories = new LinkedList<IDesignCopyExtenderFactory>();
            this.myExtenderFactoriesMap.put(metaclass, registeredFactories);
        }
        registeredFactories.add(newFactory);
    }

    private static String getMetaclass(DesignElement notion) {
        DesignProperty[] metaclasses = notion.getProperties("$metaclass");
        if (metaclasses.length != 1) {
            throw new IllegalStateException("design element must have exactly one property METACLASS");
        }
        return metaclasses[0].getValue();
    }
}

