/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.design.copypaste;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignLink;
import com.tssap.selena.dom.DesignNode;
import com.tssap.selena.dom.DesignNotion;
import com.tssap.selena.dom.DesignParticipant;
import com.tssap.selena.dom.DesignProperty;
import com.tssap.selena.dom.DesignReference;
import com.tssap.selena.dom.DesignView;
import com.tssap.selena.dom.IDesignVisitor;
import com.tssap.selena.dom.nodeset.DesignNodeSet;
import com.tssap.selena.dom.nodeset.NodeSetCache;
import com.tssap.selena.internal.dom.DOMPlugin;
import com.tssap.selena.internal.dom.providers.NameUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.providers.design.copy.IDesignCopyExtender;
import com.tssap.selena.model.providers.internal.design.copypaste.CompositeCommand;
import com.tssap.selena.model.providers.internal.design.copypaste.CopyCutExtenderRegistry;
import com.tssap.selena.model.providers.internal.design.copypaste.CreateChildLinkCommand;
import com.tssap.selena.model.providers.internal.design.copypaste.CreateChildNodeCommand;
import com.tssap.selena.model.providers.internal.design.copypaste.ExtenderPasteCommand;
import com.tssap.selena.model.providers.internal.design.copypaste.PasteSequence;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;

public class ClipboardCopyCreator
implements IDesignVisitor {
    private static final DesignLink[] NO_LINKS = new DesignLink[0];
    private DesignElement myElement;
    private PasteSequence myPasteSequence;
    private CompositeCommand myCurrentCommand;
    private Model myModel;
    private boolean myShouldRestoreIncomingLinks;

    public ClipboardCopyCreator(Model model, DesignElement element, boolean restoreIncomingLinks) {
        this.myElement = element;
        this.myModel = model;
        this.myShouldRestoreIncomingLinks = restoreIncomingLinks;
    }

    private NodeSetCache getCache() {
        return NodeSetCache.getCache((UniqueName)this.myModel.getUniqueName());
    }

    public PasteSequence serialize() throws CoreException {
        this.myPasteSequence = new PasteSequence(this.myModel, this.myElement, this.myShouldRestoreIncomingLinks);
        this.myCurrentCommand = this.myPasteSequence;
        try {
            this.myElement.accept((IDesignVisitor)this);
            return this.myPasteSequence;
        }
        catch (Exception e) {
            e.printStackTrace();
            DOMPlugin.getDefault().propagateException(e);
            return null;
        }
    }

    public boolean visitNodeSet(DesignNodeSet nodeSet) throws Exception {
        throw new RuntimeException("ClipboardCopyCreator::visitNodeSet -- should never be called");
    }

    public boolean visitLink(DesignLink link) throws Exception {
        if (!this.isCopyAllowed((DesignNotion)link)) {
            return false;
        }
        Entity linkTemplate = ClipboardCopyCreator.copyLinkToTemplate(this.myModel, link);
        CreateChildLinkCommand creationCommand = new CreateChildLinkCommand(NameUtil.getUniqueName((DesignElement)link), ClipboardCopyCreator.getMetaclass((DesignNotion)link), linkTemplate);
        this.myCurrentCommand.addCommand(creationCommand);
        return false;
    }

    static String getMetaclass(DesignNotion notion) {
        DesignProperty[] metaclasses = notion.getProperties("$metaclass");
        if (metaclasses.length != 1) {
            throw new IllegalStateException("design element must have exactly one property METACLASS");
        }
        return metaclasses[0].getValue();
    }

    public boolean visitNode(DesignNode node) throws Exception {
        if (!this.isCopyAllowed((DesignNotion)node)) {
            return false;
        }
        UniqueName originalUin = NameUtil.getUniqueName((DesignElement)node);
        Entity nodeTemplate = this.myModel.createEntityTemplate();
        ClipboardCopyCreator.processProperties((PropertyMap)nodeTemplate, (DesignNotion)node);
        DesignLink[] linksToRestore = this.getIncomingLinksToRestore(node);
        CreateChildNodeCommand creationCommand = new CreateChildNodeCommand(originalUin, ClipboardCopyCreator.getMetaclass((DesignNotion)node), nodeTemplate, linksToRestore);
        IDesignCopyExtender extender = CopyCutExtenderRegistry.getInstance().createExtension((DesignElement)node);
        if (extender != null) {
            extender.createCopyExtension(this.getCache(), (DesignElement)node, this.myShouldRestoreIncomingLinks);
            creationCommand.addCommand(new ExtenderPasteCommand(originalUin, extender));
        }
        CompositeCommand oldCurrentCommand = this.myCurrentCommand;
        this.myCurrentCommand = creationCommand;
        Iterator subnotions = node.getChildNotions().iterator();
        while (subnotions.hasNext()) {
            DesignNotion cur = (DesignNotion)subnotions.next();
            cur.accept((IDesignVisitor)this);
        }
        oldCurrentCommand.addCommand(this.myCurrentCommand);
        this.myCurrentCommand = oldCurrentCommand;
        return false;
    }

    public boolean visitView(DesignView view) throws Exception {
        return false;
    }

    public boolean visitParticipant(DesignParticipant participant) throws Exception {
        return false;
    }

    public boolean visitReference(DesignReference reference) throws Exception {
        throw new IllegalStateException("should be unreachable");
    }

    private static void processProperties(PropertyMap template, DesignNotion notion) {
        DesignProperty[] properties = notion.getProperties();
        int i = 0;
        while (i < properties.length) {
            DesignProperty curProperty = properties[i];
            String curName = curProperty.getName();
            String curValue = curProperty.getValue();
            if (!"$metaclass".equals(curName)) {
                if (!template.hasProperty(curName)) {
                    template.setPropertyValue(curName, curValue);
                } else if (!template.hasPropertyValue(curName, curValue)) {
                    template.addProperty(curName, curValue);
                }
            }
            ++i;
        }
    }

    private static void processTargetParticipant(Model model, Entity template, DesignLink link) {
        Entity modelTarget;
        DesignParticipant designTarget = link.getTarget();
        if (designTarget != null && (modelTarget = model.findEntity(ModelAccess.createUniqueName((String)designTarget.getProxyId()))) != null) {
            template.setParticipant((Element)modelTarget, null, designTarget.getRole());
        }
    }

    static Entity copyLinkToTemplate(Model model, DesignLink link) {
        Entity linkTemplate = model.createEntityTemplate();
        ClipboardCopyCreator.processProperties((PropertyMap)linkTemplate, (DesignNotion)link);
        ClipboardCopyCreator.processTargetParticipant(model, linkTemplate, link);
        return linkTemplate;
    }

    private DesignLink[] getIncomingLinksToRestore(DesignNode node) {
        return this.myShouldRestoreIncomingLinks ? this.getCache().getIndexer().findIncomingLink((DesignElement)node) : NO_LINKS;
    }

    private boolean isCopyAllowed(DesignNotion notion) {
        if (notion == this.myElement) {
            return true;
        }
        String metaclass = ClipboardCopyCreator.getMetaclass(notion);
        return !"Messages Link".equals(metaclass);
    }
}

