/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.design;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignLink;
import com.tssap.selena.dom.DesignNode;
import com.tssap.selena.dom.DesignNotion;
import com.tssap.selena.dom.DesignProperty;
import com.tssap.selena.dom.nodeset.DesignNodeSet;
import com.tssap.selena.internal.dom.providers.AbstractDesignExistenceProvider;
import com.tssap.selena.internal.dom.providers.NameUtil;
import com.tssap.selena.internal.dom.providers.UniqueNameUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.ElementEnumeration;
import com.tssap.selena.model.enum.EntityEnumeration;
import com.tssap.selena.model.extension.EntityExistenceProvider;
import com.tssap.selena.model.providers.internal.design.MetaclassUtil;
import org.eclipse.core.resources.IContainer;

public class NodeProvider
extends AbstractDesignExistenceProvider
implements EntityExistenceProvider {
    public boolean exists(UniqueName uniqueName) {
        DesignElement element = this.getDesignElement(uniqueName);
        return element instanceof DesignNode || element instanceof DesignLink;
    }

    public boolean isDeleteProviderApplicable(Element element) {
        return super.isDeleteProviderApplicable(element) && (NameUtil.isDesignLinkUin((UniqueName)element.getUniqueName()) || NameUtil.isDesignNodeUin((UniqueName)element.getUniqueName()));
    }

    public boolean canCreateUniqueName(Entity parent, String shapeType, Entity template) {
        ElementEnumeration targetsFromTemplate;
        if (parent instanceof Model || parent.hasPropertyValue("$metaclass", "Package")) {
            return MetaclassUtil.isNode(shapeType) && MetaclassUtil.canHaveChildNode("Package", shapeType) && this.canCreateTopLevelNode(parent, shapeType, template);
        }
        String parentMetaclass = parent.getPropertyValue("$metaclass");
        if (!MetaclassUtil.canHaveChild(parentMetaclass, shapeType)) {
            return false;
        }
        DesignElement designParent = this.getDesignElement(parent.getUniqueName());
        if (!(designParent instanceof DesignNode) || this.isReadOnly((DesignNotion)designParent)) {
            return false;
        }
        if (template != null && MetaclassUtil.isLink(shapeType) && (targetsFromTemplate = template.participants("Supplier")).hasMoreElements()) {
            Element target = targetsFromTemplate.next();
            String targetMetaclass = target.getPropertyValue("$metaclass");
            if (targetMetaclass == null) {
                return false;
            }
            if (!MetaclassUtil.isValidParticipant(shapeType, designParent, "Supplier", target)) {
                return false;
            }
            if (MetaclassUtil.shouldReuseExistLink(shapeType, parentMetaclass, targetMetaclass)) {
                Entity[] linkToReuse = NodeProvider.findLinkToReuse(parent, shapeType, targetMetaclass);
                return linkToReuse == null || linkToReuse[0].canSetParticipant("Supplier", (Element)linkToReuse[1], target);
            }
        }
        return !"History".equals(shapeType) || !this.hasChild((DesignNode)designParent, shapeType);
    }

    private boolean hasChild(DesignNode element, String childMetaclass) {
        DesignElement[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            DesignElement child = children[i];
            DesignProperty[] properties = child.getProperties("$metaclass");
            if (properties.length > 0 && childMetaclass.equals(properties[0].getValue())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public UniqueName createUniqueName(Entity parent, String shapeType, Entity template) {
        Entity[] linkToReuse;
        Element target;
        String targetMetaclass;
        if (template == null || template.hasProperty("$nametemplate")) {
            if (template == null) {
                template = ModelAccess.getModel((UniqueName)this.getModelUin()).createEntityTemplate();
            }
            template = NameUtil.addNewNameToTemplate((Entity)parent, (String)shapeType, (Entity)template);
        } else if (!template.hasProperty("$name")) {
            template = NameUtil.addNewNameToTemplate((Entity)parent, (String)shapeType, (Entity)template);
        }
        if (parent instanceof Model || parent.hasPropertyValue("$metaclass", "Package")) {
            return this.createTopLevelNode(parent, shapeType, template);
        }
        DesignNode parentNode = (DesignNode)this.getDesignElement(parent.getUniqueName());
        if (MetaclassUtil.isNode(shapeType)) {
            return this.createSubNode(parentNode, shapeType, template);
        }
        String parentMetaclass = parent.getPropertyValue("$metaclass");
        if (template.participants("Supplier").hasMoreElements() && MetaclassUtil.shouldReuseExistLink(shapeType, parentMetaclass, targetMetaclass = (target = template.participants("Supplier").next()).getPropertyValue("$metaclass")) && (linkToReuse = NodeProvider.findLinkToReuse(parent, shapeType, targetMetaclass)) != null) {
            linkToReuse[0].setParticipant("Supplier", (Element)linkToReuse[1], target);
            return null;
        }
        return this.createSubLink(parentNode, shapeType, template);
    }

    private boolean canCreateTopLevelNode(Entity parent, String metaclass, Entity template) {
        IContainer folder = this.getFolder(parent.getPropertyValue("$diagram_folder"));
        return folder != null && this.getCache().getNamingStrategy().checkNodeSetForCreateChild(parent, folder, metaclass);
    }

    private UniqueName createTopLevelNode(Entity parent, final String metaclass, final Entity template) {
        final String newId = this.getNewId(metaclass, true);
        IContainer folder = this.getFolder(parent.getPropertyValue("$diagram_folder"));
        final DesignNodeSet newNodeSet = this.getCache().getNamingStrategy().getNodeSetForCreateChild(parent, folder, metaclass);
        final DesignElement[] createdElement = new DesignElement[1];
        newNodeSet.runCommand(new Runnable(){

            public void run() {
                createdElement[0] = newNodeSet.createChildNode(newId);
                UniqueNameUtil.setCreatedElementProperties((DesignElement)createdElement[0], (String)metaclass, (Entity)template);
            }
        });
        return NameUtil.getUniqueName((DesignElement)createdElement[0]);
    }

    public UniqueName createSubNode(final DesignNode parent, final String metaclass, final Entity template) {
        final String newId = this.getNewId(metaclass, true);
        final DesignElement[] createdElement = new DesignElement[1];
        parent.runCommand(new Runnable(){

            public void run() {
                createdElement[0] = parent.createChildNode(newId, metaclass);
                UniqueNameUtil.setCreatedElementProperties((DesignElement)createdElement[0], (String)metaclass, (Entity)template);
            }
        });
        return NameUtil.getUniqueName((DesignElement)createdElement[0]);
    }

    public UniqueName createSubLink(final DesignNode parent, final String metaclass, final Entity template) {
        final String newId = this.getNewId(metaclass, false);
        final DesignLink[] createdElement = new DesignLink[1];
        parent.runCommand(new Runnable(){

            public void run() {
                createdElement[0] = parent.createChildLink(newId);
                UniqueNameUtil.setCreatedElementProperties((DesignElement)createdElement[0], (String)metaclass, (Entity)template);
                createdElement[0].createSource(NameUtil.getUniqueName((DesignElement)parent).toString());
                UniqueNameUtil.setParticipantsFromTemplate((DesignElement)createdElement[0], (Entity)template);
            }
        });
        return NameUtil.getUniqueName((DesignElement)createdElement[0]);
    }

    private String getNewId(String shapeType, boolean isNode) {
        return (isNode ? "N" : "L") + NameUtil.newDesignId((String)shapeType);
    }

    private static Entity[] findLinkToReuse(Entity parent, String linkMetaclass, String targetMetaclass) {
        EntityEnumeration children = parent.childEntities();
        while (children.hasMoreElements()) {
            Entity nextLink = children.next();
            if (!linkMetaclass.equals(nextLink.getPropertyValue("$metaclass"))) continue;
            ElementEnumeration targets = nextLink.participants("Supplier");
            while (targets.hasMoreElements()) {
                Entity nextTarget = (Entity)targets.next();
                if (!targetMetaclass.equals(nextTarget.getPropertyValue("$metaclass"))) continue;
                return new Entity[]{nextLink, nextTarget};
            }
        }
        return null;
    }
}

