/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.design;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignProperty;
import com.tssap.selena.internal.dom.providers.NameUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.util.various.Metaclass;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class MetaclassUtil
implements Metaclass {
    private static final String ANY_ALLOWED = "*";
    private static final HashMap NODES = new HashMap();
    private static final HashMap LINKS = new HashMap();
    private static final Collection NONE = Collections.EMPTY_SET;

    public static boolean isValidParticipant(String linkMetaclass, DesignElement parent, String role, Element participant) {
        if (parent == null || linkMetaclass == null) {
            return false;
        }
        if (participant.getUniqueName() == null) {
            return false;
        }
        UniqueName parentUin = NameUtil.getUniqueName((DesignElement)parent);
        if ("Client".equals(role)) {
            return participant.getUniqueName().equals(parentUin);
        }
        if ("Supplier".equals(role)) {
            String sourceMetaclass = MetaclassUtil.getMetaclass(parent);
            if (linkMetaclass == null || sourceMetaclass == null) {
                return false;
            }
            if (participant.getUniqueName().equals(parentUin)) {
                return MetaclassUtil.canHaveSelfTarget(linkMetaclass, sourceMetaclass);
            }
            String targetMetaclass = participant.getPropertyValue("$metaclass");
            if (targetMetaclass == null) {
                return false;
            }
            return MetaclassUtil.canHaveTarget(linkMetaclass, sourceMetaclass, targetMetaclass);
        }
        return false;
    }

    public static String getMetaclass(DesignElement designElement) {
        DesignProperty[] metaclasses = designElement.getProperties("$metaclass");
        if (metaclasses == null || metaclasses.length == 0) {
            return null;
        }
        return metaclasses[0].getValue();
    }

    public static boolean canHaveChildNode(String parentMetaclass, String childMetaclass) {
        Collection allowedChildren = (Collection)NODES.get(parentMetaclass);
        return allowedChildren != null && allowedChildren.contains(childMetaclass);
    }

    public static Collection getAllowedChildNodesMetaclasses(String parentMetaclass) {
        Collection allowedChildren = (Collection)NODES.get(parentMetaclass);
        return allowedChildren == null ? Collections.EMPTY_LIST : allowedChildren;
    }

    public static boolean canHaveChildLink(String parentMetaclass, String linkMetaclass) {
        Collection linkInfos = (Collection)LINKS.get(linkMetaclass);
        if (linkInfos == null) {
            return false;
        }
        Iterator it = linkInfos.iterator();
        while (it.hasNext()) {
            LinkInfo info = (LinkInfo)it.next();
            if (!info.isSourceAllowed(parentMetaclass)) continue;
            return true;
        }
        return false;
    }

    public static boolean canHaveTarget(String linkMetaclass, String sourceMetaclass, String targetMetaclass) {
        return MetaclassUtil.getMatchedLinkInfo(linkMetaclass, sourceMetaclass, targetMetaclass) != null;
    }

    public static boolean shouldReuseExistLink(String linkMetaclass, String sourceMetaclass, String targetMetaclass) {
        LinkInfo info = MetaclassUtil.getMatchedLinkInfo(linkMetaclass, sourceMetaclass, targetMetaclass);
        return info != null && info.shouldReuseExistLink();
    }

    private static LinkInfo getMatchedLinkInfo(String linkMetaclass, String sourceMetaclass, String targetMetaclass) {
        Collection linkInfos = (Collection)LINKS.get(linkMetaclass);
        if (linkInfos == null) {
            return null;
        }
        Iterator it = linkInfos.iterator();
        while (it.hasNext()) {
            LinkInfo info = (LinkInfo)it.next();
            if (!info.isSourceAllowed(sourceMetaclass) || !info.isTargetAllowed(targetMetaclass)) continue;
            return info;
        }
        return null;
    }

    public static boolean canHaveSelfTarget(String linkMetaclass, String metaclass) {
        Collection linkInfos = (Collection)LINKS.get(linkMetaclass);
        if (linkInfos == null) {
            return false;
        }
        Iterator it = linkInfos.iterator();
        while (it.hasNext()) {
            LinkInfo info = (LinkInfo)it.next();
            if (!info.isSourceAllowed(metaclass) || !info.isTargetAllowed(metaclass) || !info.doesAllowSelf()) continue;
            return true;
        }
        return false;
    }

    public static boolean canHaveChild(String parentMetaclass, String childMetaclass) {
        return MetaclassUtil.canHaveChildNode(parentMetaclass, childMetaclass) || MetaclassUtil.canHaveChildLink(parentMetaclass, childMetaclass);
    }

    public static boolean isNode(String metaclass) {
        return NODES.containsKey(metaclass);
    }

    public static boolean isLink(String metaclass) {
        return LINKS.containsKey(metaclass);
    }

    public static void addChildren(String metaclass, Collection childMetaclasses) {
        HashSet children = (HashSet)NODES.get(metaclass);
        if (children == null) {
            children = new HashSet();
            NODES.put(metaclass, children);
        }
        children.addAll(childMetaclasses);
    }

    public static void addLink(String linkMetaclass, String source, String target) {
        MetaclassUtil.addLink(linkMetaclass, source, target, false);
    }

    public static void addLink(String linkMetaclass, String source, String target, boolean allowsSelf) {
        MetaclassUtil.addLink(linkMetaclass, source, target, allowsSelf, false);
    }

    public static void addReusableLink(String linkMetaclass, String source, String target, boolean allowsSelf) {
        MetaclassUtil.addLink(linkMetaclass, source, target, allowsSelf, true);
    }

    private static void addLink(String linkMetaclass, String source, String target, boolean allowsSelf, boolean shouldReuseExistLink) {
        ArrayList<LinkInfo> linkInfos = (ArrayList<LinkInfo>)LINKS.get(linkMetaclass);
        if (linkInfos == null) {
            linkInfos = new ArrayList<LinkInfo>();
            LINKS.put(linkMetaclass, linkInfos);
        }
        linkInfos.add(new LinkInfo(source, target, allowsSelf, shouldReuseExistLink));
    }

    private static void fillNodes() {
        MetaclassUtil.addChildren("Note", NONE);
        MetaclassUtil.addChildren("Package", Arrays.asList("Actor", "Use Case", "System Boundary", "Note"));
        MetaclassUtil.addChildren("Actor", NONE);
        MetaclassUtil.addChildren("Use Case", Collections.singleton("Extension Point"));
        MetaclassUtil.addChildren("System Boundary", Arrays.asList("Use Case", "Note"));
        MetaclassUtil.addChildren("Extension Point", NONE);
        MetaclassUtil.addChildren("Package", Arrays.asList("Object"));
        MetaclassUtil.addChildren("Package", Arrays.asList("State", "Start State", "End State", "Synchronization Bar", "Object"));
        MetaclassUtil.addChildren("Start State", NONE);
        MetaclassUtil.addChildren("End State", NONE);
        MetaclassUtil.addChildren("Object", NONE);
        MetaclassUtil.addChildren("Synchronization Bar", NONE);
        MetaclassUtil.addChildren("State", Arrays.asList("Internal Transition", "Deferred Event", "State", "Start State", "Synchronization Bar", "History", "End State", "Object", "Note"));
        MetaclassUtil.addChildren("Internal Transition", NONE);
        MetaclassUtil.addChildren("Deferred Event", NONE);
        MetaclassUtil.addChildren("History", NONE);
        MetaclassUtil.addChildren("Package", Arrays.asList("Activity", "Signal Receipt", "Signal Sending", "Swimlane", "Decision"));
        MetaclassUtil.addChildren("Activity", Arrays.asList("Internal Transition", "Deferred Event"));
        MetaclassUtil.addChildren("Signal Receipt", NONE);
        MetaclassUtil.addChildren("Signal Sending", NONE);
        MetaclassUtil.addChildren("Decision", NONE);
        MetaclassUtil.addChildren("Swimlane", Arrays.asList("State", "Activity", "Signal Receipt", "Signal Sending", "Decision", "Start State", "End State", "Synchronization Bar", "Object", "Note"));
        MetaclassUtil.addChildren("State", Arrays.asList("Activity", "Decision", "Signal Receipt", "Signal Sending"));
        MetaclassUtil.addChildren("Package", Arrays.asList("Subsystem", "Component"));
        MetaclassUtil.addChildren("Subsystem", Arrays.asList("Subsystem", "Component"));
        MetaclassUtil.addChildren("Component", Arrays.asList("Component", "Object"));
        MetaclassUtil.addChildren("Package", Arrays.asList("Node"));
        MetaclassUtil.addChildren("Node", Arrays.asList("Node", "Component", "Object"));
        MetaclassUtil.addChildren("Message Link", NONE);
        MetaclassUtil.addChildren("Messages Link", NONE);
    }

    private static void fillLinks() {
        MetaclassUtil.addLink("Note Link", "Note", ANY_ALLOWED);
        MetaclassUtil.addLink("Note Link", ANY_ALLOWED, "Note");
        MetaclassUtil.addLink("Association Link", "Actor", "Use Case");
        MetaclassUtil.addLink("Association Link", "Use Case", "Actor");
        MetaclassUtil.addLink("Extends Link", "Use Case", "Use Case", false);
        MetaclassUtil.addLink("Includes Link", "Use Case", "Use Case", false);
        MetaclassUtil.addLink("Generalization Link", "Actor", "Actor", false);
        MetaclassUtil.addLink("Generalization Link", "Use Case", "Use Case", false);
        MetaclassUtil.addLink("Association Link", "Object", "Object", true);
        MetaclassUtil.addLink("Dependency Link", "Message Link", "Operation", false);
        String[] transitionSources = new String[]{"Activity", "Signal Receipt", "Signal Sending", "Decision", "History", "State", "Start State", "Synchronization Bar"};
        String[] transitionTargets = new String[]{"Activity", "Signal Receipt", "Signal Sending", "Decision", "History", "State", "End State", "Synchronization Bar"};
        int i = 0;
        while (i < transitionSources.length) {
            int j = 0;
            while (j < transitionTargets.length) {
                MetaclassUtil.addLink("Transition", transitionSources[i], transitionTargets[j], true);
                ++j;
            }
            ++i;
        }
        MetaclassUtil.addLink("Object Flow", "Object", "Synchronization Bar");
        MetaclassUtil.addLink("Object Flow", "Object", "Activity");
        MetaclassUtil.addLink("Object Flow", "Object", "Signal Receipt");
        MetaclassUtil.addLink("Object Flow", "Synchronization Bar", "Object");
        MetaclassUtil.addLink("Object Flow", "Activity", "Object");
        MetaclassUtil.addLink("Object Flow", "Signal Sending", "Object");
        MetaclassUtil.addLink("Dependency Link", "Component", "Component", true);
        MetaclassUtil.addLink("Dependency Link", "Component", "Subsystem");
        MetaclassUtil.addLink("Dependency Link", "Subsystem", "Subsystem", true);
        MetaclassUtil.addLink("Dependency Link", "Subsystem", "Component");
        MetaclassUtil.addLink("Dependency Link", "Component", "Class");
        MetaclassUtil.addLink("Association Link", "Node", "Node", true);
        MetaclassUtil.addLink("Association Link", "Node", "Component");
        MetaclassUtil.addLink("Association Link", "Node", "Object");
        MetaclassUtil.addLink("Association Link", "Component", "Node");
        MetaclassUtil.addLink("Association Link", "Component", "Component", true);
        MetaclassUtil.addLink("Association Link", "Component", "Object");
        MetaclassUtil.addLink("Association Link", "Object", "Node");
        MetaclassUtil.addLink("Association Link", "Object", "Object", true);
        MetaclassUtil.addLink("Association Link", "Object", "Component");
        MetaclassUtil.addLink("Dependency Link", "Node", "Node", true);
        MetaclassUtil.addLink("Dependency Link", "Node", "Component");
        MetaclassUtil.addLink("Dependency Link", "Node", "Object");
        MetaclassUtil.addLink("Dependency Link", "Component", "Node");
        MetaclassUtil.addLink("Dependency Link", "Component", "Component", true);
        MetaclassUtil.addLink("Dependency Link", "Component", "Object");
        MetaclassUtil.addLink("Dependency Link", "Object", "Node");
        MetaclassUtil.addLink("Dependency Link", "Object", "Component");
        MetaclassUtil.addLink("Dependency Link", "Object", "Object", true);
        MetaclassUtil.addLink("Association Link", "Object", "Object", true);
    }

    static {
        MetaclassUtil.fillNodes();
        MetaclassUtil.fillLinks();
    }

    private static class LinkInfo {
        private String mySource;
        private String myTarget;
        private boolean myAllowsSelf;
        private boolean myShouldReuseExistLink;

        public LinkInfo(String source, String target, boolean allowsSelf, boolean shouldReuseExistLink) {
            this.mySource = source;
            this.myTarget = target;
            this.myAllowsSelf = allowsSelf;
            this.myShouldReuseExistLink = shouldReuseExistLink;
        }

        public String getSource() {
            return this.mySource;
        }

        public String getTarget() {
            return this.myTarget;
        }

        public boolean isSourceAllowed(String sourceMetaclass) {
            if (this.mySource.equals(sourceMetaclass)) {
                return true;
            }
            return this.mySource.equals(MetaclassUtil.ANY_ALLOWED) && !this.myTarget.equals(sourceMetaclass);
        }

        public boolean isTargetAllowed(String targetMetaclass) {
            if (this.myTarget.equals(targetMetaclass)) {
                return true;
            }
            return this.myTarget.equals(MetaclassUtil.ANY_ALLOWED) && !this.mySource.equals(targetMetaclass);
        }

        public boolean shouldReuseExistLink() {
            return this.myShouldReuseExistLink;
        }

        public boolean doesAllowSelf() {
            return this.myAllowsSelf;
        }
    }
}

