/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.design;

import com.tssap.selena.internal.dom.providers.AbstractPropertyProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.providers.internal.design.MetaclassUtil;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.PropertyAdapter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MetaChildNodesPropertyProvider
extends AbstractPropertyProvider
implements PropertyGetProvider {
    private static final List APPLICABLE_PROPERTIES = Arrays.asList("$meta:child:nodes", "$meta:children");

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        if (propertyName != null && !APPLICABLE_PROPERTIES.contains(propertyName)) {
            return false;
        }
        return element instanceof Entity;
    }

    public boolean isPropertyReadable(Element element, String propertyName) {
        return true;
    }

    public String getPropertyValue(Element element, String propertyName) {
        Iterator it = this.getChildMetaclasses(element.getPropertyValue("$metaclass")).iterator();
        if (it.hasNext()) {
            return (String)it.next();
        }
        return null;
    }

    public Property getProperty(Element element, String propertyName) {
        String propertyValue = this.getPropertyValue(element, propertyName);
        if (propertyValue == null) {
            return null;
        }
        return new PropertyAdapter(propertyName, propertyValue, element);
    }

    public boolean hasProperty(Element element, String propertyName) {
        return this.getPropertyValue(element, propertyName) != null;
    }

    public PropertyEnumeration properties(Element element) {
        Collection childMetaclasses = this.getChildMetaclasses(element.getPropertyValue("$metaclass"));
        LinkedList<PropertyAdapter> list = new LinkedList<PropertyAdapter>();
        Iterator it = childMetaclasses.iterator();
        while (it.hasNext()) {
            list.add(new PropertyAdapter("$meta:child:nodes", (String)it.next(), element));
        }
        return EnumerationConverter.toPropertyEnumeration(Collections.enumeration(list));
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        return this.properties(element);
    }

    public Collection getChildMetaclasses(String parentMetaclass) {
        String parentMetaclassProper = "Model".equals(parentMetaclass) ? "Package" : parentMetaclass;
        Collection allowed = MetaclassUtil.getAllowedChildNodesMetaclasses(parentMetaclassProper);
        return MetaclassUtil.getAllowedChildNodesMetaclasses(parentMetaclassProper);
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        return this.getChildMetaclasses(element.getPropertyValue("$metaclass")).contains(propertyValue);
    }
}

