/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.design;

import com.tssap.selena.dom.DesignNotion;
import com.tssap.selena.internal.dom.providers.AbstractPropertyProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.PropertyAdapter;
import com.tssap.selena.model.util.SingleEnumeration;

public class FilePropertyProvider
extends AbstractPropertyProvider
implements PropertyGetProvider {
    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        if (propertyName != null && !"$file".equals(propertyName)) {
            return false;
        }
        return super.isPropertyProviderApplicable(element, propertyName);
    }

    public boolean isPropertyReadable(Element element, String propertyName) {
        return true;
    }

    public String getPropertyValue(Element element, String propertyName) {
        DesignNotion propertyOwner = this.getPropertyOwner(element);
        if (propertyOwner == null) {
            return null;
        }
        return propertyOwner.getFile().getProjectRelativePath().toString();
    }

    public Property getProperty(Element element, String propertyName) {
        String propertyValue = this.getPropertyValue(element, propertyName);
        if (propertyValue == null) {
            return null;
        }
        return new PropertyAdapter(propertyName, propertyValue, element);
    }

    public boolean hasProperty(Element element, String propertyName) {
        return this.getPropertyValue(element, propertyName) != null;
    }

    public PropertyEnumeration properties(Element element) {
        return this.properties(element, "$file");
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        Property property = this.getProperty(element, propertyName);
        if (property == null) {
            return EmptyEnumeration.getPropertyEnumeration();
        }
        return SingleEnumeration.createPropertyEnumeration((Property)property);
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        return propertyValue != null && propertyValue.equals(this.getPropertyValue(element, propertyName));
    }
}

