/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.design;

import com.tssap.selena.internal.dom.providers.AbstractPropertyProvider;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.PropertyMap;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.util.SingleEnumeration;

public class DesignReadOnlyProvider
extends AbstractPropertyProvider
implements PropertyGetProvider {
    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return super.isPropertyProviderApplicable(element, propertyName) && this.isReadOnly((Entity)element);
    }

    public String getPropertyValue(Element element, String propertyName) {
        return this.getProperty(element, propertyName).getValue();
    }

    public Property getProperty(Element element, String propertyName) {
        return new ReadOnlyProperty(element);
    }

    public boolean hasProperty(Element element, String propertyName) {
        return true;
    }

    public PropertyEnumeration properties(Element element) {
        return this.properties(element, "$readOnly");
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        return SingleEnumeration.createPropertyEnumeration((Property)this.getProperty(element, propertyName));
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        return propertyValue.equals(this.getPropertyValue(element, propertyName));
    }

    private static class ReadOnlyProperty
    implements Property {
        private Element myOwner;

        public ReadOnlyProperty(Element owner) {
            this.myOwner = owner;
        }

        public boolean isWritable() {
            return false;
        }

        public boolean canSetValue(String newValue) {
            return false;
        }

        public Element getElement() {
            return this.myOwner;
        }

        public String getName() {
            return "$readOnly";
        }

        public PropertyMap getSubproperties() {
            return null;
        }

        public String getValue() {
            return Boolean.TRUE.toString();
        }

        public void setValue(String newValue) {
        }
    }
}

