/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.design;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignLink;
import com.tssap.selena.dom.DesignNotion;
import com.tssap.selena.dom.DesignParticipant;
import com.tssap.selena.internal.dom.providers.AbstractDesignProvider;
import com.tssap.selena.internal.dom.providers.NameUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.StringEnumeration;
import com.tssap.selena.model.enum.UniqueNameEnumeration;
import com.tssap.selena.model.extension.LinkProvider;
import com.tssap.selena.model.providers.internal.design.MetaclassUtil;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.SingleEnumeration;
import java.util.ArrayList;
import java.util.Collections;

public class DesignLinkProvider
extends AbstractDesignProvider
implements LinkProvider {
    public boolean isLinkProviderApplicable(Entity link) {
        return NameUtil.isDesignLinkUin((UniqueName)link.getUniqueName());
    }

    public StringEnumeration participantRoles(Entity link) {
        DesignLink designLink = (DesignLink)this.getDesignElement(link.getUniqueName());
        ArrayList<String> roles = new ArrayList<String>(2);
        if (designLink != null) {
            if (designLink.getSource() != null) {
                roles.add("Client");
            }
            if (designLink.getTarget() != null) {
                roles.add("Supplier");
            }
        }
        return EnumerationConverter.toStringEnumeration(Collections.enumeration(roles));
    }

    public UniqueNameEnumeration participants(Entity link, String role) {
        UniqueName participantUin;
        DesignLink designLink = (DesignLink)this.getDesignElement(link.getUniqueName());
        String proxyId = null;
        if (designLink != null) {
            DesignParticipant participant = null;
            if ("Client".equals(role)) {
                participant = designLink.getSource();
            }
            if ("Supplier".equals(role)) {
                participant = designLink.getTarget();
            }
            if (participant != null) {
                proxyId = participant.getProxyId();
            }
        }
        if ((participantUin = ModelAccess.createUniqueName(proxyId)) == null) {
            return EmptyEnumeration.getUniqueNameEnumeration();
        }
        return SingleEnumeration.createUniqueNameEnumeration((UniqueName)participantUin);
    }

    public boolean canSetParticipant(Entity link, String role, Element oldParticipant, Element newParticipant) {
        if (!this.isDesignRole(role)) {
            return false;
        }
        DesignLink designLink = (DesignLink)this.getDesignElement(link.getUniqueName());
        if (designLink == null || this.isReadOnly((DesignNotion)designLink)) {
            return false;
        }
        return MetaclassUtil.isValidParticipant(MetaclassUtil.getMetaclass((DesignElement)designLink), (DesignElement)designLink.getParent(), role, newParticipant);
    }

    public boolean canSetParticipant(Entity link, Element participant, String oldRole, String newRole) {
        return false;
    }

    public void setParticipant(Entity link, String role, Element oldParticipant, Element newParticipant) {
        DesignLink designLink = (DesignLink)this.getDesignElement(link.getUniqueName());
        if ("Client".equals(role)) {
            designLink.createSource(newParticipant.getUniqueName().toString());
        } else if ("Supplier".equals(role)) {
            designLink.createTarget(newParticipant.getUniqueName().toString());
        }
    }

    public void setParticipant(Entity link, Element participant, String oldRole, String newRole) {
    }

    private boolean isDesignRole(String role) {
        return "Client".equals(role) || "Supplier".equals(role);
    }
}

