/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.design;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.internal.dom.copypaste.DesignClipboardManager;
import com.tssap.selena.internal.dom.copypaste.IDesignClipboardCopy;
import com.tssap.selena.internal.dom.providers.AbstractDesignProvider;
import com.tssap.selena.internal.dom.providers.NameUtil;
import com.tssap.selena.model.elements.CopyUniqueName;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.extension.CopyProvider;
import com.tssap.selena.model.extension.CutProvider;
import com.tssap.selena.model.extension.ModelAware;
import com.tssap.selena.model.providers.internal.design.copypaste.ClipboardCopyCreator;
import com.tssap.selena.model.providers.internal.design.copypaste.PasteSequence;
import org.eclipse.core.runtime.CoreException;

public class DesignCopyCutProvider
extends AbstractDesignProvider
implements CopyProvider,
CutProvider,
ModelAware {
    private DesignClipboardManager myClipboardManager;

    public boolean isCopyProviderApplicable(Element element) {
        UniqueName uin = element.getUniqueName();
        return NameUtil.isDesignNodeUin((UniqueName)uin) || NameUtil.isDesignLinkUin((UniqueName)uin);
    }

    public boolean isCutProviderApplicable(Element element) {
        return this.isCopyProviderApplicable(element);
    }

    public boolean canCopy(Element element) {
        return this.getDesignElement(element.getUniqueName()) != null;
    }

    public boolean canCut(Element element) {
        return !this.isReadOnly((Entity)element) && this.canCopy(element);
    }

    public void cut(Element element, CopyUniqueName copyUin) {
        DesignElement designElement = this.getDesignElement(element.getUniqueName());
        PasteSequence pasteSequence = this.copy(designElement, true);
        if (pasteSequence != null) {
            this.myClipboardManager.addCopy((UniqueName)copyUin, (IDesignClipboardCopy)pasteSequence);
        }
        designElement.delete();
    }

    public void copy(Element element, CopyUniqueName copyUin) {
        DesignElement designElement = this.getDesignElement(element.getUniqueName());
        CopyUniqueName result = copyUin;
        PasteSequence pasteSequence = this.copy(designElement, false);
        if (pasteSequence != null) {
            this.myClipboardManager.addCopy((UniqueName)result, (IDesignClipboardCopy)pasteSequence);
        }
    }

    private PasteSequence copy(DesignElement designElement, boolean restoreIncomingLinks) {
        PasteSequence pasteSequence = null;
        try {
            pasteSequence = new ClipboardCopyCreator(ModelAccess.getModel((UniqueName)this.getModelUin()), designElement, restoreIncomingLinks).serialize();
        }
        catch (CoreException fails) {
            fails.printStackTrace();
        }
        return pasteSequence;
    }

    public void registered(Model model) {
        super.registered(model);
        if (this.myClipboardManager == null) {
            this.myClipboardManager = DesignClipboardManager.getInstance((Model)model);
        }
    }

    public void unregistered(Model model) {
        if (this.myClipboardManager != null) {
            this.myClipboardManager.clearAll();
            this.myClipboardManager = null;
        }
        super.unregistered(model);
    }
}

