/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.internal.design;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignLink;
import com.tssap.selena.dom.DesignParticipant;
import com.tssap.selena.dom.nodeset.NodeSetCache;
import com.tssap.selena.internal.dom.providers.AbstractDefaultValuePropertyProvider;
import com.tssap.selena.internal.dom.providers.NameUtil;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;

public class DefaultLinkNamePropertyProvider
extends AbstractDefaultValuePropertyProvider {
    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return NameUtil.isDesignLinkUin((UniqueName)element.getUniqueName());
    }

    protected String getDefaultPropertyValue(Element element, String propertyName) {
        Model model = element.getModel();
        NodeSetCache nodeSetCache = NodeSetCache.getCache((UniqueName)model.getUniqueName());
        if (nodeSetCache == null) {
            return null;
        }
        DesignElement designElement = NameUtil.getElement((NodeSetCache)nodeSetCache, (UniqueName)element.getUniqueName());
        if (designElement instanceof DesignLink) {
            DesignLink link = (DesignLink)designElement;
            return "Link: " + DefaultLinkNamePropertyProvider.resolve2ParticipantName(model, link.getSource()) + " -> " + DefaultLinkNamePropertyProvider.resolve2ParticipantName(model, link.getTarget());
        }
        return null;
    }

    public PropertyEnumeration properties(Element element) {
        return this.properties(element, "$name");
    }

    private static String resolve2ParticipantName(Model model, DesignParticipant participant) {
        if (participant == null) {
            return "";
        }
        String proxyID = participant.getProxyId();
        if (proxyID == null) {
            return "";
        }
        UniqueName participantUin = ModelAccess.createUniqueName((String)proxyID);
        if (participantUin == null) {
            return "";
        }
        Entity modelParticipant = model.findEntity(participantUin);
        if (modelParticipant == null) {
            return null;
        }
        return modelParticipant.getPropertyValue("$name");
    }
}

