/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.providers.design.copy;

import com.tssap.selena.dom.DesignElement;
import com.tssap.selena.dom.DesignProperty;
import com.tssap.selena.dom.nodeset.NodeSetCache;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.providers.design.copy.IDesignCopyExtender;
import java.util.Map;

public class PropertyCopyExtender
implements IDesignCopyExtender {
    private UniqueName[] myOriginalValues;
    private final String myPropertyName;
    private final boolean myShouldClearNotSubstitutableValues;

    public PropertyCopyExtender(String propertyName) {
        this(propertyName, false);
    }

    public PropertyCopyExtender(String propertyName, boolean shouldClearNotSubstitutableValues) {
        this.myPropertyName = propertyName;
        this.myShouldClearNotSubstitutableValues = shouldClearNotSubstitutableValues;
    }

    public void createCopyExtension(NodeSetCache cache, DesignElement element, boolean isCut) {
        DesignProperty[] props = element.getProperties(this.myPropertyName);
        if (props.length == 0) {
            return;
        }
        this.myOriginalValues = new UniqueName[props.length];
        int i = 0;
        while (i < props.length) {
            String nextUinStr = props[i].getValue();
            this.myOriginalValues[i] = ModelAccess.createUniqueName((String)nextUinStr);
            ++i;
        }
    }

    public void applyCopyExtension(Entity parent, Map substitutionMap) {
        if (this.myOriginalValues == null) {
            return;
        }
        parent.setPropertyValue(this.myPropertyName, null);
        int i = 0;
        while (i < this.myOriginalValues.length) {
            UniqueName oldUin = this.myOriginalValues[i];
            UniqueName substitutedUin = this.myShouldClearNotSubstitutableValues ? null : oldUin;
            Entity substitutedEntity = (Entity)substitutionMap.get(oldUin);
            if (substitutedEntity != null) {
                substitutedUin = substitutedEntity.getUniqueName();
            }
            if (substitutedUin != null) {
                parent.addProperty(this.myPropertyName, substitutedUin.toString());
            }
            ++i;
        }
    }
}

